/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Unary
extends Lop {
    private Types.OpOp1 operation;
    private Lop valInput;
    private int _numThreads = 1;
    private boolean _inplace = false;

    public Unary(Lop input1, Lop input2, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        super(Lop.Type.UNARY, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this._numThreads = numThreads;
    }

    private void init(Lop input1, Lop input2, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.operation = op;
        this.valInput = input1.getDataType() == Types.DataType.MATRIX ? input2 : input1;
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    public Unary(Lop input1, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads, boolean inplace) {
        super(Lop.Type.UNARY, dt, vt);
        this.init(input1, op, dt, vt, et);
        this._numThreads = numThreads;
        this._inplace = inplace;
    }

    private void init(Lop input1, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        if ((op == Types.OpOp1.INVERSE || op == Types.OpOp1.CHOLESKY) && et == Types.ExecType.SPARK) {
            throw new LopsException("Invalid exection type " + et.toString() + " for operation " + op.toString());
        }
        this.operation = op;
        this.valInput = null;
        this.addInput(input1);
        input1.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        if (this.valInput != null) {
            return "Operation: " + this.operation + " Label: " + this.valInput.getOutputParameters().getLabel() + " input types " + this.getInput(0).toString() + " " + this.getInput(1).toString();
        }
        if (this.getInput(0) != null) {
            return "Operation: " + this.operation + " In: " + this.getInput(0) + " " + this.lps;
        }
        return "Operation: " + this.operation + " Label: N/A";
    }

    private String getOpcode() {
        return this.operation.toString();
    }

    public static boolean isMultiThreadedOp(Types.OpOp1 op) {
        return op == Types.OpOp1.CUMSUM || op == Types.OpOp1.CUMPROD || op == Types.OpOp1.CUMMIN || op == Types.OpOp1.CUMMAX || op == Types.OpOp1.CUMSUMPROD || op == Types.OpOp1.EXP || op == Types.OpOp1.LOG || op == Types.OpOp1.ABS || op == Types.OpOp1.ROUND || op == Types.OpOp1.FLOOR || op == Types.OpOp1.CEIL || op == Types.OpOp1.SIGMOID || op == Types.OpOp1.POW2 || op == Types.OpOp1.MULT2;
    }

    private void appendFedOut(StringBuilder sb) {
        if (this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._fedOutput.name());
        }
    }

    @Override
    public String getInstructions(String input1, String output) {
        if (this.getInputs().size() != 1) {
            throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for an Unary opration: " + this.operation);
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP || this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
            if (Unary.isMultiThreadedOp(this.operation)) {
                sb.append("\u00b0");
                sb.append(this._inplace);
            }
        }
        this.appendFedOut(sb);
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        if (this.getInputs().get(0).getDataType() == Types.DataType.SCALAR) {
            sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(0).prepInputOperand(input1));
        }
        sb.append("\u00b0");
        if (this.getInputs().get(1).getDataType() == Types.DataType.SCALAR) {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP || this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        this.appendFedOut(sb);
        return sb.toString();
    }
}

