/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.utils.MemoryEstimates;

public abstract class AColGroupOffset
extends APreAgg {
    private static final long serialVersionUID = -4105103687174067602L;
    protected final int[] _ptr;
    protected final char[] _data;
    protected final int _numRows;
    protected final boolean _zeros;

    protected AColGroupOffset(IColIndex colIndices, int numRows, boolean zeros, IDictionary dict, int[] ptr, char[] data, int[] cachedCounts) {
        super(colIndices, dict, cachedCounts);
        this._numRows = numRows;
        this._zeros = zeros;
        this._ptr = ptr;
        this._data = data;
    }

    protected final int len(int k) {
        return this._ptr[k + 1] - this._ptr[k];
    }

    protected static void createCompressedBitmaps(int[] bitmap, char[] data, char[][] lbitmaps) {
        int off = 0;
        for (int i = 0; i < bitmap.length - 1; ++i) {
            int len = lbitmaps[i].length;
            bitmap[i] = off;
            System.arraycopy(lbitmaps[i], 0, data, off, len);
            off += len;
        }
        bitmap[bitmap.length - 1] = data.length;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._ptr.length));
        size = (long)((double)size + MemoryEstimates.charArrayCost(this._data.length));
        return size += 8L;
    }

    protected int[] computeOffsets(boolean[] ind) {
        int numOffsets = 0;
        for (int i = 0; i < ind.length; ++i) {
            numOffsets += ind[i] ? 1 : 0;
        }
        int[] ret = new int[numOffsets];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!ind[i]) continue;
            ret[pos++] = i;
        }
        return ret;
    }

    public static int[] readPointers(DataInput in) throws IOException {
        int[] ptr = new int[in.readInt()];
        for (int i = 0; i < ptr.length; ++i) {
            ptr[i] = in.readInt();
        }
        return ptr;
    }

    public static char[] readData(DataInput in) throws IOException {
        char[] data = new char[in.readInt()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = in.readChar();
        }
        return data;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeInt(this._ptr.length);
        for (i = 0; i < this._ptr.length; ++i) {
            out.writeInt(this._ptr[i]);
        }
        out.writeInt(this._data.length);
        for (i = 0; i < this._data.length; ++i) {
            out.writeChar(this._data[i]);
        }
        out.writeBoolean(this._zeros);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += 4L;
        ret += (long)(4 * this._ptr.length);
        ret += 4L;
        ret += (long)(2 * this._data.length);
        return ++ret;
    }

    public boolean containZerosTuples() {
        return this._zeros;
    }
}

