/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;

public class CompressionStatistics {
    public long originalSize;
    public long denseSize;
    public long sparseSize;
    public long estimatedSizeCols;
    public long estimatedSizeCoCoded;
    public long compressedInitialSize;
    public long compressedSize;
    public double originalCost = Double.NaN;
    public double estimatedCostCols = Double.NaN;
    public double estimatedCostCoCoded = Double.NaN;
    public double compressedInitialCost = Double.NaN;
    public double compressedCost = Double.NaN;
    private Map<String, int[]> colGroupCounts;

    protected void setColGroupsCounts(List<AColGroup> colGroups) {
        HashMap<String, int[]> ret = new HashMap<String, int[]>();
        for (AColGroup c : colGroups) {
            int[] values;
            String ct = c.getClass().getSimpleName();
            int colCount = c.getNumCols();
            if (ret.containsKey(ct)) {
                values = ret.get(ct);
                values[0] = values[0] + 1;
                values[1] = values[1] + colCount;
            } else {
                values = new int[]{1, colCount};
            }
            ret.put(ct, values);
        }
        this.colGroupCounts = ret;
    }

    public String getGroupsTypesString() {
        StringBuilder sb = new StringBuilder();
        for (String ctKey : this.colGroupCounts.keySet()) {
            sb.append(ctKey + ":" + this.colGroupCounts.get(ctKey)[0] + " ");
        }
        return sb.toString();
    }

    public String getGroupsSizesString() {
        StringBuilder sb = new StringBuilder();
        for (String ctKey : this.colGroupCounts.keySet()) {
            sb.append(ctKey + ":" + this.colGroupCounts.get(ctKey)[1] + " ");
        }
        return sb.toString();
    }

    public double getRatio() {
        return (double)this.compressedSize == 0.0 ? Double.POSITIVE_INFINITY : (double)this.originalSize / (double)this.compressedSize;
    }

    public double getDenseRatio() {
        return (double)this.compressedSize == 0.0 ? Double.POSITIVE_INFINITY : (double)this.denseSize / (double)this.compressedSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nCompressionStatistics:");
        sb.append("\nDense Size            : " + this.denseSize);
        sb.append("\nOriginal Size         : " + this.originalSize);
        sb.append("\nCompressed Size       : " + this.compressedSize);
        sb.append("\nCompressionRatio      : " + this.getRatio());
        sb.append("\nDenseCompressionRatio : " + this.getDenseRatio());
        if (this.colGroupCounts != null) {
            sb.append("\nCompressionTypes      : " + this.getGroupsTypesString());
            sb.append("\nCompressionGroupSizes : " + this.getGroupsSizesString());
        }
        return sb.toString();
    }
}

