/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CharArray
extends Array<Character> {
    private char[] _data;

    public CharArray(char[] data) {
        super(data.length);
        this._data = data;
    }

    public char[] get() {
        return this._data;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.CHARACTER.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readChar();
        }
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this._data[index]);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    @Override
    public void set(int index, Character value) {
        this._data[index] = value != null ? value.charValue() : (char)'\u0000';
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = CharArray.parseChar(Double.toString(value));
    }

    @Override
    public void set(int index, String value) {
        this._data[index] = CharArray.parseChar(value);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = value.get(i).toString().charAt(0);
        }
    }

    @Override
    public void set(int rl, int ru, Array<Character> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void set(int rl, int ru, Array<Character> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Character> value) {
        char[] data2 = ((CharArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == '\u0000') continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            char v = UtilFunctions.objectToCharacter(vt, value.get(i));
            if (v == '\u0000') continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(Character.valueOf(CharArray.parseChar(value)));
    }

    @Override
    public void append(Character value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value.charValue() : (char)'\u0000';
    }

    @Override
    public Array<Character> append(Array<Character> other) {
        int endSize = this._size + other.size();
        char[] ret = new char[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new CharArray(ret));
        }
        return new CharArray(ret);
    }

    @Override
    public Array<Character> slice(int rl, int ru) {
        return new CharArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new char[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = '\u0000';
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer charBuffer = ByteBuffer.allocate(2 * this._size);
        charBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            charBuffer.putChar(this._data[i]);
        }
        return charBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.CHARACTER;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.CHARACTER, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.CHARACTER;
    }

    @Override
    public long getExactSerializedSize() {
        return 1L + 2L * (long)this._data.length;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            char di = this._data[i];
            if (di != '\u0000' && di != '\u0001') {
                throw new DMLRuntimeException("Unable to change to boolean from char array because of value:" + this._data[i] + " (as int: " + di + ")");
            }
            ret.set(i, di != '\u0000');
        }
        return new BitSetArray(ret, this.size());
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            char di = this._data[i];
            if (di != '\u0000' && di != '\u0001') {
                throw new DMLRuntimeException("Unable to change to boolean from char array because of value:" + this._data[i] + " (as int: " + di + ")");
            }
            ret[i] = di != '\u0000';
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new HashLongArray(ret);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = String.valueOf(this._data[i]);
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        return this;
    }

    @Override
    public void fill(String val) {
        this.fill(Character.valueOf(CharArray.parseChar(val)));
    }

    @Override
    public void fill(Character value) {
        value = Character.valueOf(value != null ? value.charValue() : (char)'\u0000');
        Arrays.fill(this._data, value.charValue());
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public Array<Character> clone() {
        return new CharArray(Arrays.copyOf(this._data, this._size));
    }

    public static char parseChar(String value) {
        if (value == null) {
            return '\u0000';
        }
        if (value.length() == 1) {
            return value.charAt(0);
        }
        if (FrameUtil.isIntType(value, value.length()) != null) {
            return (char)Double.parseDouble(value);
        }
        throw new DMLRuntimeException("Invalid parsing of Character");
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == '\u0000') continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Character> select(int[] indices) {
        char[] ret = new char[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new CharArray(ret);
    }

    @Override
    public Array<Character> select(boolean[] select, int nTrue) {
        char[] ret = new char[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new CharArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != '\u0000';
    }

    @Override
    public double hashDouble(int idx) {
        return Character.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Character> other) {
        if (other instanceof CharArray) {
            return Arrays.equals(this._data, ((CharArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 2 + 15);
        sb.append(super.toString());
        sb.append(":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i]);
            sb.append(',');
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

