/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import ch.randelshofer.fastdoubleparser.JavaFloatParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class FloatArray
extends Array<Float> {
    private float[] _data;

    public FloatArray(float[] data) {
        super(data.length);
        this._data = data;
    }

    public float[] get() {
        return this._data;
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this._data[index]);
    }

    @Override
    public void set(int index, Float value) {
        this._data[index] = value != null ? value.floatValue() : 0.0f;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (float)value;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, (double)FloatArray.parseFloat(value));
    }

    @Override
    public void set(int rl, int ru, Array<Float> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = UtilFunctions.objectToFloat(vt, value.get(i));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Float> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Float> value) {
        float[] data2 = ((FloatArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == 0.0f) continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            float v = UtilFunctions.objectToFloat(vt, value.get(i));
            if (v == 0.0f) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(Float.valueOf(FloatArray.parseFloat(value)));
    }

    @Override
    public void append(Float value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value.floatValue() : 0.0f;
    }

    @Override
    public Array<Float> append(Array<Float> other) {
        int endSize = this._size + other.size();
        float[] ret = new float[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new FloatArray(ret));
        }
        return new FloatArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.FP32.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeFloat(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readFloat();
        }
    }

    @Override
    public Array<Float> clone() {
        return new FloatArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Float> slice(int rl, int ru) {
        return new FloatArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new float[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0.0f;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer floatBuffer = ByteBuffer.allocate(8 * this._size);
        floatBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            floatBuffer.putFloat(this._data[i]);
        }
        return floatBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.FP32;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.FP32, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.FP32;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.floatArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 4 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0.0f && this._data[i] != 1.0f) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0.0f);
        }
        return new BitSetArray(ret, this.size());
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0.0f && this._data[i] != 1.0f) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0.0f;
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != (float)((int)this._data[i])) {
                throw new DMLRuntimeException("Unable to change to integer from float array because of value:" + this._data[i]);
            }
            ret[i] = (int)this._data[i];
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (int)this._data[i];
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (int)this._data[i];
        }
        return new HashLongArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        return this;
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = CharArray.parseChar(this.get(i).toString());
        }
        return new CharArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(Float.valueOf(FloatArray.parseFloat(value)));
    }

    @Override
    public void fill(Float value) {
        value = Float.valueOf(value != null ? value.floatValue() : 0.0f);
        Arrays.fill(this._data, value.floatValue());
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static float parseFloat(String value) {
        if (value == null) {
            return 0.0f;
        }
        int len = value.length();
        if (len == 0) {
            return 0.0f;
        }
        try {
            return JavaFloatParser.parseFloat((CharSequence)value, (int)0, (int)len);
        }
        catch (NumberFormatException e) {
            if (len == 3 && value.compareToIgnoreCase("Inf") == 0) {
                return Float.POSITIVE_INFINITY;
            }
            if (len == 4 && value.compareToIgnoreCase("-Inf") == 0) {
                return Float.NEGATIVE_INFINITY;
            }
            throw new DMLRuntimeException(e);
        }
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (!this.isNotEmpty(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Float> select(int[] indices) {
        float[] ret = new float[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new FloatArray(ret);
    }

    @Override
    public Array<Float> select(boolean[] select, int nTrue) {
        float[] ret = new float[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new FloatArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0.0f;
    }

    @Override
    public double hashDouble(int idx) {
        return Float.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Float> other) {
        if (other instanceof FloatArray) {
            return Arrays.equals(this._data, ((FloatArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

