/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataOutput;

public class FastBufferedDataOutputStream
extends FilterOutputStream
implements DataOutput,
MatrixBlockDataOutput {
    protected byte[] _buff;
    protected int _bufflen;
    protected int _count;

    public FastBufferedDataOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public FastBufferedDataOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0.");
        }
        if (size % 8 != 0) {
            throw new IllegalArgumentException("Buffer size not a multiple of 8.");
        }
        this._buff = new byte[size];
        this._bufflen = size;
    }

    @Override
    public void write(int b) throws IOException {
        if (this._count >= this._bufflen) {
            this.flushBuffer();
        }
        this._buff[this._count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this._bufflen) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this._bufflen - this._count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this._buff, this._count, len);
        this._count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this._count > 0) {
            this.out.write(this._buff, 0, this._count);
            this._count = 0;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this._count >= this._bufflen) {
            this.flushBuffer();
        }
        this._buff[this._count++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this._count + 4 > this._bufflen) {
            this.flushBuffer();
        }
        FastBufferedDataOutputStream.intToBa(v, this._buff, this._count);
        this._count += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this._count + 8 > this._bufflen) {
            this.flushBuffer();
        }
        FastBufferedDataOutputStream.longToBa(v, this._buff, this._count);
        this._count += 8;
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this._count + 8 > this._bufflen) {
            this.flushBuffer();
        }
        long tmp = Double.doubleToRawLongBits(v);
        FastBufferedDataOutputStream.longToBa(tmp, this._buff, this._count);
        this._count += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this._count + 4 > this._bufflen) {
            this.flushBuffer();
        }
        int tmp = Float.floatToIntBits(v);
        FastBufferedDataOutputStream.intToBa(tmp, this._buff, this._count);
        this._count += 8;
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this._count + 1 > this._bufflen) {
            this.flushBuffer();
        }
        this._buff[this._count++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this._count + 2 > this._bufflen) {
            this.flushBuffer();
        }
        FastBufferedDataOutputStream.shortToBa(v, this._buff, this._count);
        this._count += 2;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int slen = s.length();
        int utflen = IOUtilFunctions.getUTFSize(s) - 2;
        if (utflen - 2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen);
        }
        this.writeShort(utflen);
        for (int i = 0; i < slen; ++i) {
            char c;
            if (this._count + 3 > this._bufflen) {
                this.flushBuffer();
            }
            if ((c = s.charAt(i)) >= '\u0001' && c <= '\u007f') {
                this._buff[this._count++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                this._buff[this._count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this._buff[this._count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._buff[this._count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this._buff[this._count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this._buff[this._count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public void writeDoubleArray(int len, double[] varr) throws IOException {
        this.flushBuffer();
        int blen = this._bufflen / 8;
        for (int i = 0; i < len; i += Math.min(len - i, blen)) {
            int lblen = Math.min(len - i, blen);
            for (int j = 0; j < lblen; ++j) {
                long tmp = Double.doubleToRawLongBits(varr[i + j]);
                FastBufferedDataOutputStream.longToBa(tmp, this._buff, this._count);
                this._count += 8;
            }
            this.flushBuffer();
        }
    }

    @Override
    public void writeSparseRows(int rlen, SparseBlock rows) throws IOException {
        int i;
        int lrlen = Math.min(rows.numRows(), rlen);
        for (i = 0; i < lrlen; ++i) {
            if (!rows.isEmpty(i)) {
                long tmp2;
                int j;
                int apos = rows.pos(i);
                int alen = rows.size(i);
                int alen2 = alen * 12;
                int[] aix = rows.indexes(i);
                double[] avals = rows.values(i);
                this.writeInt(alen);
                if (alen2 < this._bufflen) {
                    if (this._count + alen2 > this._bufflen) {
                        this.flushBuffer();
                    }
                    for (j = apos; j < apos + alen; ++j) {
                        tmp2 = Double.doubleToRawLongBits(avals[j]);
                        FastBufferedDataOutputStream.intToBa(aix[j], this._buff, this._count);
                        FastBufferedDataOutputStream.longToBa(tmp2, this._buff, this._count + 4);
                        this._count += 12;
                    }
                    continue;
                }
                for (j = apos; j < apos + alen; ++j) {
                    if (this._count + 12 > this._bufflen) {
                        this.flushBuffer();
                    }
                    tmp2 = Double.doubleToRawLongBits(avals[j]);
                    FastBufferedDataOutputStream.intToBa(aix[j], this._buff, this._count);
                    FastBufferedDataOutputStream.longToBa(tmp2, this._buff, this._count + 4);
                    this._count += 12;
                }
                continue;
            }
            this.writeInt(0);
        }
        for (i = lrlen; i < rlen; ++i) {
            this.writeInt(0);
        }
    }

    private static void shortToBa(int val, byte[] ba, int off) {
        IOUtilFunctions.shortToBa(val, ba, off);
    }

    private static void intToBa(int val, byte[] ba, int off) {
        IOUtilFunctions.intToBa(val, ba, off);
    }

    private static void longToBa(long val, byte[] ba, int off) {
        IOUtilFunctions.longToBa(val, ba, off);
    }
}

