/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UTF16;

final class ScriptIterator {
    private char[] text;
    private int start;
    private int limit;
    private int index;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private final boolean combineCJ;
    private static final int[] basicLatin = new int[128];

    ScriptIterator(boolean combineCJ) {
        this.combineCJ = combineCJ;
    }

    int getScriptStart() {
        return this.scriptStart;
    }

    int getScriptLimit() {
        return this.scriptLimit;
    }

    int getScriptCode() {
        return this.scriptCode;
    }

    boolean next() {
        int ch;
        int sc;
        if (this.scriptLimit >= this.limit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while (this.index < this.limit && (ScriptIterator.isSameScript(this.scriptCode, sc = this.getScript(ch = UTF16.charAt(this.text, this.start, this.limit, this.index - this.start))) || UCharacter.getType(ch) == 6)) {
            this.index += UTF16.getCharCount(ch);
            if (this.scriptCode > 1 || sc <= 1) continue;
            this.scriptCode = sc;
        }
        this.scriptLimit = this.index;
        return true;
    }

    private static boolean isSameScript(int scriptOne, int scriptTwo) {
        return scriptOne <= 1 || scriptTwo <= 1 || scriptOne == scriptTwo;
    }

    void setText(char[] text, int start, int length) {
        this.text = text;
        this.start = start;
        this.index = start;
        this.limit = start + length;
        this.scriptStart = start;
        this.scriptLimit = start;
        this.scriptCode = -1;
    }

    private int getScript(int codepoint) {
        if (0 <= codepoint && codepoint < basicLatin.length) {
            return basicLatin[codepoint];
        }
        int script = UScript.getScript(codepoint);
        if (this.combineCJ) {
            if (script == 17 || script == 20 || script == 22) {
                return 105;
            }
            if (codepoint >= 65296 && codepoint <= 65305) {
                return 25;
            }
            return script;
        }
        return script;
    }

    static {
        for (int i = 0; i < basicLatin.length; ++i) {
            ScriptIterator.basicLatin[i] = UScript.getScript(i);
        }
    }
}

