/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tika.eval.app.reports.XLSXNumFormatter;
import org.apache.tika.eval.app.reports.XSLXCellFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report {
    private static final Logger LOG = LoggerFactory.getLogger(Report.class);
    final String NULL_VALUE = "";
    Map<String, XSLXCellFormatter> cellFormatters = new HashMap<String, XSLXCellFormatter>();
    String sql;
    String reportFilename;
    boolean includeSql = true;
    String reportName;
    private XLSXNumFormatter defaultDoubleFormatter = new XLSXNumFormatter("0.000");
    private XLSXNumFormatter defaultIntegerFormatter = new XLSXNumFormatter("0");
    private CellStyle sqlCellStyle;

    public void writeReport(Connection c, Path reportsRoot) throws SQLException, IOException {
        LOG.info("Writing report: {} to {}", (Object)this.reportName, (Object)this.reportFilename);
        long start = System.currentTimeMillis();
        this.dumpXLSX(c, reportsRoot);
        long elapsed = System.currentTimeMillis() - start;
        LOG.info("Finished writing {} report in {} ms", (Object)reportsRoot, (Object)elapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpXLSX(Connection c, Path reportsRoot) throws IOException, SQLException {
        try (Statement st = c.createStatement();){
            Path out = reportsRoot.resolve(this.reportFilename);
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            SXSSFWorkbook wb = new SXSSFWorkbook(new XSSFWorkbook(), 100, true, true);
            wb.setCompressTempFiles(true);
            this.defaultIntegerFormatter.reset(wb.getXSSFWorkbook());
            this.defaultDoubleFormatter.reset(wb.getXSSFWorkbook());
            this.sqlCellStyle = wb.createCellStyle();
            this.sqlCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
            this.sqlCellStyle.setWrapText(true);
            try {
                this.dumpReportToWorkbook(st, wb);
                return;
            }
            finally {
                try (OutputStream os = Files.newOutputStream(out, new OpenOption[0]);){
                    wb.write(os);
                }
                finally {
                    wb.close();
                }
            }
        }
    }

    private void dumpReportToWorkbook(Statement st, SXSSFWorkbook wb) throws SQLException {
        SXSSFSheet sheet;
        try (ResultSet rs = st.executeQuery(this.sql);){
            sheet = wb.createSheet("tika-eval Report");
            sheet.trackColumnForAutoSizing(0);
            int rowCount = 0;
            ResultSetMetaData meta = rs.getMetaData();
            SXSSFRow xssfRow = sheet.createRow(rowCount++);
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Cell cell = xssfRow.createCell(i - 1);
                cell.setCellValue(meta.getColumnLabel(i));
            }
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            while (rs.next()) {
                xssfRow = sheet.createRow(rowCount++);
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    Cell cell = xssfRow.createCell(i - 1);
                    XSLXCellFormatter formatter = this.cellFormatters.get(meta.getColumnLabel(i));
                    if (formatter == null) {
                        formatter = this.getDefaultFormatter(resultSetMetaData.getColumnType(i));
                    }
                    if (formatter != null) {
                        formatter.applyStyleAndValue(i, rs, cell);
                        continue;
                    }
                    this.writeCell(meta, i, rs, cell);
                }
            }
        }
        sheet.autoSizeColumn(0);
        if (!this.includeSql) {
            return;
        }
        SXSSFSheet sqlSheet = wb.createSheet("tika-eval SQL");
        sqlSheet.setColumnWidth(0, 25000);
        SXSSFRow sqlRow = sqlSheet.createRow(0);
        short height = 5000;
        sqlRow.setHeight(height);
        Cell cell = sqlRow.createCell(0);
        cell.setCellStyle(this.sqlCellStyle);
        cell.setCellValue(this.sql.trim());
    }

    private XSLXCellFormatter getDefaultFormatter(int columnType) {
        switch (columnType) {
            case 4: {
                return this.defaultIntegerFormatter;
            }
            case 3: 
            case 6: 
            case 8: {
                return this.defaultDoubleFormatter;
            }
        }
        return null;
    }

    private void writeCell(ResultSetMetaData meta, int colIndex, ResultSet rs, Cell cell) throws SQLException {
        switch (meta.getColumnType(colIndex)) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                double dbl = rs.getDouble(colIndex);
                if (rs.wasNull()) {
                    cell.setCellValue("");
                    break;
                }
                cell.setCellValue(dbl);
                break;
            }
            case -16: 
            case 1: 
            case 12: 
            case 16: {
                String val = rs.getString(colIndex);
                if (rs.wasNull()) {
                    cell.setCellValue("");
                    break;
                }
                cell.setCellValue(val);
                break;
            }
            default: {
                if (rs.wasNull()) {
                    cell.setCellValue("");
                } else {
                    cell.setCellValue(rs.getString(colIndex));
                }
                LOG.warn("Couldn't find type for: {}. Defaulting to String", (Object)meta.getColumnType(colIndex));
            }
        }
    }
}

