/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;

public final class StringFactory {
    private static final String V = "v";
    private static final String E = "e";
    private static final String P = "p";
    private static final String VP = "vp";
    private static final String PATH = "path";
    private static final String L_BRACKET = "[";
    private static final String R_BRACKET = "]";
    private static final String COMMA_SPACE = ", ";
    private static final String DASH = "-";
    private static final String ARROW = "->";
    private static final String EMPTY_PROPERTY = "p[empty]";
    private static final String EMPTY_VERTEX_PROPERTY = "vp[empty]";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String STORAGE = "storage";
    private static final String featuresStartWith = "supports";
    private static final int prefixLength = "supports".length();

    private StringFactory() {
    }

    public static String vertexString(Vertex vertex) {
        return "v[" + vertex.id() + R_BRACKET;
    }

    public static String edgeString(Edge edge) {
        return "e[" + edge.id() + "][" + edge.outVertex().id() + DASH + edge.label() + ARROW + edge.inVertex().id() + R_BRACKET;
    }

    public static String propertyString(Property property) {
        if (property instanceof VertexProperty) {
            if (!property.isPresent()) {
                return EMPTY_VERTEX_PROPERTY;
            }
            String valueString = String.valueOf(property.value());
            return "vp[" + property.key() + ARROW + StringUtils.abbreviate((String)valueString, (int)20) + R_BRACKET;
        }
        if (!property.isPresent()) {
            return EMPTY_PROPERTY;
        }
        String valueString = String.valueOf(property.value());
        return "p[" + property.key() + ARROW + StringUtils.abbreviate((String)valueString, (int)20) + R_BRACKET;
    }

    public static String graphString(Graph graph, String internalString) {
        return graph.getClass().getSimpleName().toLowerCase() + L_BRACKET + internalString + R_BRACKET;
    }

    public static String graphVariablesString(Graph.Variables variables) {
        return "variables[size:" + variables.keys().size() + R_BRACKET;
    }

    public static String memoryString(Memory memory) {
        return "memory[size:" + memory.keys().size() + R_BRACKET;
    }

    public static String computeResultString(ComputerResult computerResult) {
        return "result[" + computerResult.graph() + "," + computerResult.memory() + R_BRACKET;
    }

    public static String graphComputerString(GraphComputer graphComputer) {
        return graphComputer.getClass().getSimpleName().toLowerCase();
    }

    public static String traversalSourceString(TraversalSource traversalSource) {
        String graphString = traversalSource.getGraph().toString();
        Optional<Computer> optional = VertexProgramStrategy.getComputer(traversalSource.getStrategies());
        return traversalSource.getClass().getSimpleName().toLowerCase() + L_BRACKET + graphString + COMMA_SPACE + (optional.isPresent() ? optional.get().toString() : "standard") + R_BRACKET;
    }

    public static String featureString(Graph.Features features) {
        StringBuilder sb = new StringBuilder("FEATURES");
        Predicate<Method> supportMethods = m -> m.getModifiers() == 1 && m.getName().startsWith(featuresStartWith) && !m.getName().equals(featuresStartWith);
        sb.append(LINE_SEPARATOR);
        Stream.of(Pair.with(Graph.Features.GraphFeatures.class, (Object)features.graph()), Pair.with(Graph.Features.VariableFeatures.class, (Object)features.graph().variables()), Pair.with(Graph.Features.VertexFeatures.class, (Object)features.vertex()), Pair.with(Graph.Features.VertexPropertyFeatures.class, (Object)features.vertex().properties()), Pair.with(Graph.Features.EdgeFeatures.class, (Object)features.edge()), Pair.with(Graph.Features.EdgePropertyFeatures.class, (Object)features.edge().properties())).forEach(p -> {
            StringFactory.printFeatureTitle((Class)p.getValue0(), sb);
            Stream.of(((Class)p.getValue0()).getMethods()).filter(supportMethods).map(StringFactory.createTransform((Graph.Features.FeatureSet)p.getValue1())).forEach(sb::append);
        });
        return sb.toString();
    }

    public static String traversalSideEffectsString(TraversalSideEffects traversalSideEffects) {
        return "sideEffects[size:" + traversalSideEffects.keys().size() + R_BRACKET;
    }

    public static String traversalStrategiesString(TraversalStrategies traversalStrategies) {
        return "strategies" + traversalStrategies.toList();
    }

    public static String traversalStrategyString(TraversalStrategy traversalStrategy) {
        return traversalStrategy.getClass().getSimpleName();
    }

    public static String traversalStrategyProxyString(TraversalStrategyProxy traversalStrategyProxy) {
        return traversalStrategyProxy.getStrategyClass().getSimpleName();
    }

    public static String translatorString(Translator translator) {
        return "translator[" + translator.getTraversalSource() + ":" + translator.getTargetLanguage() + R_BRACKET;
    }

    public static String vertexProgramString(VertexProgram vertexProgram, String internalString) {
        return vertexProgram.getClass().getSimpleName() + L_BRACKET + internalString + R_BRACKET;
    }

    public static String vertexProgramString(VertexProgram vertexProgram) {
        return vertexProgram.getClass().getSimpleName();
    }

    public static String mapReduceString(MapReduce mapReduce, String internalString) {
        return mapReduce.getClass().getSimpleName() + L_BRACKET + internalString + R_BRACKET;
    }

    public static String mapReduceString(MapReduce mapReduce) {
        return mapReduce.getClass().getSimpleName();
    }

    private static Function<Method, String> createTransform(Graph.Features.FeatureSet features) {
        return FunctionUtils.wrapFunction(m -> ">-- " + m.getName().substring(prefixLength) + ": " + m.invoke((Object)features, new Object[0]).toString() + LINE_SEPARATOR);
    }

    private static void printFeatureTitle(Class<? extends Graph.Features.FeatureSet> featureClass, StringBuilder sb) {
        sb.append("> ");
        sb.append(featureClass.getSimpleName());
        sb.append(LINE_SEPARATOR);
    }

    public static String stepString(Step<?, ?> step, Object ... arguments) {
        StringBuilder builder = new StringBuilder(step.getClass().getSimpleName());
        List strings = Stream.of(arguments).filter(o -> {
            if (o instanceof TraversalRing) {
                return !((TraversalRing)o).isEmpty();
            }
            if (o instanceof Collection) {
                return !((Collection)o).isEmpty();
            }
            if (o instanceof Map) {
                return !((Map)o).isEmpty();
            }
            return !Objects.toString(o).isEmpty();
        }).map(o -> {
            String string = Objects.toString(o);
            return StringFactory.hasLambda(string) ? "lambda" : string;
        }).collect(Collectors.toList());
        if (!strings.isEmpty()) {
            builder.append('(');
            builder.append(String.join((CharSequence)",", strings));
            builder.append(')');
        }
        if (!step.getLabels().isEmpty()) {
            builder.append('@').append(step.getLabels());
        }
        return builder.toString();
    }

    private static boolean hasLambda(String objectString) {
        return objectString.contains("$Lambda$") || objectString.contains("$_run_closure") || objectString.contains("<lambda>");
    }

    public static String traversalString(Traversal.Admin<?, ?> traversal) {
        return traversal.getSteps().stream().filter(s -> !(s instanceof ProfileStep) && !(s instanceof ProfileSideEffectStep)).collect(Collectors.toList()).toString();
    }

    public static String storageString(String internalString) {
        return "storage[" + internalString + R_BRACKET;
    }

    public static String removeEndBrackets(Collection collection) {
        String string = collection.toString();
        return string.substring(1, string.length() - 1);
    }

    public static String pathString(Path path) {
        return "path[" + String.join((CharSequence)COMMA_SPACE, IteratorUtils.map(path, Objects::toString)) + R_BRACKET;
    }
}

