/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.HyphenationTree;
import org.apache.fop.messaging.MessageHandler;

public class Hyphenator {
    static HashMap hyphenTrees = new HashMap();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$fop$layout$hyphenation$Hyphenator;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        block15: {
            block14: {
                block13: {
                    hTree = null;
                    ois = null;
                    is = null;
                    try {
                        try {
                            block16: {
                                block17: {
                                    is = Hyphenator.getResourceStream(key);
                                    if (is != null) break block16;
                                    if (key.length() != 5) break block17;
                                    is = Hyphenator.getResourceStream(key.substring(0, 2));
                                    if (is != null) {
                                        MessageHandler.errorln("Couldn't find hyphenation pattern  " + key + "\nusing general language pattern " + key.substring(0, 2) + " instead.");
                                        break block16;
                                    } else {
                                        if (Hyphenator.errorDump) {
                                            MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + key + ".hyp");
                                        }
                                        var4_4 = null;
                                        var6_6 = null;
                                        if (ois == null) return var4_4;
                                        break block13;
                                    }
                                }
                                if (Hyphenator.errorDump) {
                                    MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + key + ".hyp");
                                }
                                var4_5 = null;
                                break block14;
                            }
                            ois = new ObjectInputStream(is);
                            hTree = (HyphenationTree)ois.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block15;
                    }
                    catch (Throwable var5_11) {
                        var6_9 = null;
                        if (ois == null) throw var5_11;
                        try {
                            ois.close();
                            throw var5_11;
                        }
                        catch (IOException v0) {
                            MessageHandler.errorln("can't close hyphenation object stream");
                        }
                        throw var5_11;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 206->213)] { 
lbl46:
                // 1 sources

                ois.close();
                return var4_4;
lbl48:
                // 1 sources

                catch (IOException v1) {
                    MessageHandler.errorln("can't close hyphenation object stream");
                }
                return var4_4;
            }
            var6_7 = null;
            if (ois == null) return var4_5;
            ** try [egrp 2[TRYBLOCK] [2 : 206->213)] { 
lbl55:
            // 1 sources

            ois.close();
            return var4_5;
lbl57:
            // 1 sources

            catch (IOException v2) {
                MessageHandler.errorln("can't close hyphenation object stream");
            }
            return var4_5;
        }
        var6_8 = null;
        if (ois == null) return hTree;
        try {}
        catch (IOException v3) {
            MessageHandler.errorln("can't close hyphenation object stream");
            return hTree;
        }
        ois.close();
        return hTree;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        String hyphenDir;
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = String.valueOf(key) + "_" + country;
        }
        if (hyphenTrees.containsKey(key)) {
            return (HyphenationTree)hyphenTrees.get(key);
        }
        if (hyphenTrees.containsKey(lang)) {
            return (HyphenationTree)hyphenTrees.get(lang);
        }
        HyphenationTree hTree = Hyphenator.getFopHyphenationTree(key);
        if (hTree == null && (hyphenDir = Configuration.getStringValue("hyphenation-dir")) != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, hyphenDir);
        }
        if (hTree != null) {
            hyphenTrees.put(key, hTree);
        } else {
            MessageHandler.errorln("Couldn't find hyphenation pattern " + key);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread"))).getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception exception) {}
        if (is == null) {
            is = (class$org$apache$fop$layout$hyphenation$Hyphenator != null ? class$org$apache$fop$layout$hyphenation$Hyphenator : (class$org$apache$fop$layout$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.layout.hyphenation.Hyphenator"))).getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        HyphenationTree hTree = null;
        File hyphenFile = new File(hyphenDir, String.valueOf(key) + ".hyp");
        if (hyphenFile.exists()) {
            ObjectInputStream ois = null;
            try {
                try {
                    ois = new ObjectInputStream(new FileInputStream(hyphenFile));
                    hTree = (HyphenationTree)ois.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Object var6_6 = null;
                if (ois == null) return hTree;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ois == null) throw throwable;
                try {
                    ois.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ois.close();
                return hTree;
            }
            catch (IOException iOException) {}
            return hTree;
        }
        hyphenFile = new File(hyphenDir, String.valueOf(key) + ".xml");
        if (hyphenFile.exists()) {
            hTree = new HyphenationTree();
            if (errorDump) {
                MessageHandler.errorln("reading " + hyphenDir + key + ".xml");
            }
            try {
                hTree.loadPatterns(hyphenFile.getPath());
                if (!errorDump) return hTree;
                System.out.println("Stats: ");
                hTree.printStats();
                return hTree;
            }
            catch (HyphenationException hyphenationException) {
                if (!errorDump) return null;
                MessageHandler.errorln("Can't load user patterns from xml file " + hyphenDir + key + ".xml");
                return null;
            }
        }
        if (!errorDump) return null;
        MessageHandler.errorln("Tried to load " + hyphenFile.toString() + "\nCannot find compiled nor xml file for " + "hyphenation pattern" + key);
        return null;
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }
}

