﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/elastictranscoder/ElasticTranscoder_EXPORTS.h>
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <aws/elastictranscoder/ElasticTranscoderEndpointRules.h>


namespace Aws
{
namespace ElasticTranscoder
{
namespace Endpoint
{
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::EndpointProviderBase;
using Aws::Endpoint::DefaultEndpointProvider;

using ElasticTranscoderClientContextParameters = Aws::Endpoint::ClientContextParameters;

using ElasticTranscoderClientConfiguration = Aws::Client::GenericClientConfiguration;
using ElasticTranscoderBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the ElasticTranscoder Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using ElasticTranscoderEndpointProviderBase =
    EndpointProviderBase<ElasticTranscoderClientConfiguration, ElasticTranscoderBuiltInParameters, ElasticTranscoderClientContextParameters>;

using ElasticTranscoderDefaultEpProviderBase =
    DefaultEndpointProvider<ElasticTranscoderClientConfiguration, ElasticTranscoderBuiltInParameters, ElasticTranscoderClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_ELASTICTRANSCODER_API ElasticTranscoderEndpointProvider : public ElasticTranscoderDefaultEpProviderBase
{
public:
    using ElasticTranscoderResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

    ElasticTranscoderEndpointProvider()
      : ElasticTranscoderDefaultEpProviderBase(Aws::ElasticTranscoder::ElasticTranscoderEndpointRules::GetRulesBlob(), Aws::ElasticTranscoder::ElasticTranscoderEndpointRules::RulesBlobSize)
    {}

    ~ElasticTranscoderEndpointProvider()
    {
    }
};
} // namespace Endpoint
} // namespace ElasticTranscoder
} // namespace Aws
