/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import java.util.Vector;

class IdentityRepositoryWrapper
implements IdentityRepository {
    private IdentityRepository ir;
    private Vector<Identity> cache = new Vector();
    private boolean keep_in_cache = false;

    IdentityRepositoryWrapper(IdentityRepository ir) {
        this(ir, false);
    }

    IdentityRepositoryWrapper(IdentityRepository ir, boolean keep_in_cache) {
        this.ir = ir;
        this.keep_in_cache = keep_in_cache;
    }

    @Override
    public String getName() {
        return this.ir.getName();
    }

    @Override
    public int getStatus() {
        return this.ir.getStatus();
    }

    @Override
    public boolean add(byte[] identity) {
        return this.ir.add(identity);
    }

    @Override
    public boolean remove(byte[] blob) {
        return this.ir.remove(blob);
    }

    @Override
    public void removeAll() {
        this.cache.removeAllElements();
        this.ir.removeAll();
    }

    @Override
    public Vector<Identity> getIdentities() {
        Vector<Identity> result = new Vector<Identity>();
        for (int i = 0; i < this.cache.size(); ++i) {
            Identity identity = this.cache.elementAt(i);
            result.add(identity);
        }
        Vector<Identity> tmp = this.ir.getIdentities();
        for (int i = 0; i < tmp.size(); ++i) {
            result.add(tmp.elementAt(i));
        }
        return result;
    }

    void add(Identity identity) {
        if (!this.keep_in_cache && !identity.isEncrypted() && identity instanceof IdentityFile) {
            try {
                this.ir.add(((IdentityFile)identity).getKeyPair().forSSHAgent());
            }
            catch (JSchException jSchException) {}
        } else {
            this.cache.addElement(identity);
        }
    }

    void check() {
        if (this.cache.size() > 0) {
            Object[] identities = this.cache.toArray();
            for (int i = 0; i < identities.length; ++i) {
                Identity identity = (Identity)identities[i];
                this.cache.removeElement(identity);
                this.add(identity);
            }
        }
    }
}

