/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.ArrayChunk;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Numbers;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Repeat;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Range
extends ASeq
implements IChunkedSeq,
IReduce {
    private static final long serialVersionUID = -71973733672395145L;
    private static final int CHUNK_SIZE = 32;
    final Object end;
    final Object start;
    final Object step;
    final BoundsCheck boundsCheck;
    private volatile IChunk _chunk;
    private volatile ISeq _chunkNext;
    private volatile ISeq _next;

    private static BoundsCheck positiveStep(final Object end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(Object val2) {
                return Numbers.gte(val2, end);
            }
        };
    }

    private static BoundsCheck negativeStep(final Object end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(Object val2) {
                return Numbers.lte(val2, end);
            }
        };
    }

    private Range(Object start2, Object end, Object step, BoundsCheck boundsCheck) {
        this.end = end;
        this.start = start2;
        this.step = step;
        this.boundsCheck = boundsCheck;
    }

    private Range(Object start2, Object end, Object step, BoundsCheck boundsCheck, IChunk chunk2, ISeq chunkNext) {
        this.end = end;
        this.start = start2;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk2;
        this._chunkNext = chunkNext;
    }

    private Range(IPersistentMap meta, Object start2, Object end, Object step, BoundsCheck boundsCheck, IChunk chunk2, ISeq chunkNext) {
        super(meta);
        this.end = end;
        this.start = start2;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk2;
        this._chunkNext = chunkNext;
    }

    public static ISeq create(Object end) {
        if (Numbers.isPos(end)) {
            return new Range(0L, end, 1L, Range.positiveStep(end));
        }
        return PersistentList.EMPTY;
    }

    public static ISeq create(Object start2, Object end) {
        return Range.create(start2, end, 1L);
    }

    public static ISeq create(Object start2, Object end, Object step) {
        if (Numbers.isPos(step) && Numbers.gt(start2, end) || Numbers.isNeg(step) && Numbers.gt(end, start2) || Numbers.equiv(start2, end)) {
            return PersistentList.EMPTY;
        }
        if (Numbers.isZero(step)) {
            return Repeat.create(start2);
        }
        return new Range(start2, end, step, Numbers.isPos(step) ? Range.positiveStep(end) : Range.negativeStep(end));
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return new Range(meta, this.start, this.end, this.step, this.boundsCheck, this._chunk, this._chunkNext);
    }

    @Override
    public Object first() {
        return this.start;
    }

    public void forceChunk() {
        if (this._chunk != null) {
            return;
        }
        Object[] arr = new Object[32];
        int n = 0;
        Object val2 = this.start;
        while (n < 32) {
            arr[n++] = val2;
            if (!this.boundsCheck.exceededBounds(val2 = Numbers.addP(val2, this.step))) continue;
            this._chunk = new ArrayChunk(arr, 0, n);
            return;
        }
        if (this.boundsCheck.exceededBounds(val2)) {
            this._chunk = new ArrayChunk(arr, 0, 32);
            return;
        }
        this._chunk = new ArrayChunk(arr, 0, 32);
        this._chunkNext = new Range(val2, this.end, this.step, this.boundsCheck);
    }

    @Override
    public ISeq next() {
        if (this._next != null) {
            return this._next;
        }
        this.forceChunk();
        if (this._chunk.count() > 1) {
            IChunk smallerChunk = this._chunk.dropFirst();
            this._next = new Range(smallerChunk.nth(0), this.end, this.step, this.boundsCheck, smallerChunk, this._chunkNext);
            return this._next;
        }
        return this.chunkedNext();
    }

    @Override
    public IChunk chunkedFirst() {
        this.forceChunk();
        return this._chunk;
    }

    @Override
    public ISeq chunkedNext() {
        return this.chunkedMore().seq();
    }

    @Override
    public ISeq chunkedMore() {
        this.forceChunk();
        if (this._chunkNext == null) {
            return PersistentList.EMPTY;
        }
        return this._chunkNext;
    }

    @Override
    public Object reduce(IFn f) {
        Object acc = this.start;
        Number i = Numbers.addP(this.start, this.step);
        while (!this.boundsCheck.exceededBounds(i)) {
            if (RT.isReduced(acc = f.invoke(acc, i))) {
                return ((Reduced)acc).deref();
            }
            i = Numbers.addP((Object)i, this.step);
        }
        return acc;
    }

    @Override
    public Object reduce(IFn f, Object val2) {
        Object acc = val2;
        Object i = this.start;
        while (!this.boundsCheck.exceededBounds(i)) {
            if (RT.isReduced(acc = f.invoke(acc, i))) {
                return ((Reduced)acc).deref();
            }
            i = Numbers.addP(i, this.step);
        }
        return acc;
    }

    @Override
    public Iterator iterator() {
        return new RangeIterator();
    }

    private class RangeIterator
    implements Iterator {
        private Object next;

        public RangeIterator() {
            this.next = Range.this.start;
        }

        @Override
        public boolean hasNext() {
            return !Range.this.boundsCheck.exceededBounds(this.next);
        }

        public Object next() {
            if (this.hasNext()) {
                Object ret = this.next;
                this.next = Numbers.addP(this.next, Range.this.step);
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface BoundsCheck
    extends Serializable {
        public boolean exceededBounds(Object var1);
    }
}

