# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class AddPartitionIdToVulnerabilities < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!

  milestone '18.6'

  def up
    with_lock_retries do
      add_column :vulnerabilities, :partition_id, :bigint, default: 1, if_not_exists: true
    end
  end

  def down
    with_lock_retries do
      remove_column :vulnerabilities, :partition_id, :bigint, if_exists: true
    end
  end
end
