---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: システムノートは、マージリクエストやイシューなど、オブジェクトに加えられた変更の履歴を追跡します。
title: システムノート
description: イベント履歴、アクティビティーログ、コメント履歴。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

システムノートは、次のようなGitLabオブジェクトのライフサイクル中に発生するイベントの履歴を理解するのに役立つ短い説明です:

- [アラート](../../operations/incident_management/alerts.md)。
- [デザイン](issues/design_management.md)。
- [イシュー](issues/_index.md)。
- [マージリクエスト](merge_requests/_index.md)。
- [目標と主な成果](../okrs.md)（OKRs）。
- [タスク](../tasks.md)。

GitLabは、GitまたはGitLabアプリケーションによってトリガーされたイベントに関する情報をシステムノートに記録します。システムノートでは、`<Author> <action> <time ago>`という形式を使用します。

## システムノートの表示またはフィルタリング {#show-or-filter-system-notes}

デフォルトでは、システムノートは表示されません。表示される場合、最も古いものが最初に表示されます。フィルターまたは並べ替えオプションを変更すると、その選択はセクション間で記憶されます。マージリクエストを除くすべてのアイテムタイプでは、フィルタリングオプションは次のとおりです:

- **すべてのアクティビティーを表示**は、コメントと履歴の両方を表示します。
- **コメントのみ表示**すると、システムノートは非表示になります。
- **履歴のみ表示**すると、ユーザーコメントは非表示になります。

マージリクエストでは、より詳細なフィルタリングオプションが使用できます。

### エピックで {#on-an-epic}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **Plan** > **エピック**を選択します。
1. 目的のエピックを特定し、そのタイトルを選択します。
1. **アクティビティー**セクションに移動します。
1. **並べ替えとフィルタリング**で、**すべてのアクティビティーを表示**を選択します。

### イシューで {#on-an-issue}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **Plan** > **イシュー**を選択して、イシューを見つけます。
1. **アクティビティー**に移動します。
1. **並べ替えとフィルタリング**で、**すべてのアクティビティーを表示**を選択します。

### マージリクエストで {#on-a-merge-request}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. **アクティビティー**に移動します。
1. **並べ替えとフィルタリング**で、**すべてのアクティビティーを表示**を選択して、すべてのシステムノートを表示します。返されるシステムノートの種類を絞り込むには、次のいずれかを選択します:

   - **承認**
   - **Assignees & Reviewers**（担当者とレビュアー）
   - **コメント**
   - **コミットとブランチ**
   - **編集**
   - **ラベル**
   - **ロック状態**
   - **メンション**
   - **マージリクエストのステータス**
   - **トラッキング**

## プライバシーに関する考慮事項 {#privacy-considerations}

アクセスできるオブジェクトにリンクされているシステムノートのみを表示できます。

たとえば、誰かがあなたのイシュー111をプライベートGitLabプロジェクトのイシューでメンションした場合:

- プロジェクトメンバーには、イシュー111に次のノートが表示されます: `Alex Garcia mentioned in agarcia/private-project#222`。
- プロジェクトのメンバーでない場合、ノートは一切表示されません。

## 関連トピック {#related-topics}

- [ノートAPI](../../api/notes.md)
