/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlKind;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableRareTopPushdownRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;
import org.opensearch.sql.opensearch.storage.scan.context.RareTopDigest;

@Value.Enclosing
public class RareTopPushdownRule
extends InterruptibleRelRule<Config>
implements SubstitutionRule {
    protected RareTopPushdownRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        RareTopDigest digest;
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(2);
        try {
            RexLiteral numberLiteral = (RexLiteral)((RexCall)filter.getCondition()).getOperands().get(1);
            Integer number = (Integer)numberLiteral.getValueAs(Integer.class);
            List windows = PlanUtils.getRexWindowFromProject((LogicalProject)project);
            if (windows.size() != 1) {
                return;
            }
            List fieldNameList = project.getInput().getRowType().getFieldNames();
            List groupIndices = PlanUtils.getSelectColumns((List)((RexWindow)windows.getFirst()).partitionKeys);
            List<String> byList = groupIndices.stream().map(fieldNameList::get).toList();
            if (((RexWindow)windows.getFirst()).orderKeys.size() != 1) {
                return;
            }
            RexFieldCollation orderKey = (RexFieldCollation)((RexWindow)windows.getFirst()).orderKeys.getFirst();
            List orderIndices = PlanUtils.getSelectColumns(List.of((RexNode)orderKey.getKey()));
            List<String> orderList = orderIndices.stream().map(fieldNameList::get).toList();
            List<String> targetList = fieldNameList.stream().filter(Predicate.not(byList::contains)).filter(Predicate.not(orderList::contains)).toList();
            if (targetList.size() != 1) {
                return;
            }
            String targetName = targetList.getFirst();
            digest = new RareTopDigest(targetName, byList, number, orderKey.getDirection());
        }
        catch (Exception e) {
            return;
        }
        CalciteLogicalIndexScan newScan = scan.pushDownRareTop((Project)project, digest);
        if (newScan != null) {
            call.transformTo((RelNode)newScan);
            PlanUtils.tryPruneRelNodes((RelOptRuleCall)call);
        }
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableRareTopPushdownRule.Config.builder().build().withDescription("Filter-Project(window)-TableScan(agg-pushed)").withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).predicate(filter -> filter.getCondition().getKind() == SqlKind.LESS_THAN_OR_EQUAL).oneInput(b1 -> b1.operand(LogicalProject.class).predicate(PlanUtils::containsRowNumberRareTop).oneInput(b2 -> b2.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(AbstractCalciteIndexScan::noAggregatePushed)).noInputs())));

        default public RareTopPushdownRule toRule() {
            return new RareTopPushdownRule(this);
        }
    }
}

