/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectPermission;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class RMUtils {
    public static final String USER_PROJECTS_FOLDER = "user-projects";
    public static final String SHARED_PROJECTS_FOLDER = "shared-projects";

    @NotNull
    public static Path getRootPath() {
        return DBWorkbench.getPlatform().getWorkspace().getAbsolutePath();
    }

    @NotNull
    public static Path getUserProjectsPath() {
        return RMUtils.getRootPath().resolve(USER_PROJECTS_FOLDER);
    }

    @NotNull
    public static Path getSharedProjectsPath() {
        return RMUtils.getRootPath().resolve(SHARED_PROJECTS_FOLDER);
    }

    @NotNull
    public static Path getProjectPath(@NotNull RMProject project) {
        Path folder = switch (project.getType()) {
            case RMProjectType.GLOBAL -> RMUtils.getRootPath();
            case RMProjectType.SHARED -> RMUtils.getSharedProjectsPath();
            default -> RMUtils.getUserProjectsPath();
        };
        return folder.resolve(project.getName());
    }

    @NotNull
    public static String getProjectName(@NotNull String projectId) throws DBException {
        int divPos = projectId.indexOf("_");
        if (divPos <= 0) {
            throw new DBException("Bad project ID");
        }
        return projectId.substring(divPos + 1);
    }

    @NotNull
    public static Path getProjectPathById(@NotNull String projectId) throws DBException {
        int divPos = projectId.indexOf("_");
        if (divPos <= 0) {
            throw new DBException("Bad project ID");
        }
        String prefix = projectId.substring(0, divPos);
        String projectName = projectId.substring(divPos + 1);
        switch (RMProjectType.getByPrefix(prefix)) {
            case GLOBAL: {
                String defaultProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
                if (CommonUtils.isEmpty((String)defaultProjectName)) {
                    throw new DBException("Global projects are not supported");
                }
                return RMUtils.getRootPath().resolve(defaultProjectName);
            }
            case SHARED: {
                return RMUtils.getSharedProjectsPath().resolve(projectName);
            }
        }
        return RMUtils.getUserProjectsPath().resolve(projectName);
    }

    @NotNull
    public static RMProject createAnonymousProject() {
        RMProject project = new RMProject("anonymous");
        project.setId("anonymous");
        project.setType(RMProjectType.USER);
        project.setProjectPermissions(RMProjectPermission.DATA_SOURCES_EDIT.getAllPermissions().toArray(new String[0]));
        return project;
    }

    @NotNull
    public static String makeProjectIdFromPath(@NotNull Path path, @NotNull RMProjectType type) {
        String projectName = path.getFileName().toString();
        return type.getPrefix() + "_" + projectName;
    }
}

