/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.MultiSwitchLayoutManager;

public class WhitespaceManagementPenalty
extends KnuthPenalty {
    private final MultiSwitchLayoutManager.WhitespaceManagementPosition whitespaceManagementPosition;
    private final List<Variant> variantList;

    public WhitespaceManagementPenalty(MultiSwitchLayoutManager.WhitespaceManagementPosition pos) {
        super(0, 0, false, pos, false);
        this.whitespaceManagementPosition = pos;
        this.variantList = new ArrayList<Variant>();
    }

    public void addVariant(Variant variant) {
        this.variantList.add(variant);
    }

    public void setActiveVariant(Variant bestVariant) {
        this.whitespaceManagementPosition.setKnuthList(bestVariant.knuthList);
    }

    public boolean hasActiveVariant() {
        return this.whitespaceManagementPosition.getKnuthList() != null;
    }

    public List<Variant> getVariants() {
        return this.variantList;
    }

    @Override
    public String toString() {
        String str = super.toString();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(" number of variants = " + this.variantList.size());
        return str + buffer;
    }

    public class Variant {
        public final List<ListElement> knuthList;
        public final int width;
        private final KnuthPenalty penalty;

        public Variant(List<ListElement> knuthList, int width) {
            this.knuthList = knuthList;
            this.width = width;
            this.penalty = new KnuthPenalty(width, 0, false, null, false);
        }

        public KnuthElement getPenalty() {
            return this.penalty;
        }

        public WhitespaceManagementPenalty getWhitespaceManagementPenalty() {
            return WhitespaceManagementPenalty.this;
        }
    }
}

