/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserAction;
import com.dickimawbooks.texparserlib.TeXPath;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class TeXParserActionObject
extends AbstractTeXObject {
    private TeXObjectList pending = null;
    private TeXParserAction action;
    private Object data;

    protected TeXParserActionObject(TeXParserAction teXParserAction, TeXObjectList teXObjectList, Object object) {
        this.action = teXParserAction;
        this.data = object;
        this.pending = teXObjectList;
    }

    public static TeXParserActionObject createInputAction(TeXParser teXParser, String string) throws IOException {
        return TeXParserActionObject.createInputAction(new TeXPath(teXParser, string));
    }

    public static TeXParserActionObject createInputAction(TeXParser teXParser, String string, Charset charset) throws IOException {
        return TeXParserActionObject.createInputAction(new TeXPath(teXParser, string, charset));
    }

    public static TeXParserActionObject createInputAction(TeXParser teXParser, String string, TeXObjectList teXObjectList) throws IOException {
        return TeXParserActionObject.createInputAction(new TeXPath(teXParser, string), teXObjectList);
    }

    public static TeXParserActionObject createInputAction(TeXParser teXParser, String string, Charset charset, TeXObjectList teXObjectList) throws IOException {
        return TeXParserActionObject.createInputAction(new TeXPath(teXParser, string, charset), teXObjectList);
    }

    public static TeXParserActionObject createInputAction(TeXPath teXPath) {
        return TeXParserActionObject.createInputAction(teXPath, null);
    }

    public static TeXParserActionObject createInputAction(TeXPath teXPath, TeXObjectList teXObjectList) {
        if (teXObjectList != null && !(teXObjectList instanceof TeXParser)) {
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.add(teXObjectList, true);
            teXObjectList.clear();
            teXObjectList = teXObjectList2;
        }
        return new TeXParserActionObject(TeXParserAction.INPUT_FILE, teXObjectList, teXPath);
    }

    public static TeXParserActionObject createInputAction(File file) {
        return TeXParserActionObject.createInputAction(file, null);
    }

    public static TeXParserActionObject createInputAction(File file, TeXObjectList teXObjectList) {
        if (teXObjectList != null && !(teXObjectList instanceof TeXParser)) {
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.add(teXObjectList, true);
            teXObjectList.clear();
            teXObjectList = teXObjectList2;
        }
        return new TeXParserActionObject(TeXParserAction.INPUT_FILE, teXObjectList, file);
    }

    public static TeXParserActionObject createModeChangeAction(TeXMode teXMode) {
        return new TeXParserActionObject(TeXParserAction.MODE_CHANGE, null, (Object)teXMode);
    }

    @Override
    public Object clone() {
        return new TeXParserActionObject(this.action, this.pending, this.data);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.pending == null) {
            this.pending = teXObjectList;
        } else {
            this.pending.add(teXObjectList, true);
            teXObjectList.clear();
        }
        teXParser.processAction(this);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.processAction(this);
    }

    public TeXObjectList getPending() {
        return this.pending;
    }

    public TeXParserAction getAction() {
        return this.action;
    }

    public Object getData() {
        return this.data;
    }

    public File getFile() {
        if (this.data instanceof File) {
            return (File)this.data;
        }
        if (this.data instanceof TeXPath) {
            return ((TeXPath)this.data).getFile();
        }
        return null;
    }

    public String toString() {
        return String.format("%s[action=%s,data=%s]", new Object[]{this.getClass().getSimpleName(), this.action, this.data});
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public String format() {
        return "";
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return new TeXObjectList();
    }

    @Override
    public String toString(TeXParser teXParser) {
        return "";
    }
}

