/*
 * Decompiled with CFR 0.152.
 */
package nts.hyph;

import nts.node.Hyphens;

public class ArrayHyphens
implements Hyphens {
    public static final ArrayHyphens EMPTY = new ArrayHyphens(new boolean[0]);
    private final boolean[] array;

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public boolean hyphenAt(int pos) {
        return pos < this.array.length && this.array[pos];
    }

    public String toString(String word) {
        StringBuffer buf = new StringBuffer(2 * word.length() + 1);
        int i = 0;
        while (i < word.length()) {
            if (this.hyphenAt(i)) {
                buf.append('-');
            }
            buf.append(word.charAt(i));
            ++i;
        }
        if (this.hyphenAt(word.length())) {
            buf.append('-');
        }
        return buf.toString();
    }

    public static ArrayHyphens forPositions(int[] positions, int start, int end) {
        if (start <= end) {
            int i = 0;
            while (i < positions.length && positions[i] < start) {
                ++i;
            }
            int l = positions.length;
            while (--l > 0 && positions[l] > end) {
            }
            if (i <= l) {
                boolean[] array = new boolean[positions[l] + 1];
                while (i <= l) {
                    array[positions[i++]] = true;
                }
                return new ArrayHyphens(array);
            }
        }
        return EMPTY;
    }

    public ArrayHyphens(boolean[] array) {
        this.array = array;
    }
}

