/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import nts.io.CharCode;
import nts.io.Log;
import nts.io.Loggable;

public class InputLine
implements Loggable {
    public static final InputLine NULL;
    public static final CharCode EOL;
    private CharCode[] codes;
    private Mapper mapper;
    private int pos;

    public InputLine addEndOfLineChar() {
        CharCode elc = this.mapper.endLine();
        if (elc != null) {
            CharCode[] newCodes = new CharCode[this.codes.length + 1];
            System.arraycopy(this.codes, 0, newCodes, 0, this.codes.length);
            newCodes[this.codes.length] = elc;
            return new InputLine(newCodes, this.mapper, this.pos);
        }
        return this;
    }

    public InputLine pureRest() {
        CharCode[] newCodes = new CharCode[this.codes.length - this.pos];
        System.arraycopy(this.codes, this.pos, newCodes, 0, this.codes.length - this.pos);
        return new InputLine(newCodes, this.mapper, 0);
    }

    public boolean wasEmpty(boolean addEolc) {
        CharCode elc;
        if (addEolc && (elc = this.mapper.endLine()) != null) {
            return this.codes.length == 1 && this.codes[0].match(elc);
        }
        return this.codes.length == 0;
    }

    public boolean empty() {
        return this.pos >= this.codes.length;
    }

    public synchronized void skipSpaces() {
        while (this.pos < this.codes.length && this.codes[this.pos].match(' ')) {
            ++this.pos;
        }
    }

    public synchronized CharCode getNextRawCode() {
        return this.pos < this.codes.length ? this.codes[this.pos++] : null;
    }

    public synchronized CharCode peekNextRawCode() {
        return this.pos < this.codes.length ? this.codes[this.pos] : null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized CharCode getNext() {
        if (this.pos < this.codes.length) {
            char c1;
            CharCode code = this.codes[this.pos++];
            while (this.pos + 1 < this.codes.length && code.startsExpand() && code.match(this.codes[this.pos]) && (c1 = this.codes[this.pos + 1].toChar()) != '\uffff' && c1 < '\u0080') {
                void numCode;
                char c2;
                void var2_2;
                this.pos += 2;
                if (this.pos < this.codes.length && InputLine.isHexDigit((char)var2_2) && (c2 = this.codes[this.pos].toChar()) != '\uffff' && InputLine.isHexDigit(c2)) {
                    ++this.pos;
                    int n = (InputLine.digitForHex((char)var2_2) << 4) + InputLine.digitForHex(c2);
                } else {
                    numCode = var2_2 < 64 ? var2_2 + 64 : var2_2 - 64;
                }
                code = this.mapper.map((int)numCode);
            }
            return code;
        }
        return null;
    }

    private static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f';
    }

    private static int digitForHex(char c) {
        return c <= '9' ? c - 48 : c - 97 + 10;
    }

    public synchronized CharCode peekNext() {
        int oldPos = this.pos;
        CharCode code = this.getNext();
        if (this.pos > oldPos + 1) {
            CharCode[] newCodes = new CharCode[oldPos + 1 + this.codes.length - this.pos];
            System.arraycopy(this.codes, 0, newCodes, 0, oldPos);
            newCodes[oldPos] = code;
            System.arraycopy(this.codes, this.pos, newCodes, oldPos + 1, this.codes.length - this.pos);
            this.codes = newCodes;
        }
        this.pos = oldPos;
        return code;
    }

    public synchronized void skipAll() {
        this.pos = this.codes.length;
    }

    public void addOn(Log log) {
        log.add(this.codes, this.pos, this.codes.length - this.pos);
    }

    public int addContext(Log left, Log right, boolean addEolc) {
        int end = this.codes.length;
        if (addEolc && end > 0 && this.codes[end - 1].isEndLine()) {
            --end;
        }
        Log log = left;
        int i = 0;
        while (i < end) {
            if (i == this.pos) {
                log = right;
            }
            log.add(this.codes[i]);
            ++i;
        }
        return 1;
    }

    private InputLine(CharCode[] codes, Mapper mapper, int pos) {
        this.codes = codes;
        this.mapper = mapper;
        this.pos = pos;
    }

    public InputLine(CharCode[] codes, Mapper mapper) {
        this(codes, mapper, 0);
    }

    public InputLine(Mapper mapper) {
        this(new CharCode[0], mapper);
    }

    public InputLine(String str, Mapper mapper) {
        int end = str.length();
        while (end > 0 && mapper.ignoreTrailing(str.charAt(end - 1))) {
            --end;
        }
        this.codes = new CharCode[end];
        this.mapper = mapper;
        this.pos = 0;
        int i = 0;
        while (i < end) {
            this.codes[i] = mapper.map(str.charAt(i));
            ++i;
        }
    }

    public InputLine(InputLine line) {
        this(line.codes, line.mapper, line.pos);
    }

    public static interface Mapper {
        public CharCode map(char var1);

        public CharCode map(int var1);

        public CharCode endLine();

        public boolean ignoreTrailing(char var1);
    }
}

