/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.NoadList;
import nts.noad.PureNoad;
import nts.noad.VoidEgg;

public class ChoiceNoad
extends PureNoad {
    private static final char[] stylePrefixes = new char[4];
    private final NoadList[] choices;

    public final boolean influencesBin() {
        return false;
    }

    public Egg convert(Converter conv) {
        conv.push(this.choices[conv.getStyle()].noads());
        return VoidEgg.EGG;
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc());
        byte i = 0;
        while (i < 4) {
            cntx.addOn(log, this.choices[i].noads(), ChoiceNoad.getStylePrefix(i));
            i = (byte)(i + 1);
        }
    }

    protected String getDesc() {
        return "mathchoice";
    }

    public static char getStylePrefix(byte style) {
        return stylePrefixes[style];
    }

    public ChoiceNoad(NoadList[] choices) {
        this.choices = choices;
        if (choices.length != 4) {
            throw new RuntimeException("Bad size of math choices");
        }
    }

    static {
        ChoiceNoad.stylePrefixes[0] = 68;
        ChoiceNoad.stylePrefixes[1] = 84;
        ChoiceNoad.stylePrefixes[2] = 83;
        ChoiceNoad.stylePrefixes[3] = 115;
    }
}

