/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.util.HashMap;
import java.util.Iterator;
import nts.command.TokenList;
import nts.io.Log;
import nts.io.Loggable;
import nts.tex.TeXError;

public class TeXErrorPool {
    private HashMap pool;
    private String errMessageHelp;
    private String defaultHelp;
    private String helpAfterHelp;
    private String helpAfterDel;

    public TeXError get(String ident) {
        Object err = this.pool.get(ident);
        if (err != null) {
            return (TeXError)err;
        }
        throw new RuntimeException("TeX error `" + ident + "' not available in TeXErrorPool");
    }

    private void put(String ident, TeXError err) {
        if (this.pool.containsKey(ident)) {
            throw new RuntimeException("Redefinition of TeX error `" + ident + "' in TeXErrorPool");
        }
        this.pool.put(ident, err);
    }

    public Iterator idents() {
        return this.pool.keySet().iterator();
    }

    public TeXError get(TokenList text, TokenList help) {
        TeXErrorPool teXErrorPool = this;
        if (teXErrorPool == null) {
            throw null;
        }
        return new TeXError(teXErrorPool, text, help){
            private final /* synthetic */ TeXErrorPool this$0;
            private final /* synthetic */ TokenList val$text;
            private final /* synthetic */ TokenList val$help;

            public void addText(Log log, Loggable[] params) {
                log.add(this.val$text);
            }

            public void addHelp(Log log, Loggable[] params) {
                if (!this.val$help.isEmpty()) {
                    log.add(this.val$help);
                } else {
                    TeXErrorPool.access$1(this.this$0, log, TeXErrorPool.access$0(this.this$0), params);
                    log.endLine();
                }
            }

            public void addDesc(Log log, Loggable[] params) {
                if (!this.val$help.isEmpty()) {
                    log.endLine().add(this.val$help);
                } else {
                    TeXErrorPool.access$1(this.this$0, log.startLine(), TeXErrorPool.access$0(this.this$0), params);
                    TeXErrorPool.access$2(this.this$0, "(That was another \\errmessage.)");
                }
            }
            {
                this.val$text = val$text;
                this.val$help = val$help;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXErrorPool teXErrorPool) {
            }
        };
    }

    private void defineError(String ident, String text, String help) {
        TeXErrorPool teXErrorPool = this;
        if (teXErrorPool == null) {
            throw null;
        }
        this.put(ident, new TeXError(teXErrorPool, text, help){
            private final /* synthetic */ TeXErrorPool this$0;
            private final /* synthetic */ String val$text;
            private final /* synthetic */ String val$help;

            public void addText(Log log, Loggable[] params) {
                if (this.val$text != null) {
                    TeXErrorPool.access$1(this.this$0, log, this.val$text, params);
                }
            }

            public void addHelp(Log log, Loggable[] params) {
                if (this.val$help != null) {
                    TeXErrorPool.access$1(this.this$0, log, this.val$help, params);
                } else {
                    TeXErrorPool.access$1(this.this$0, log, TeXErrorPool.access$3(this.this$0), null);
                }
                log.endLine();
            }

            public void addDesc(Log log, Loggable[] params) {
                if (this.val$help != null) {
                    TeXErrorPool.access$1(this.this$0, log.startLine(), this.val$help, params);
                }
            }
            {
                this.val$text = val$text;
                this.val$help = val$help;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXErrorPool teXErrorPool) {
            }
        });
    }

    private void defineFatalError(String ident, String desc) {
        TeXErrorPool teXErrorPool = this;
        if (teXErrorPool == null) {
            throw null;
        }
        this.put(ident, new TeXError(teXErrorPool, desc){
            private final /* synthetic */ TeXErrorPool this$0;
            private final /* synthetic */ String val$desc;

            public void addText(Log log, Loggable[] params) {
                log.add("Emergency stop");
            }

            public void addHelp(Log log, Loggable[] params) {
                TeXErrorPool.access$1(this.this$0, log, TeXErrorPool.access$3(this.this$0), null);
                log.endLine();
            }

            public void addDesc(Log log, Loggable[] params) {
                log.startLine().add(this.val$desc);
            }
            {
                this.val$desc = val$desc;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TeXErrorPool teXErrorPool) {
            }
        });
    }

    public void addHelpAfterHelp(Log log) {
        this.print(log, this.helpAfterHelp, null);
        log.endLine();
    }

    public void addHelpAfterDel(Log log) {
        this.print(log, this.helpAfterDel, null);
        log.endLine();
    }

    private void print(Log log, String str, Loggable[] params) {
        int i = 0;
        while (i < str.length()) {
            char ch;
            if ((ch = str.charAt(i++)) == '\n') {
                log.endLine();
                continue;
            }
            if (ch != '%') {
                log.add(ch);
                continue;
            }
            if (str.charAt(i) == '%') {
                log.add(str.charAt(i++));
                continue;
            }
            int j = i;
            while (j < str.length() && Character.isDigit(str.charAt(j))) {
                ++j;
            }
            if (j <= i) continue;
            int n = Integer.parseInt(str.substring(i, j));
            if (params == null || n <= 0 || n > params.length) {
                throw new RuntimeException("Error parameter %" + n + " not specified (for:\n" + str + ")");
            }
            log.add(params[n - 1]);
            i = j;
        }
    }

    private void defineInSkipped(String ident, String what) {
        this.defineError(ident, "Incomplete %1; all text was ignored after line %2", what + " text.\n" + "This kind of error happens when you say `\\if...' and forget\n" + "the matching `\\fi'. I've inserted a `\\fi'; this might work.");
    }

    private void defineRunaway(String ident, String w1, String w2) {
        this.defineError(ident, w1 + " while scanning " + w2 + " of %1", "I suspect you have forgotten a `}', causing me\nto read past where you wanted me to stop.\nI'll try to recover; but if the error is serious,\nyou'd better type `E' or `X' now and fix your file.");
    }

    private void defineBadTFM(String ident, String what) {
        this.defineError(ident, "Font %1 not loadable: " + what, "I wasn't able to read the size data for this font,\nso I will ignore the font specification.\n[Wizards can fix TFM files using TFtoPL/PLtoTF.]\nYou might try inserting a different font spec;\ne.g., type `I\\font<same font id>=<substitute font name>'.");
    }

    private void defineCantDeleteLastItem(String ident, String what) {
        this.defineError(ident, "You can't use `%1' in %2", "Sorry...I usually can't take things from the current page.\n" + what + ".");
    }

    private void defineAllignError(String ident, String what) {
        this.defineError(ident, "Missing " + what + " inserted", "I've put in what seems to be necessary to fix\nthe current column of the current alignment.\nTry to go on, since this might almost work.");
    }

    private void defineCodeOut(String ident, String what) {
        this.defineError(ident, "Invalid code (%1), should be " + what + "%2", "I'm going to use 0 instead of that illegal code value.");
    }

    public static void main(String[] args) {
        TeXErrorPool pl = new TeXErrorPool();
        Iterator id = pl.idents();
        while (id.hasNext()) {
            System.out.println(id.next());
        }
    }

    static /* synthetic */ String access$0(TeXErrorPool teXErrorPool) {
        return teXErrorPool.errMessageHelp;
    }

    static /* synthetic */ void access$1(TeXErrorPool teXErrorPool, Log log, String string, Loggable[] loggableArray) {
        teXErrorPool.print(log, string, loggableArray);
    }

    static /* synthetic */ void access$2(TeXErrorPool teXErrorPool, String string) {
        teXErrorPool.errMessageHelp = string;
    }

    static /* synthetic */ String access$3(TeXErrorPool teXErrorPool) {
        return teXErrorPool.defaultHelp;
    }

    private final void block$() {
        this.pool = new HashMap(199);
        this.errMessageHelp = "This error message was generated by an \\errmessage\ncommand, so I can't give any explicit help.\nPretend that you're Hercule Poirot: Examine all clues,\nand deduce the truth by order and method.";
        this.defaultHelp = "Sorry, I don't know how to help in this situation.\nMaybe you should try asking a human?";
        this.helpAfterHelp = "Sorry, I already gave what help I could...\nMaybe you should try asking a human?\nAn error might have occurred before I noticed any problems.\n``If all else fails, read the instructions.''";
        this.helpAfterDel = "I have just deleted some text, as you asked.\nYou can now delete more, or insert, or whatever.";
        this.defineError("Void", null, null);
        this.defineError("Confusion", "This can't happen (%1)", "I'm broken. Please show this to someone who can fix can fix");
        this.defineError("NextConfusion", "I can't go on meeting you like this", "One of your faux pas seems to have wounded me deeply...\nin fact, I'm barely conscious. Please fix it and try again.");
        this.defineError("Interrupt", "Interruption", "You rang?\nTry to insert some instructions for me (e.g.,`I\\showlists'),\nunless you just want to quit by typing `X'.");
        this.defineError("IncompatMag", "Incompatible magnification (%1);\n the previous value will be retained (%2)", "I can handle only one magnification ratio per job. So I've\nreverted to the magnification you used earlier on this run.");
        this.defineError("IllegalMag", "Illegal magnification has been changed to 1000 (%1)", "The magnification ratio must be between 1 and 32768.");
        this.defineInSkipped("OuterInSkipped", "A forbidden control sequence occurred in skipped");
        this.defineInSkipped("EOFinSkipped", "The file ended while I was skipping conditional");
        this.defineRunaway("OuterInDef", "Forbidden control sequence found", "definition");
        this.defineRunaway("EOFinDef", "File ended", "definition");
        this.defineRunaway("OuterInMatch", "Forbidden control sequence found", "use");
        this.defineRunaway("EOFinMatch", "File ended", "use");
        this.defineRunaway("OuterInPreamble", "Forbidden control sequence found", "preamble");
        this.defineRunaway("EOFinPreamble", "File ended", "preamble");
        this.defineRunaway("OuterInToks", "Forbidden control sequence found", "text");
        this.defineRunaway("EOFinToks", "File ended", "text");
        this.defineError("InvalidChar", "Text line contains an invalid character", "A funny symbol that I can't read has just been input.\nContinue, and I'll forget that it ever happened.");
        this.defineError("UndefinedToken", "Undefined control sequence", "The control sequence at the end of the top line\nof your error message was never \\def'ed. If you have\nmisspelled it (e.g., `\\hobx'), type `I' and the correct\nspelling (e.g., `I\\hbox'). Otherwise just continue,\nand I'll forget about whatever was undefined.");
        this.defineError("MissingEndcsname", "Missing %1 inserted", "The control sequence marked <to be read again> should\nnot appear between \\csname and \\endcsname.");
        this.defineError("ExtraRightBrace", "Argument of %1 has an extra }", "I've run across a `}' that doesn't seem to match anything.\nFor example, `\\def\\a#1{...}' and `\\a}' would produce\nthis error. If you simply proceed now, the `\\par' that\nI've just inserted will cause me to report a runaway\nargument that might be the root of the problem. But if\nyour `}' was spurious, just type `2' and it will go away.");
        this.defineError("RunawayArg", "Paragraph ended before %1 was complete", "I suspect you've forgotten a `}', causing me to apply this\ncontrol sequence to too much text. How can we recover?\nMy plan is to forget the whole thing and hope for the best.");
        this.defineError("UseDoesntMatch", "Use of %1 doesn't match its definition", "If you say, e.g., `\\def\\a1{...}', then you must always\nput `1' after `\\a', since control sequence names are\nmade up of letters only. The macro here has not been\nfollowed by the required stuff, so I'm ignoring it.");
        this.defineError("MissingLeftBrace", "Missing { inserted", "A left brace was mandatory here, so I've put one in.\nYou might want to delete and/or insert some corrections\nso that I will find a matching right brace soon.\n(If you're confused by all this, try typing `I}' now.)");
        this.defineError("MixedGlueUnits", "Incompatible glue units", "I'm going to assume that 1mu=1pt when they're mixed.");
        this.defineError("MissingNumber", "Missing number, treated as zero", "A number should have been here; I inserted `0'.\n(If you can't figure out why I needed to see a number,\nlook up `weird error' in the index to The TeXbook.)");
        this.defineError("ImproperSForPD", "Improper %1", "You can refer to \\spacefactor only in horizontal mode;\nyou can refer to \\prevdepth only in vertical mode; and\nneither of these is meaningful inside \\write. So\nI'm forgetting what you said and using zero instead.");
        this.defineError("CantAfterThe", "You can't use `%1' after %2", "I'm forgetting what you said and using zero instead.");
        this.defineError("BadRegister", "Bad register code (%1)", "A register number must be between %2 and %3.\nI changed this one to zero.");
        this.defineError("BadCharCode", "Bad character code (%1)", "A character number must be between %2 and %3.\nI changed this one to zero.");
        this.defineError("BadFileNum", "Bad number (%1)", "Since I expected to read a number between %2 and %3,\nI changed this one to zero.");
        this.defineError("BadMathCharCode", "Bad mathchar (%1)", "A mathchar number must be between %2 and %3.\nI changed this one to zero.");
        this.defineError("BadDelimiterCode", "Bad delimiter code (%1)", "A numeric delimiter code must be between %2 and 2^{27}-1.\nI changed this one to zero.");
        this.defineError("NonNumericToken", "Improper alphabetic constant", "A one-character control sequence belongs after a ` mark.\nSo I'm essentially inserting \\0 here.");
        this.defineError("NumberTooBig", "Number too big", "I can only go up to 2147483647='17777777777=\"7FFFFFFF,\nso I'm using that number instead of yours.");
        this.defineError("IllegalFil", "Illegal unit of measure (replaced by filll)", "I dddon't go any higher than filll.");
        this.defineError("IllegalMu", "Illegal unit of measure (mu inserted)", "The unit of measurement in math glue must be mu.\nTo recover gracefully from this error, it's best to\ndelete the erroneous units; e.g., type `2' to delete\ntwo letters. (See Chapter 27 of The TeXbook.)");
        this.defineError("IllegalUnit", "Illegal unit of measure (pt inserted)", "Dimensions can be in units of em, ex, in, pt, pc,\ncm, mm, dd, cc, bp, or sp; but yours is a new one!\nI'll assume that you meant to say pt, for printer's points.\nTo recover gracefully from this error, it's best to\ndelete the erroneous units; e.g., type `2' to delete\ntwo letters. (See Chapter 27 of The TeXbook.)");
        this.defineError("DimenTooLarge", "Dimension too large", "I can't work with sizes bigger than about 19 feet.\nContinue and I'll use the largest value I can.");
        this.defineError("MissingLeftDefBrace", "Missing { inserted", "Where was the left brace? You said something like `\\def\\a}',\nwhich I'm going to interpret as `\\def\\a{}'.");
        this.defineError("TooManyParams", "You already have nine parameters", "I'm going to ignore the # sign you just used.");
        this.defineError("NonConseqParams", "Parameters must be numbered consecutively", "I've inserted the digit you should have used after the #.\nType `1' to delete what you did use.");
        this.defineError("IllegalParamNum", "Illegal parameter number in definition of %1", "You meant to type ## instead of #, right?\nOr maybe a } was forgotten somewhere earlier, and things\nare all screwed up? I'm going to assume that you meant ##.");
        this.defineError("EOFinRead", "File ended within %1", "This \\read has unbalanced braces.");
        this.defineError("ExtraOrElseFi", "Extra %1", "I'm ignoring this; it doesn't match any \\if.");
        this.defineError("IllegalIfnumOp", "Missing = inserted for %1", "I was expecting to see `<', `=', or `>'. Didn't.");
        this.defineBadTFM("TFMisBad", "Bad metric (TFM) file");
        this.defineBadTFM("TFMnotFound", "Metric (TFM) file not found");
        this.defineError("NotEnoughRoomForTFM", "Font %1 not loaded: Not enough room left", "I'm afraid I won't be able to make use of this font,\nbecause my memory for character-size data is too small.\nIf you're really stuck, ask a wizard to enlarge me.\nOr maybe try `I\\font<same font id>=<name of loaded font>'.");
        this.defineError("MissingFontIdent", "Missing font identifier", "I was looking for a control sequence whose\ncurrent meaning has been defined by \\font.");
        this.defineError("TooBigFontdimenNum", "Font %1 has only %2 fontdimen parameters", "To increase the number of font parameters, you must\nuse \\fontdimen immediately after the \\font is loaded.");
        this.defineError("PageTooLarge", "Huge page cannot be shipped out", "The page just created is more than 18 feet tall or\nmore than 18 feet wide, so I suspect something went wrong.");
        this.defineError("UndefFamily", "%1 %2 is undefined (character %3)", "Somewhere in the math formula just ended, you used the\nstated character from an undefined font family. For example,\nplain TeX doesn't allow \\it or \\sl in subscripts. Proceed,\nand I'll try to forget that I needed that character.");
        this.defineError("ImproperAlignInFormula", "Improper %1 inside $$'s", "Displays can use special alignments (like \\eqalignno)\nonly if nothing but the alignment itself is between $$'s.\nSo I've deleted the formulas that preceded this alignment.");
        this.defineError("MissingSharp", "Missing # inserted in alignment preamble", "There should be exactly one # between &'s, when an\n\\halign or \\valign is being set up. In this case you had\nnone, so I've put one in; maybe that will work.");
        this.defineError("SecondSharpInTab", "Only one # is allowed per tab", "There should be exactly one # between &'s, when an\n\\halign or \\valign is being set up. In this case you had\nmore than one, so I'm ignoring all but the first.");
        this.defineError("ExtraAlignTab", "Extra alignment tab has been changed to %1", "You have given more \\span or & marks than there were\nin the preamble to the \\halign or \\valign now in progress.\nSo I'll assume that you meant to type \\cr instead.");
        this.defineError("InfShringInPar", "Infinite glue shrinkage found in a paragraph", "The paragraph just ended includes some glue that has\ninfinite shrinkability, e.g., `\\hskip 0pt minus 1fil'.\nSuch glue doesn't belong there---it allows a paragraph\nof any length to fit on one line. But it's safe to proceed,\nsince the offensive shrinkability has been made finite.");
        this.defineError("ImproperHyphen", "Improper %1 will be flushed", "Hyphenation exceptions must contain only letters\nand hyphens. But continue; I'll forgive and forget.");
        this.defineError("NonLetterInHyph", "Not a letter", "Letters in \\hyphenation words must have \\lccode>0.\nProceed; I'll ignore the character I just read.");
        this.defineError("LatePatterns", "Too late for %1", "All patterns must be given before typesetting begins.");
        this.defineError("BadPatterns", "Bad %1", "(See Appendix H.)");
        this.defineError("NonLetter", "Nonletter", "(See Appendix H.)");
        this.defineError("DupPattern", "Duplicate pattern", "(See Appendix H.)");
        this.defineError("InfShrinkInVsplit", "Infinite glue shrinkage found in box being split", "The box you are \\vsplitting contains some infinitely\nshrinkable glue, e.g., `\\vss' or `\\vskip 0pt minus 1fil'.\nSuch glue doesn't belong there; but you can safely proceed,\nsince the offensive shrinkability has been made finite.");
        this.defineError("SplittingNonVbox", "%1 needs a %2", "The box you are trying to split is an \\hbox.\nI can't split such a box, so I'll leave it alone.");
        this.defineError("MisplacedInsert", "Insertions can only be added to a vbox", "Tut tut: You're trying to \\insert into a\n\\box register that now contains an \\hbox.\nProceed, and I'll discard its present contents.");
        this.defineError("InfShrinkInPage", "Infinite glue shrinkage found on current page", "The page about to be output contains some infinitely\nshrinkable glue, e.g., `\\vss' or `\\vskip 0pt minus 1fil'.\nSuch glue doesn't belong there; but you can safely proceed,\nsince the offensive shrinkability has been made finite.");
        this.defineError("InfShrinkInsert", "Infinite glue shrinkage inserted from %1%2", "The correction glue for page breaking with insertions\nmust have finite shrinkability. But you may proceed,\nsince the offensive shrinkability has been made finite.");
        this.defineError("NonEmptyOutBox", "%1%2 is not void", "You shouldn't use \\box255 except in \\output routines.\nProceed, and I'll discard its present contents.");
        this.defineError("TooMuchDead", "Output loop---%1 consecutive dead cycles", "I've concluded that your \\output is awry; it never does a\n\\shipout, so I'm shipping \\box255 out myself. Next time\nincrease \\maxdeadcycles if you want me to be more patient!");
        this.defineError("UnbalancedOutput", "Unbalanced output routine", "Your sneaky output routine has problematic {'s and/or }'s.\nI can't handle that very well; good luck.");
        this.defineError("NonEmptyOutBoxAfter", "Output routine didn't use all of %1%2", "Your \\output commands should empty \\box255,\ne.g., by saying `\\shipout\\box255'.\nProceed; I'll discard its present contents.");
        this.defineError("MissingDollar", "Missing $ inserted", "I've inserted a begin-math/end-math symbol since I think\nyou left one out. Proceed, with fingers crossed.");
        this.defineError("CantUseIn", "You can't use `%1' in %2", "Sorry, but I'm not programmed to handle this case;\nI'll just pretend that you didn't ask for it.\nIf you're in the wrong mode, you might be able to\nreturn to the right one by typing `I}' or `I$' or `I\\par'.");
        this.defineError("MissingInserted", "Missing %1 inserted", "I've inserted something that you may have forgotten.\n(See the <inserted text> above.)\nWith luck, this will get me unwedged. But if you\nreally didn't forget anything, try typing `2' now; then\nmy insertion and my current dilemma will both disappear.");
        this.defineError("ExtraCommand", "Extra %1", "Things are pretty mixed up, but I think the worst is over.");
        this.defineError("TooManyRightBraces", "Too many }'s", "You've closed more groups than you opened.\nSuch booboos are generally harmless, so keep going.");
        this.defineError("ExtraOrForgotten", "Extra }, or forgotten %1", "I've deleted a group-closing symbol because it seems to be\nspurious, as in `$x}$'. But perhaps the } is legitimate and\nyou forgot something else, as in `\\hbox{$x}'. In such cases\nthe way to recover is to insert both the forgotten and the\ndeleted material, e.g., by typing `I$}'.");
        this.defineError("BadGlueAfterLeaders", "Leaders not followed by proper glue", "You should say `\\leaders <box or rule><hskip or vskip>'.\nI found the <box or rule>, but there's no suitable\n<hskip or vskip>, so I'm ignoring these leaders.");
        this.defineError("LastBoxIn", "You can't use `%1' in %2", "Sorry; this \\lastbox will be void.\n");
        this.defineError("CantTakeFromPage", "You can't use `%1' in %2", "Sorry...I usually can't take things from the current page.\nThis \\lastbox will therefore be void.");
        this.defineError("MissingToForVsplit", "Missing `to' inserted", "I'm working on `\\vsplit<box number> to <dimen>';\nwill look for the <dimen> next.");
        this.defineError("BoxExpected", "A <box> was supposed to be here", "I was expecting to see \\hbox or \\vbox or \\copy or \\box or\nsomething like that. So you might find something missing in\nyour output. But keep trying; you can fix this later.");
        this.defineError("CantUseHrule", "You can't use `%1' here except with leaders", "To put a horizontal rule in an hbox or an alignment,\nyou should use \\leaders or \\hrulefill (see The TeXbook).");
        this.defineError("CantInsertOutbox", "You can't %1%2", "I'm changing to %1%3; box %2 is special.");
        this.defineCantDeleteLastItem("CantDeleteLastSkip", "Try `I\\vskip-\\lastskip' instead");
        this.defineCantDeleteLastItem("CantDeleteLastKern", "Try `I\\kern-\\lastkern' instead");
        this.defineCantDeleteLastItem("CantDeleteLastPenalty", "Perhaps you can make the output routine do it");
        this.defineError("IncompatibleUnbox", "Incompatible list can't be unboxed", "Sorry, Pandora. (You sneaky devil.)\nI refuse to unbox an \\hbox in vertical mode or vice versa.\nAnd I can't open any boxes in math mode.");
        this.defineError("IllegalMathDisc", "Illegal math %1", "Sorry: The third part of a discretionary break must be\nempty, in math formulas. I had to delete your third part.");
        this.defineError("TooLongDisc", "Discretionary list is too long", "Wow---I never thought anybody would tweak me here.\nYou can't seriously need such a huge discretionary list?");
        this.defineError("ImproperDisc", "Improper discretionary list", "Discretionary lists must contain only boxes and kerns.");
        this.defineAllignError("AllignLeftError", "{");
        this.defineAllignError("AllignRightError", "}");
        this.defineError("MisplacedTabMark", "Misplaced %1", "I can't figure out why you would want to use a tab mark\nhere. If you just want an ampersand, the remedy is\nsimple: Just type `I\\&' now. But if some right brace\nup above has ended a previous alignment prematurely,\nyou're probably due for more error messages, and you\nmight try typing `S' now just to see what is salvageable.");
        this.defineError("MisplacedCrSpan", "Misplaced %1", "I can't figure out why you would want to use a tab mark\nor \\cr or \\span just now. If something like a right brace\nup above has ended a previous alignment prematurely,\nyou're probably due for more error messages, and you\nmight try typing `S' now just to see what is salvageable.");
        this.defineError("MisplacedNoalign", "Misplaced %1", "I expect to see \\noalign only after the \\cr of\nan alignment. Proceed, and I'll ignore this case.");
        this.defineError("MisplacedOmit", "Misplaced %1", "I expect to see \\omit only after tab marks or the \\cr of\nan alignment. Proceed, and I'll ignore this case.");
        this.defineError("MissingCr", "Missing %1 inserted", "I'm guessing that you meant to end an alignment here.");
        this.defineError("ExtraEndcsname", "Extra %1", "I'm ignoring this, since I wasn't doing a \\csname.");
        this.defineError("MisplacedLimits", "Limit controls must follow a math operator", "I'm ignoring this misplaced \\limits or \\nolimits command.");
        this.defineError("MissingDelim", "Missing delimiter (. inserted)", "I was expecting to see something like `(' or `\\{' or\n`\\}' here. If you typed, e.g., `{' instead of `\\{', you\nshould probably delete the `{' by typing `1' now, so that\nbraces don't get unbalanced. Otherwise just proceed.\nAcceptable delimiters are characters whose \\delcode is\nnonnegative, or you can use `\\delimiter <delimiter code>'.");
        this.defineError("AccentInMathMode", "Please use %1 for accents in math mode", "I'm changing \\accent to \\mathaccent here; wish me luck.\n(Accents are not the same in formulas as they are in text.)");
        this.defineError("DoubleSuperscript", "Double superscript", "I treat `x^1^2' essentially like `x^1{}^2'.");
        this.defineError("DoubleSubscript", "Double subscript", "I treat `x_1_2' essentially like `x_1{}_2'.");
        this.defineError("AmbiguousFraction", "Ambiguous; you need another { and }", "I'm ignoring this fraction specification, since I don't\nknow whether a construction like `x \\over y \\over z'\nmeans `{x \\over y} \\over z' or `x \\over {y \\over z}'.");
        this.defineError("ExtraRight", "Extra %1", "I'm ignoring a \\right that had no matching \\left.");
        this.defineError("InsufSymFonts", "Math formula deleted: Insufficient symbol fonts", "Sorry, but I can't typeset math unless \\textfont 2\nand \\scriptfont 2 and \\scriptscriptfont 2 have all\nthe \\fontdimen values needed in math symbol fonts.");
        this.defineError("InsufExtFonts", "Math formula deleted: Insufficient extension fonts", "Sorry, but I can't typeset math unless \\textfont 3\nand \\scriptfont 3 and \\scriptscriptfont 3 have all\nthe \\fontdimen values needed in math extension fonts.");
        this.defineError("BadFormulaEnd", "Display math should end with $$", "The `$' that I just saw supposedly matches a previous `$$'.\nSo I shall assume that you typed `$$' both times.");
        this.defineError("MissingFormulaEnd", "Missing $$ inserted", "Displays can use special alignments (like \\eqalignno)\nonly if nothing but the alignment itself is between $$'s.");
        this.defineError("NonPrefixCommand", "You can't use a prefix with `%1'", "I'll pretend you didn't say \\long or \\outer or \\global.");
        this.defineError("NonDefineCommand", "You can't use `%1' or `%2' with `%3'", "I'll pretend you didn't say \\long or \\outer here.");
        this.defineError("MissingCtrlSeq", "Missing control sequence inserted", "Please don't say `\\def cs{...}', say `\\def\\cs{...}'.\nI've inserted an inaccessible control sequence so that your\ndefinition will be completed without mixing me up too badly.\nYou can recover graciously from this error, if you're\ncareful; see exercise 27.2 in The TeXbook.");
        this.defineError("MissingToForRead", "Missing `to' inserted", "You should have said `\\read<number> to \\cs'.\nI'm going to look for the \\cs now.");
        this.defineCodeOut("CodeOutOfRange", "in the range 0..");
        this.defineCodeOut("CodeGreater", "at most ");
        this.defineError("ArithOverflow", "Arithmetic overflow", "I can't carry out that multiplication or division,\nsince the result is out of range.");
        this.defineError("CantUseAfter", "You can't use `%1' after %2", "I'm forgetting what you said and not changing anything.");
        this.defineError("ImproperSetbox", "Improper %1", "Sorry, \\setbox is not allowed after \\halign in a display,\nor between \\accent and an accented character.");
        this.defineError("BadSpaceFactor", "Bad space factor (%1)", "I allow only values in the range %2..%3 here.");
        this.defineError("BadPrevGraf", "Bad %1 (%2)", "I allow only nonnegative values here.");
        this.defineError("CantLoadPatterns", "Patterns can be loaded only by INITEX", null);
        this.defineError("ImproperAt", "Improper `at' size (%1pt), replaced by 10pt", "I can only handle fonts at positive sizes that are\nless than 2048pt, so I've changed what you said to 10pt.");
        this.defineError("ShortShow", null, "This isn't an error message; I'm just \\showing something.\nType `I\\show...' to show more (e.g., \\show\\cs,\n\\showthe\\count10, \\showbox255, \\showlists).");
        this.defineError("LongShow", null, "This isn't an error message; I'm just \\showing something.\nType `I\\show...' to show more (e.g., \\show\\cs,\n\\showthe\\count10, \\showbox255, \\showlists).\nAnd type `I\\tracingonline=1\\show...' to show boxes and\nlists on your terminal as well as in the transcript file.");
        this.defineError("DumpInGroup", "You can't dump inside a group", "`{...\\dump}' is a no-no.");
        this.defineError("UnbalancedWrite", "Unbalanced write command", "On this page there's a \\write with fewer real {'s than }'s.\nI can't handle that very well; good luck.");
        this.defineFatalError("EOFonTerm", "End of file on the terminal!");
        this.defineFatalError("NoEnd", "*** (job aborted, no legal \\end found)");
        this.defineFatalError("NoTermRead", "*** (cannot \\read from terminal in nonstop modes)");
        this.defineFatalError("MissingFile", "*** (job aborted, file error in nonstop mode)");
        this.defineFatalError("IntAlignPre", "(interwoven alignment preambles are not allowed)");
    }

    public TeXErrorPool() {
        this.block$();
    }
}

