/* This is a -*- REXX -*- script.  */

parse arg sub;

'@ cd' os2name(getenv('TEXMFROOT', '.')) '>nul 2>&1';
if sub \= '' then
  '@ cd' os2name(sub) '>nul 2>&1';

return rc;


/* REXXLIB: os2name getenv */

getenv: procedure
  parse arg name, default;
  variable = value(name, , 'OS2ENVIRONMENT');
  if variable = '' then
    variable = default;
  return variable;

toupper: procedure
  parse arg string;
  return translate(string,
    'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
      'abcdefghijklmnopqrstuvwxyz');
  
tilde: procedure
  parse arg string, mode;
  home = getenv('HOME');
  if home = '' then
    return string;
  if mode = '' then
    mode = 'E';
  else
    mode = left(toupper(mode), 1);
  select
    when mode = 'E' then
      if left(string, 1) = '~' then
	string = home||substr(string, 2);
    when mode = 'R' then
      do
	home_len = length(home); string_len = length(string);
	if string_len >= home_len & left(string, home_len) = home then
	  string = '~'||substr(string, home_len + 1);
      end;
    otherwise
      nop;
  end;
  return string;

os2name: procedure
  parse arg name;
  name = tilde(name, 'e');
  name = translate(name, '\', '/');
  name = strip(name, 't', '\');
  return name;
