/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.resource;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.util.IResourceScopeCache;

public class STAlgorithmResourceDescription
extends DefaultResourceDescription {
    private final IQualifiedNameConverter nameConverter;
    private Iterable<QualifiedName> importedNames;

    public STAlgorithmResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.nameConverter = nameConverter;
    }

    public Iterable<QualifiedName> getImportedNames() {
        if (this.importedNames == null) {
            this.importedNames = this.computeImportedNames();
        }
        return this.importedNames;
    }

    protected Set<QualifiedName> computeImportedNames() {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)this.getResource(), (boolean)true);
        while (allContents.hasNext()) {
            EObject target = (EObject)allContents.next();
            if (target instanceof STSource) {
                allContents.prune();
                continue;
            }
            if (target instanceof Attribute) {
                Attribute attribute = (Attribute)target;
                this.computeImportedNames(attribute, result);
                continue;
            }
            if (target instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)target;
                this.computeImportedNames(varDeclaration, result);
                continue;
            }
            if (!(target instanceof TypedConfigureableObject)) continue;
            TypedConfigureableObject typedConfigureableObject = (TypedConfigureableObject)target;
            this.computeImportedNames(typedConfigureableObject, result);
        }
        super.getImportedNames().forEach(result::add);
        return result;
    }

    protected void computeImportedNames(Attribute attr, Set<QualifiedName> result) {
        STInitializerExpressionSource source;
        String fullTypeName = PackageNameHelper.getFullTypeName((LibraryElement)attr.getType());
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.nameConverter.toQualifiedName(fullTypeName).toLowerCase());
        }
        if (!STCoreUtil.isSimpleAttributeValue((Attribute)attr, (boolean)false) && (source = StructuredTextParseUtil.validate(attr.getValue(), this.getURI(), STCoreUtil.getFeatureType((INamedElement)attr), (LibraryElement)EcoreUtil2.getContainerOfType((EObject)attr, LibraryElement.class), null, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames(source.eResource()));
        }
    }

    protected void computeImportedNames(VarDeclaration decl, Set<QualifiedName> result) {
        STTypeDeclaration source;
        String fullTypeName = PackageNameHelper.getFullTypeName((LibraryElement)decl.getType());
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.nameConverter.toQualifiedName(fullTypeName).toLowerCase());
        }
        if (decl.isArray() && !TypeDeclarationParser.isSimpleTypeDeclaration((String)decl.getArraySize().getValue()) && (source = StructuredTextParseUtil.validateType(decl, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames(source.eResource()));
        }
        if (!STCoreUtil.isSimpleInitialValue((VarDeclaration)decl, (boolean)false) && (source = StructuredTextParseUtil.validate(decl.getValue().getValue(), this.getURI(), STCoreUtil.getFeatureType((INamedElement)decl), (LibraryElement)EcoreUtil2.getContainerOfType((EObject)decl, LibraryElement.class), null, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames(source.eResource()));
        }
    }

    protected void computeImportedNames(TypedConfigureableObject element, Set<QualifiedName> result) {
        String fullTypeName = element.getFullTypeName();
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.nameConverter.toQualifiedName(fullTypeName).toLowerCase());
        }
    }

    protected static Set<QualifiedName> getImportedNames(Resource resource) {
        EcoreUtil.resolveAll((Resource)resource);
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find((Resource)resource);
        if (adapter != null) {
            return adapter.getImportedNames();
        }
        return Collections.emptySet();
    }
}

