/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac;

import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class Bpmn2PropertyPageRedrawHandler {
    private static int UIJOB_INTERRUPT_INTERVAL = 150;
    private static int NEEDS_REDRAW_INTERVAL = 1000;
    static Hashtable<Composite, Bpmn2PropertyPageRedrawHandler> handlers = new Hashtable();
    UIJob job;
    long lastRedrawTime;
    final Composite rootComposite;

    private Bpmn2PropertyPageRedrawHandler(final Composite rootComposite) {
        this.rootComposite = rootComposite;
        rootComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (e.widget != rootComposite) {
                    Bpmn2PropertyPageRedrawHandler.dispose(rootComposite);
                } else if (e.widget instanceof Composite) {
                    Bpmn2PropertyPageRedrawHandler.dispose((Composite)e.widget);
                }
            }
        });
    }

    public static void redraw(Composite child) {
        Bpmn2PropertyPageRedrawHandler handler = Bpmn2PropertyPageRedrawHandler.findHandler(child);
        if (handler != null) {
            handler.scheduleRedrawPage();
        }
    }

    public static boolean needsRedraw(Composite child) {
        Bpmn2PropertyPageRedrawHandler handler = Bpmn2PropertyPageRedrawHandler.findHandler(child);
        if (handler != null) {
            return System.currentTimeMillis() - handler.lastRedrawTime > (long)NEEDS_REDRAW_INTERVAL;
        }
        return false;
    }

    public static void dispose(Composite child) {
        Bpmn2PropertyPageRedrawHandler handler = Bpmn2PropertyPageRedrawHandler.findHandler(child);
        if (handler != null) {
            if (handler.job != null) {
                handler.job.cancel();
            }
            handlers.remove(handler.rootComposite);
        }
    }

    private synchronized void scheduleRedrawPage() {
        if (this.job == null) {
            this.job = new UIJob("BPMN2 Property Page redraw"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        Bpmn2PropertyPageRedrawHandler.this.doRedrawPage();
                    }
                    catch (Exception exception) {}
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.job.getState() == 2) {
            this.job.cancel();
        }
        this.job.schedule((long)UIJOB_INTERRUPT_INTERVAL);
    }

    private void doRedrawPage() {
        if (!this.rootComposite.isDisposed()) {
            this.rootComposite.setRedraw(false);
            this.rootComposite.layout();
            Point p = this.rootComposite.getSize();
            ++p.x;
            ++p.y;
            this.rootComposite.setSize(p);
            --p.x;
            --p.y;
            this.rootComposite.setSize(p);
            this.rootComposite.setRedraw(true);
            this.lastRedrawTime = System.currentTimeMillis();
        }
    }

    private static Bpmn2PropertyPageRedrawHandler findHandler(Composite child) {
        Bpmn2PropertyPageRedrawHandler handler = null;
        Composite composite = Bpmn2PropertyPageRedrawHandler.findRootComposite(child);
        if (composite != null) {
            if (handlers.containsKey(composite)) {
                handler = handlers.get(composite);
            } else if (!composite.isDisposed()) {
                handler = new Bpmn2PropertyPageRedrawHandler(composite);
                handlers.put(composite, handler);
            }
        }
        return handler;
    }

    private static Composite findRootComposite(Composite child) {
        if (child != null) {
            if (handlers.containsKey(child)) {
                return child;
            }
            Composite composite = child.getParent();
            while (composite != null && !(composite instanceof ScrolledComposite)) {
                composite = composite.getParent();
            }
            if (composite != null) {
                composite = composite.getParent();
            }
            return composite;
        }
        return null;
    }
}

