/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2ToolBehaviorProvider;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.preferences.Bpmn2EditorBehaviorPreferencePage;
import org.eclipse.bpmn2.modeler.ui.preferences.Bpmn2HomePreferencePage;
import org.eclipse.bpmn2.modeler.ui.preferences.Messages;
import org.eclipse.bpmn2.modeler.ui.preferences.ModelEnablementTreeEntry;
import org.eclipse.bpmn2.modeler.ui.preferences.ModelEnablementTreeViewer;
import org.eclipse.bpmn2.modeler.ui.preferences.ToolProfilesPreferencesHelper;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ToolProfilesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String PAGE_ID = "org.eclipse.bpmn2.modeler.Profiles";
    private Bpmn2Preferences preferences;
    private TargetRuntime currentRuntime;
    private String currentProfileName;
    private final List<ModelEnablementTreeEntry> bpmnEntries = new ArrayList<ModelEnablementTreeEntry>();
    private final List<ModelEnablementTreeEntry> extensionEntries = new ArrayList<ModelEnablementTreeEntry>();
    private Combo cboRuntimes;
    private Combo cboProfiles;
    private Button btnUseAsDefaultProfile;
    private Button btnCreateProfile;
    private Button btnDeleteProfile;
    private TabFolder folder;
    private Button btnShowIds;
    private ModelEnablementTreeViewer bpmnTreeViewer;
    private Tree bpmnTree;
    private ModelEnablementTreeViewer extensionTreeViewer;
    private Tree extensionTree;
    private TreeViewer paletteTreeViewer;
    private Tree paletteTree;
    private Button btnAddDrawer;
    private Button btnDeleteDrawer;
    private Button btnAddTool;
    private Button btnDeleteTool;
    private Button btnEditTool;
    private static ToolPaletteDescriptor defaultToolPalette = null;
    private ToolProfilesHelperMap helpers = new ToolProfilesHelperMap();

    public ToolProfilesPreferencePage() {
        this.preferences = Bpmn2Preferences.getInstance();
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.preferences = Bpmn2Preferences.getInstance();
        ToolProfilesPreferencesHelper.setEnableIdAttribute(this.preferences.getShowIdAttribute());
    }

    private ToolProfilesPreferencesHelper getHelper(TargetRuntime rt, String profileName) {
        ToolProfilesPreferencesHelper helper = this.helpers.get(rt, profileName);
        if (helper == null) {
            helper = new ToolProfilesPreferencesHelper(rt, profileName);
            ModelEnablements me = this.preferences.getModelEnablements(rt, profileName);
            helper.setModelEnablements(me);
            this.helpers.put(rt, profileName, helper);
        } else {
            ToolProfilesPreferencesHelper.setEnableIdAttribute(this.btnShowIds.getSelection());
            ModelEnablements me = helper.getModelEnablements();
            if (me == null) {
                me = this.preferences.getModelEnablements(rt, profileName);
            }
            helper.setModelEnablements(me);
        }
        return helper;
    }

    private boolean hasHelper(TargetRuntime rt, String profileName) {
        return this.helpers.get(rt, profileName) != null;
    }

    public Control createContents(final Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        BPMN2Editor activeEditor = BPMN2Editor.getActiveEditor();
        this.currentRuntime = activeEditor != null ? activeEditor.getTargetRuntime() : TargetRuntime.getDefaultRuntime();
        this.currentProfileName = "";
        Label lblRuntime = new Label(container, 0);
        lblRuntime.setText(Messages.ToolProfilesPreferencePage_TargetRuntime_Label);
        lblRuntime.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.cboRuntimes = new Combo(container, 8);
        this.cboRuntimes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cboRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = ToolProfilesPreferencePage.this.cboRuntimes.getText();
                ToolProfilesPreferencePage.this.currentRuntime = (TargetRuntime)ToolProfilesPreferencePage.this.cboRuntimes.getData(s);
                ToolProfilesPreferencePage.this.fillProfilesCombo();
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        this.fillRuntimesCombo();
        Label lblProfile = new Label(container, 0);
        lblProfile.setText(Messages.ToolProfilesPreferencePage_ToolProfile_Label);
        lblProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 3, 1));
        this.cboProfiles = new Combo(container, 8);
        this.cboProfiles.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cboProfiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = ToolProfilesPreferencePage.this.cboProfiles.getText();
                ModelEnablementDescriptor med = (ModelEnablementDescriptor)ToolProfilesPreferencePage.this.cboProfiles.getData(text);
                ToolProfilesPreferencePage.this.currentProfileName = med.getProfileName();
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)new GridLayout(4, false));
        buttonContainer.setLayoutData((Object)new GridData(4, 16384, true, false, 4, 1));
        this.btnUseAsDefaultProfile = new Button(buttonContainer, 32);
        this.btnUseAsDefaultProfile.setText(Messages.ToolProfilesPreferencePage_SetDefaultProfile_Button);
        this.btnUseAsDefaultProfile.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Label lblFiller = new Label(buttonContainer, 0);
        lblFiller.setText("");
        lblFiller.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCreateProfile = new Button(buttonContainer, 8);
        this.btnCreateProfile.setText(Messages.ToolProfilesPreferencePage_NewProfile_Button);
        this.btnCreateProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnCreateProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog dlg = new CreateProfileDialog(parent.getShell());
                if (dlg.open() == 0) {
                    String profileName = dlg.getValue();
                    String description = dlg.getDescription();
                    ToolProfilesPreferencePage.this.currentProfileName = "profile." + profileName.replaceAll(" ", ".");
                    ToolProfilesPreferencePage.this.preferences.createToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName, profileName, description);
                    ToolProfilesPreferencePage.this.preferences.setDefaultToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName);
                    if (dlg.getCopyProfile() != null) {
                        ModelEnablementDescriptor med = dlg.getCopyProfile();
                        ToolProfilesPreferencesHelper helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, med.getProfileName());
                        ModelEnablements copyMe = helper.getModelEnablements();
                        helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName);
                        helper.copyModelEnablements(copyMe);
                        ToolProfilesPreferencePage.this.preferences.setModelEnablements(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName, helper.getModelEnablements());
                    }
                    ToolProfilesPreferencePage.this.fillProfilesCombo();
                    ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                    ToolProfilesPreferencePage.this.fillPaletteTree();
                }
            }
        });
        this.btnDeleteProfile = new Button(buttonContainer, 8);
        this.btnDeleteProfile.setText(Messages.ToolProfilesPreferencePage_DeleteProfile_Button);
        this.btnDeleteProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnDeleteProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)ToolProfilesPreferencePage.this.getShell(), (String)Messages.ToolProfilesPreferencePage_DeleteProfile_Title, (String)Messages.ToolProfilesPreferencePage_DeleteProfile_Message)) {
                    ToolProfilesPreferencePage.this.preferences.deleteToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName);
                    ToolProfilesPreferencePage.this.fillProfilesCombo();
                    ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                    ToolProfilesPreferencePage.this.fillPaletteTree();
                }
            }
        });
        this.fillProfilesCombo();
        this.folder = new TabFolder(container, 0);
        this.folder.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.folder.setLayout((Layout)layout);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        TabItem elementsTab = new TabItem(this.folder, 0);
        elementsTab.setText(Messages.ToolProfilesPreferencePage_EnabledElements_Tab);
        TabItem paletteTab = new TabItem(this.folder, 0);
        paletteTab.setText(Messages.ToolProfilesPreferencePage_ToolPalette_Tab);
        Composite elementsContainer = new Composite((Composite)this.folder, 0);
        elementsContainer.setLayout((Layout)new GridLayout(2, false));
        elementsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.btnShowIds = new Button(elementsContainer, 32);
        this.btnShowIds.setText(Messages.ToolProfilesPreferencePage_ShowID_Button);
        this.btnShowIds.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowIds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolProfilesPreferencesHelper.setEnableIdAttribute(ToolProfilesPreferencePage.this.btnShowIds.getSelection());
                ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName);
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        this.btnShowIds.setSelection(this.preferences.getShowIdAttribute());
        ICheckStateListener checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Object element = event.getElement();
                if (element instanceof ModelEnablementTreeEntry) {
                    ModelEnablementTreeEntry entry = (ModelEnablementTreeEntry)((Object)element);
                    ToolProfilesPreferencesHelper helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName);
                    helper.setEnabled(entry, checked);
                    if (entry.hasChildren()) {
                        for (ModelEnablementTreeEntry c : entry.getChildren()) {
                            helper.setEnabled(c, checked);
                        }
                    }
                }
            }
        };
        this.bpmnTreeViewer = new ModelEnablementTreeViewer(elementsContainer, Messages.ToolProfilePreferencePage_Standard_Elements_Label);
        this.bpmnTree = this.bpmnTreeViewer.getTree();
        this.bpmnTreeViewer.addCheckStateListener(checkStateListener);
        this.extensionTreeViewer = new ModelEnablementTreeViewer(elementsContainer, Messages.ToolProfilePreferencePage_Extension_Elements_Label);
        this.extensionTree = this.extensionTreeViewer.getTree();
        this.extensionTreeViewer.addCheckStateListener(checkStateListener);
        Composite paletteContainer = new Composite((Composite)this.folder, 0);
        paletteContainer.setLayout((Layout)new GridLayout(2, false));
        paletteContainer.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.paletteTreeViewer = new TreeViewer(paletteContainer, 2048);
        this.paletteTree = this.paletteTreeViewer.getTree();
        this.paletteTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite paletteButtonsContainer = new Composite(paletteContainer, 0);
        paletteButtonsContainer.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(131072, 128, false, false, 1, 1);
        data.exclude = true;
        paletteButtonsContainer.setLayoutData((Object)data);
        paletteButtonsContainer.setVisible(false);
        this.btnAddDrawer = new Button(paletteButtonsContainer, 8);
        this.btnAddDrawer.setText(Messages.ToolProfilesPreferencePage_AddDrawer_Button);
        this.btnAddDrawer.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAddDrawer.setEnabled(false);
        this.btnDeleteDrawer = new Button(paletteButtonsContainer, 8);
        this.btnDeleteDrawer.setText(Messages.ToolProfilesPreferencePage_DeleteDrawer_Button);
        this.btnDeleteDrawer.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnDeleteDrawer.setEnabled(false);
        this.btnAddTool = new Button(paletteButtonsContainer, 8);
        this.btnAddTool.setText(Messages.ToolProfilesPreferencePage_AddTool_Button);
        this.btnAddTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAddTool.setEnabled(false);
        this.btnDeleteTool = new Button(paletteButtonsContainer, 8);
        this.btnDeleteTool.setText(Messages.ToolProfilesPreferencePage_DeleteTool_Button);
        this.btnDeleteTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnDeleteTool.setEnabled(false);
        this.btnEditTool = new Button(paletteButtonsContainer, 8);
        this.btnEditTool.setText(Messages.ToolProfilesPreferencePage_EditTool_Button);
        this.btnEditTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnEditTool.setEnabled(false);
        elementsTab.setControl((Control)elementsContainer);
        elementsContainer.setBackground(parent.getBackground());
        paletteTab.setControl((Control)paletteContainer);
        paletteContainer.setBackground(parent.getBackground());
        Composite importExportButtons = new Composite(container, 0);
        importExportButtons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 4, 1));
        importExportButtons.setLayout((Layout)new FillLayout());
        Button btnImportProfile = new Button(importExportButtons, 0);
        btnImportProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    try {
                        ToolProfilesPreferencePage.this.bpmnEntries.clear();
                        ToolProfilesPreferencePage.this.extensionEntries.clear();
                        ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName).importProfile(path);
                        ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                        ToolProfilesPreferencePage.this.fillPaletteTree();
                    }
                    catch (Exception e1) {
                        Activator.showErrorWithLogging(e1);
                    }
                }
            }
        });
        btnImportProfile.setText(Messages.ToolProfilePreferencePage_Import);
        Button btnExportProfile = new Button(importExportButtons, 0);
        btnExportProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 8192);
                String path = dialog.open();
                if (path != null) {
                    try {
                        ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentProfileName).exportProfile(path);
                    }
                    catch (Exception e1) {
                        Activator.showErrorWithLogging(e1);
                    }
                }
            }
        });
        btnExportProfile.setText(Messages.ToolProfilePreferencePage_Export);
        this.fillModelEnablementTrees();
        this.fillPaletteTree();
        this.bpmnTree.setEnabled(true);
        this.extensionTree.setEnabled(true);
        return container;
    }

    private void fillRuntimesCombo() {
        int i = 0;
        for (TargetRuntime r : TargetRuntime.createTargetRuntimes()) {
            this.cboRuntimes.add(r.getName());
            this.cboRuntimes.setData(r.getName(), (Object)r);
            if (r == this.currentRuntime) {
                this.cboRuntimes.select(i);
            }
            ++i;
        }
    }

    private void fillProfilesCombo() {
        if (this.cboProfiles != null) {
            int i = 0;
            int iSelected = -1;
            this.currentProfileName = this.preferences.getDefaultToolProfile(this.currentRuntime);
            this.cboProfiles.removeAll();
            String[] stringArray = this.preferences.getAllToolProfiles(this.currentRuntime);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String profileName = stringArray[n2];
                ModelEnablementDescriptor med = this.currentRuntime.getModelEnablements(profileName);
                String text = med.getProfileName();
                if (text == null || text.isEmpty()) {
                    text = String.valueOf(Messages.ToolProfilePreferencePage_Unnamed) + (i + 1);
                }
                this.cboProfiles.add(text);
                this.cboProfiles.setData(text, (Object)med);
                if (iSelected < 0 && this.currentProfileName != null && this.currentProfileName.equals(profileName)) {
                    iSelected = i;
                    this.cboProfiles.select(iSelected);
                }
                ++i;
                ++n2;
            }
            if (this.btnDeleteProfile != null) {
                this.btnDeleteProfile.setEnabled(this.cboProfiles.getItemCount() > 0);
            }
        }
    }

    private void fillModelEnablementTrees() {
        this.loadModelEnablements();
        this.bpmnTreeViewer.setInput(this.bpmnEntries);
        this.extensionTreeViewer.setInput(this.extensionEntries);
    }

    private boolean isEnabled(ToolPaletteDescriptor.ToolDescriptor td) {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentProfileName);
        for (ToolPaletteDescriptor.ToolPart tp : td.getToolParts()) {
            if (this.isEnabled(helper, tp)) continue;
            return false;
        }
        return true;
    }

    private boolean isEnabled(ToolPaletteDescriptor.ToolPart tp) {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentProfileName);
        return this.isEnabled(helper, tp);
    }

    private boolean isEnabled(ToolProfilesPreferencesHelper helper, ToolPaletteDescriptor.ToolPart tp) {
        String name = tp.getName();
        if (name != null && !name.isEmpty() && !helper.isEnabled(name)) {
            return false;
        }
        for (ToolPaletteDescriptor.ToolPart child : tp.getChildren()) {
            if (this.isEnabled(helper, child)) continue;
            return false;
        }
        return true;
    }

    private void fillPaletteTree() {
        if (this.paletteTreeViewer == null) {
            return;
        }
        this.loadPalette();
        ToolPaletteDescriptor toolPaletteDescriptor = this.currentRuntime.getToolPalette(this.currentProfileName);
        if (toolPaletteDescriptor == null) {
            toolPaletteDescriptor = defaultToolPalette;
        }
        if (this.paletteTreeViewer.getContentProvider() == null) {
            this.paletteTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element) != null;
                }

                public Object getParent(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        return null;
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        return ((ToolPaletteDescriptor.CategoryDescriptor)element).getParent();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        return ((ToolPaletteDescriptor.ToolDescriptor)element).getParent();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolPart) {
                        return ((ToolPaletteDescriptor.ToolPart)element).getParent();
                    }
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public Object[] getChildren(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        ArrayList<ToolPaletteDescriptor.CategoryDescriptor> kids = new ArrayList<ToolPaletteDescriptor.CategoryDescriptor>();
                        for (ToolPaletteDescriptor.CategoryDescriptor cd : ((ToolPaletteDescriptor)element).getCategories()) {
                            if (cd.getName() == null && "org.bpmn2.modeler.toolpalette.default.categories".equals(cd.getId())) {
                                kids.addAll(defaultToolPalette.getCategories());
                                continue;
                            }
                            if (cd.getFromPalette() != null) {
                                for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                                    block2: for (ToolPaletteDescriptor td : rt.getToolPaletteDescriptors()) {
                                        if (!cd.getFromPalette().equals(td.getId())) continue;
                                        for (ToolPaletteDescriptor.CategoryDescriptor cd2 : td.getCategories()) {
                                            if (!cd.getId().equals(cd2.getId())) continue;
                                            kids.add(cd2);
                                            continue block2;
                                        }
                                    }
                                }
                                continue;
                            }
                            kids.add(cd);
                        }
                        return kids.toArray();
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        return ((ToolPaletteDescriptor.CategoryDescriptor)element).getTools().toArray();
                    }
                    return null;
                }
            });
            this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public Image getImage(Object element) {
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        ToolPaletteDescriptor.CategoryDescriptor cd = (ToolPaletteDescriptor.CategoryDescriptor)element;
                        int enabled = 0;
                        for (ToolPaletteDescriptor.ToolDescriptor td : cd.getTools()) {
                            if (!ToolProfilesPreferencePage.this.isEnabled(td)) continue;
                            ++enabled;
                        }
                        if (enabled == 0) {
                            return Activator.getDefault().getImage("16/folder_disabled.png");
                        }
                        return Activator.getDefault().getImage("16/folder.png");
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        ToolPaletteDescriptor.ToolDescriptor td = (ToolPaletteDescriptor.ToolDescriptor)element;
                        if (!ToolProfilesPreferencePage.this.isEnabled(td)) {
                            return Activator.getDefault().getImage("16/disabled.png");
                        }
                        List tps = td.getToolParts();
                        if (!tps.isEmpty()) {
                            if (tps.size() > 2) {
                                return Activator.getDefault().getImage("16/Process.png");
                            }
                            ToolPaletteDescriptor.ToolPart tp = (ToolPaletteDescriptor.ToolPart)tps.get(0);
                            String name = "16/" + tp.getName() + ".png";
                            if (!tp.getChildren().isEmpty()) {
                                name = "16/" + ((ToolPaletteDescriptor.ToolPart)tp.getChildren().get(0)).getName() + ".png";
                            }
                            return Activator.getDefault().getImage(name);
                        }
                    } else {
                        boolean cfr_ignored_0 = element instanceof ToolPaletteDescriptor.ToolPart;
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        return (String)((ToolPaletteDescriptor)element).getProfileIds().get(0);
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        ToolPaletteDescriptor.CategoryDescriptor cd = (ToolPaletteDescriptor.CategoryDescriptor)element;
                        if (cd.getFromPalette() != null) {
                            return cd.getFromPalette();
                        }
                        if (cd.getName() == null) {
                            return cd.getId();
                        }
                        return cd.getName();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        return ((ToolPaletteDescriptor.ToolDescriptor)element).getName();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolPart) {
                        ToolPaletteDescriptor.ToolPart tp = (ToolPaletteDescriptor.ToolPart)element;
                        String props = "";
                        for (Map.Entry entry : tp.getProperties().entrySet()) {
                            props = props.isEmpty() ? String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() : String.valueOf(props) + "," + (String)entry.getKey() + "=" + (String)entry.getValue();
                        }
                        return String.valueOf(tp.getName()) + "[" + props + "]";
                    }
                    return "";
                }
            });
        }
        this.paletteTreeViewer.setInput((Object)toolPaletteDescriptor);
    }

    protected void performDefaults() {
        super.performDefaults();
        String path = Bpmn2Preferences.getToolProfilePath((TargetRuntime)this.currentRuntime);
        this.preferences.setToDefault(path);
        path = Bpmn2Preferences.getModelEnablementsPath((TargetRuntime)this.currentRuntime, (String)this.currentProfileName);
        this.preferences.setToDefault(path);
        this.fillProfilesCombo();
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentProfileName);
        helper.setModelEnablements(null);
        this.fillModelEnablementTrees();
        this.fillPaletteTree();
    }

    private void loadModelEnablements() {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentProfileName);
        this.loadModelEnablements(helper, this.bpmnEntries, null, null);
        ModelEnablementDescriptor med = this.currentRuntime.getModelEnablements(this.currentProfileName);
        if (med != null) {
            this.loadModelEnablements(helper, this.extensionEntries, this.bpmnEntries, med);
        }
    }

    private Object[] loadModelEnablements(ToolProfilesPreferencesHelper helper, List<ModelEnablementTreeEntry> entries, List<ModelEnablementTreeEntry> bpmnEntries, ModelEnablementDescriptor med) {
        entries.clear();
        if (med != null) {
            entries.addAll(helper.getAllExtensionElements(this.currentRuntime, med, bpmnEntries));
        } else {
            entries.addAll(helper.getAllElements());
        }
        ArrayList<ModelEnablementTreeEntry> enabled = new ArrayList<ModelEnablementTreeEntry>();
        for (ModelEnablementTreeEntry entry : entries) {
            ArrayList<ModelEnablementTreeEntry> children = entry.getChildren();
            if (!entry.getEnabled().booleanValue() || children.isEmpty()) continue;
            enabled.add(entry);
            for (ModelEnablementTreeEntry t : children) {
                if (!t.getEnabled().booleanValue()) continue;
                enabled.add(t);
            }
        }
        return enabled.toArray();
    }

    private void loadPalette() {
        if (defaultToolPalette == null) {
            defaultToolPalette = new ToolPaletteDescriptor();
            List<Tuple<String, List<Class>>> drawers = Bpmn2ToolBehaviorProvider.getDefaultPaletteDrawers();
            for (Tuple<String, List<Class>> entry : drawers) {
                ToolPaletteDescriptor.CategoryDescriptor cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, (String)entry.getFirst(), null, null);
                defaultToolPalette.getCategories().add(cd);
                for (Class c : (List)entry.getSecond()) {
                    this.loadCategory(cd, c);
                }
            }
        }
    }

    private void loadCategory(ToolPaletteDescriptor.CategoryDescriptor cd, Class c) {
        ToolPaletteDescriptor.ToolDescriptor td = new ToolPaletteDescriptor.ToolDescriptor(cd, null, ModelUtil.toCanonicalString((String)c.getSimpleName()), null, null);
        cd.getTools().add(td);
        ToolPaletteDescriptor.ToolPart tp = new ToolPaletteDescriptor.ToolPart(td, c.getSimpleName());
        td.getToolParts().add(tp);
    }

    public boolean performOk() {
        this.setErrorMessage(null);
        try {
            for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                String[] stringArray = this.preferences.getAllToolProfiles(rt);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String profileName = stringArray[n2];
                    if (this.hasHelper(rt, profileName)) {
                        ToolProfilesPreferencesHelper helper = this.getHelper(rt, profileName);
                        this.preferences.setModelEnablements(rt, profileName, helper.getModelEnablements());
                    }
                    ++n2;
                }
            }
            this.preferences.setShowIdAttribute(this.btnShowIds.getSelection());
            if (this.btnUseAsDefaultProfile.getSelection()) {
                this.preferences.setDefaultToolProfile(this.currentRuntime, this.currentProfileName);
            }
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.showErrorWithLogging((Exception)((Object)e));
        }
        return true;
    }

    public boolean getShowIdAttribute() {
        if (this.btnShowIds != null) {
            return this.btnShowIds.getSelection();
        }
        return this.preferences.getShowIdAttribute();
    }

    public void setVisible(boolean visible) {
        Bpmn2EditorBehaviorPreferencePage page;
        super.setVisible(visible);
        if (visible && this.btnShowIds != null && (page = (Bpmn2EditorBehaviorPreferencePage)Bpmn2HomePreferencePage.getPage(this.getContainer(), Bpmn2EditorBehaviorPreferencePage.PAGE_ID)) != null) {
            this.btnShowIds.setSelection(page.getShowIdAttribute());
        }
    }

    private class CreateProfileDialog
    extends InputDialog {
        private ModelEnablementDescriptor copySelection;
        private String description;

        public CreateProfileDialog(Shell parentShell) {
            super(parentShell, Messages.ToolProfilesPreferencePage_CreateProfile_Title, NLS.bind((String)Messages.ToolProfilesPreferencePage_CreateProfile_Message, (Object)ToolProfilesPreferencePage.this.currentRuntime.getName()), "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.ToolProfilesPreferencePage_Profile_Empty;
                    }
                    String[] stringArray = ToolProfilesPreferencePage.this.cboProfiles.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        if (newText.equals(p)) {
                            return NLS.bind((String)Messages.ToolProfilesPreferencePage_Profile_Duplicate, (Object)p);
                        }
                        ++n2;
                    }
                    return null;
                }
            });
            this.copySelection = null;
        }

        public ModelEnablementDescriptor getCopyProfile() {
            return this.copySelection;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(composite, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Label lblDescription = new Label(container, 0);
            lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            lblDescription.setText(Messages.ToolProfilesPreferencePage_Enter_Description_Label);
            final Text txtDescription = new Text(container, 2048);
            txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            txtDescription.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateProfileDialog.this.description = txtDescription.getText();
                }
            });
            Label lblfiller = new Label(container, 0);
            lblfiller.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            final Button btnCopy = new Button(container, 32);
            btnCopy.setText(Messages.ToolProfilesPreferencePage_CopyProfile_Button);
            btnCopy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            final Combo cboCopy = new Combo(container, 8);
            cboCopy.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            cboCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text = cboCopy.getText();
                    CreateProfileDialog.this.copySelection = (ModelEnablementDescriptor)cboCopy.getData(text);
                }
            });
            int i = 1;
            String[] stringArray = ToolProfilesPreferencePage.this.preferences.getAllToolProfiles(ToolProfilesPreferencePage.this.currentRuntime);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String profileName = stringArray[n2];
                ModelEnablementDescriptor med = ToolProfilesPreferencePage.this.currentRuntime.getModelEnablements(profileName);
                String text = med.getProfileName();
                if (text == null || text.isEmpty()) {
                    text = String.valueOf(Messages.ToolProfilePreferencePage_Unnamed) + i++;
                }
                cboCopy.add(text);
                cboCopy.setData(text, (Object)med);
                ++n2;
            }
            cboCopy.setEnabled(false);
            btnCopy.setEnabled(cboCopy.getItemCount() > 0);
            btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cboCopy.setEnabled(btnCopy.getSelection());
                    if (!btnCopy.getSelection()) {
                        CreateProfileDialog.this.copySelection = null;
                    }
                }
            });
            return composite;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class ToolProfilesHelperMap
    extends Hashtable<String, ToolProfilesPreferencesHelper> {
        private ToolProfilesHelperMap() {
        }

        public ToolProfilesPreferencesHelper get(TargetRuntime rt, String profileName) {
            return (ToolProfilesPreferencesHelper)this.get(String.valueOf(rt.getId()) + "\n" + profileName);
        }

        public ToolProfilesPreferencesHelper put(TargetRuntime rt, String profileName, ToolProfilesPreferencesHelper helper) {
            return this.put(String.valueOf(rt.getId()) + "\n" + profileName, helper);
        }
    }
}

