/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cft.server.core.AbstractAppStateTracker;
import org.eclipse.cft.server.core.internal.CloudFoundryCallback;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudFoundryServerTarget;
import org.eclipse.cft.server.core.internal.CloudFoundryTargetManager;
import org.eclipse.cft.server.core.internal.DeployedResourceCache;
import org.eclipse.cft.server.core.internal.ModuleCache;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryClientFactory;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.diego.DiegoTarget;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class CloudFoundryPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cft.server.core";
    public static final String ENABLE_INCREMENTAL_PUBLISH_PREFERENCE = "org.eclipse.cft.server.core.publish.incremental.properties";
    public static final boolean DEFAULT_INCREMENTAL_PUBLISH_PREFERENCE_VAL = true;
    private static CloudFoundryCallback callback;
    private static CloudFoundryTargetManager targetManager;
    private static List<AppStateTrackerEntry> appStateTrackerEntries;
    private static ModuleCache moduleCache;
    private static CloudFoundryPlugin plugin;
    private static IProxyService proxyService;
    private DeployedResourceCache sha1Cache = new DeployedResourceCache();
    private InstanceScope INSTANCE_SCOPE = new InstanceScope();
    private ServiceTracker tracker;
    private static CloudFoundryClientFactory factory;

    public static AbstractAppStateTracker getAppStateTracker(String serverTypeId, CloudFoundryApplicationModule application) {
        if (serverTypeId == null || application == null || application.getLocalModule() == null) {
            return null;
        }
        if (appStateTrackerEntries == null) {
            ExtensionPointReader.readAppStateTrackerExtension();
        }
        String moduleTypeId = application.getLocalModule().getModuleType().getId();
        for (AppStateTrackerEntry curTrackerEntry : appStateTrackerEntries) {
            String[] curModuleTypeIds;
            String[] curServerTypeIds = curTrackerEntry.getServerTypeIds();
            if (!CloudFoundryPlugin.supportsType(serverTypeId, curServerTypeIds) || !CloudFoundryPlugin.supportsType(moduleTypeId, curModuleTypeIds = curTrackerEntry.getModuleTypeIds())) continue;
            return curTrackerEntry.createAppStateTracker();
        }
        return null;
    }

    public static synchronized CloudFoundryCallback getCallback() {
        if (callback == null && (callback = ExtensionPointReader.readExtension()) == null) {
            callback = new NullCallback();
        }
        return callback;
    }

    public static synchronized CloudFoundryTargetManager getTargetManager() {
        if (targetManager == null) {
            targetManager = new CloudFoundryTargetManager();
            targetManager.addTarget(new DiegoTarget());
            targetManager.addTarget(CloudFoundryServerTarget.DEFAULT);
        }
        return targetManager;
    }

    public synchronized void setIncrementalPublish(boolean incrementalPublish) {
        IEclipsePreferences prefs = this.getPreferences();
        prefs.putBoolean(ENABLE_INCREMENTAL_PUBLISH_PREFERENCE, incrementalPublish);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public synchronized boolean getIncrementalPublish() {
        return this.getPreferences().getBoolean(ENABLE_INCREMENTAL_PUBLISH_PREFERENCE, true);
    }

    public IEclipsePreferences getPreferences() {
        return this.INSTANCE_SCOPE.getNode(PLUGIN_ID);
    }

    public synchronized DeployedResourceCache getDeployedResourcesCache() {
        return this.sha1Cache;
    }

    public static synchronized void setCallback(CloudFoundryCallback callback) {
        CloudFoundryPlugin.callback = callback;
    }

    public static CloudFoundryPlugin getDefault() {
        return plugin;
    }

    public static synchronized ModuleCache getModuleCache() {
        if (moduleCache == null) {
            moduleCache = new ModuleCache();
        }
        return moduleCache;
    }

    public static synchronized CloudFoundryClientFactory getCloudFoundryClientFactory() {
        if (factory == null) {
            factory = new CloudFoundryClientFactory();
        }
        return factory;
    }

    public static synchronized void setCloudFoundryClientFactory(CloudFoundryClientFactory factory) {
        CloudFoundryPlugin.factory = factory;
    }

    public synchronized IProxyService getProxyService() {
        if (proxyService == null) {
            if (this.tracker == null) {
                this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
                this.tracker.open();
            }
            proxyService = (IProxyService)this.tracker.getService();
        }
        return proxyService;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        if (moduleCache != null) {
            moduleCache.dispose();
            moduleCache = null;
        }
        plugin = null;
        super.stop(context);
    }

    private static boolean supportsType(String typeId, String[] supportedTypeIds) {
        if (typeId == null || typeId.length() == 0) {
            return false;
        }
        if (supportedTypeIds == null) {
            return false;
        }
        int size = supportedTypeIds.length;
        int i = 0;
        while (i < size) {
            if (supportedTypeIds[i].endsWith("*") ? typeId.length() >= supportedTypeIds[i].length() && typeId.startsWith(supportedTypeIds[i].substring(0, supportedTypeIds[i].length() - 1)) : typeId.equals(supportedTypeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void trace(String string) {
    }

    public static void log(CoreException ce) {
        CloudFoundryPlugin.log(ce.getStatus());
    }

    public static void logError(Throwable e) {
        CloudFoundryPlugin.log(CloudFoundryPlugin.getErrorStatus(e));
    }

    public static void logError(String message) {
        CloudFoundryPlugin.log(CloudFoundryPlugin.getErrorStatus(message));
    }

    public static void logError(String message, Throwable t) {
        CloudFoundryPlugin.log(CloudFoundryPlugin.getErrorStatus(message, t));
    }

    public static IStatus getErrorStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static IStatus getErrorStatus(String message) {
        return new Status(4, PLUGIN_ID, message);
    }

    public static IStatus getStatus(String message, int type) {
        return new Status(type, PLUGIN_ID, message);
    }

    public static IStatus getErrorStatus(Throwable t) {
        return new Status(4, PLUGIN_ID, t.getMessage(), t);
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void logWarning(String message) {
        if (plugin != null && message != null) {
            plugin.getLog().log(CloudFoundryPlugin.getStatus(message, 2));
        }
    }

    private static class AppStateTrackerEntry {
        private String[] serverTypeIds;
        private String[] moduleTypeIds;
        private IConfigurationElement configElement;

        private AppStateTrackerEntry(String[] curServerTypeIds, String[] curModuleTypeIds, IConfigurationElement curConfigElement) {
            this.serverTypeIds = curServerTypeIds;
            this.moduleTypeIds = curModuleTypeIds;
            this.configElement = curConfigElement;
        }

        private String[] getModuleTypeIds() {
            return this.moduleTypeIds;
        }

        private String[] getServerTypeIds() {
            return this.serverTypeIds;
        }

        private IConfigurationElement getConfigElement() {
            return this.configElement;
        }

        private AbstractAppStateTracker createAppStateTracker() {
            AbstractAppStateTracker tracker = null;
            try {
                tracker = (AbstractAppStateTracker)this.configElement.createExecutableExtension("class");
            }
            catch (Throwable t) {
                CloudFoundryPlugin.logError("Internal Error: Failed to load application start tracker due to - " + t.getMessage(), t);
            }
            return tracker;
        }
    }

    private static class ExtensionPointReader {
        private static final String ELEMENT_CALLBACK = "callback";
        private static final String ELEMENT_CLASS = "class";
        private static final String EXTENSION_ID_CALLBACK = "org.eclipse.cft.server.core.callback";
        private static final String EXTENSION_ID_APP_STATE_TRACKER = "appStateTracker";

        private ExtensionPointReader() {
        }

        public static CloudFoundryCallback readExtension() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CALLBACK);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().compareTo(ELEMENT_CALLBACK) == 0) {
                        return ExtensionPointReader.readCallbackExtension(element);
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        private static CloudFoundryCallback readCallbackExtension(IConfigurationElement configurationElement) {
            Object object;
            block3: {
                try {
                    object = configurationElement.createExecutableExtension(ELEMENT_CLASS);
                    if (object instanceof CloudFoundryCallback) break block3;
                    CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, CloudFoundryPlugin.PLUGIN_ID, "Could not load " + object.getClass().getCanonicalName() + " must implement " + CloudFoundryCallback.class.getCanonicalName()));
                    return null;
                }
                catch (CoreException e) {
                    CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, CloudFoundryPlugin.PLUGIN_ID, "Could not load callback extension", (Throwable)e));
                    return null;
                }
            }
            return (CloudFoundryCallback)object;
        }

        private static synchronized void readAppStateTrackerExtension() {
            IConfigurationElement[] cf;
            if (appStateTrackerEntries != null) {
                return;
            }
            appStateTrackerEntries = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(CloudFoundryPlugin.PLUGIN_ID, EXTENSION_ID_APP_STATE_TRACKER);
            int n = cf.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement curConfigElement = iConfigurationElementArray[n2];
                String[] curServerTypeIds = ExtensionPointReader.tokenize(curConfigElement.getAttribute("serverTypeIds"), ",");
                String[] curModuleTypeIds = ExtensionPointReader.tokenize(curConfigElement.getAttribute("moduleTypeIds"), ",");
                appStateTrackerEntries.add(new AppStateTrackerEntry(curServerTypeIds, curModuleTypeIds, curConfigElement));
                ++n2;
            }
        }

        private static String[] tokenize(String str, String delim) {
            String[] s;
            if (str == null) {
                return new String[0];
            }
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s == null || s.length() <= 0) continue;
                list.add(s.trim());
            }
            s = new String[list.size()];
            list.toArray(s);
            return s;
        }
    }

    private static class NullCallback
    extends CloudFoundryCallback {
        private NullCallback() {
        }

        @Override
        public void applicationStarted(CloudFoundryServer server, CloudFoundryApplicationModule cloudModule) {
        }

        @Override
        public void disconnecting(CloudFoundryServer server) {
        }

        @Override
        public void stopApplicationConsole(CloudFoundryApplicationModule cloudModule, CloudFoundryServer cloudServer) {
        }

        @Override
        public void getCredentials(CloudFoundryServer server) {
            throw new OperationCanceledException();
        }

        @Override
        public DeploymentConfiguration prepareForDeployment(CloudFoundryServer server, CloudFoundryApplicationModule module, IProgressMonitor monitor) throws CoreException {
            throw new OperationCanceledException();
        }

        @Override
        public void deleteServices(List<String> services, CloudFoundryServer server) {
        }

        @Override
        public void deleteApplication(CloudFoundryApplicationModule cloudModule, CloudFoundryServer cloudServer) {
        }

        @Override
        public void applicationStarting(CloudFoundryServer server, CloudFoundryApplicationModule cloudModule) {
        }
    }
}

