-----------------------------------------------------------------------
--           This file was automatically generated by the            --
--                                                                   --
--                Ada infrastructural code generator                 -- 
--                  for the CHESS component model                    --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- All rights reserved. This program and the accompanying materials  --
-- are made available under the terms of the Eclipse Public License  --
-- v1.0 which accompanies this distribution, and is available at     --
-- http://www.eclipse.org/legal/epl-v10.html                         --
-----------------------------------------------------------------------

with Sporadic_Task;

-- With of data types and Default Values. 
-- Remove it if it is already included in the spec.
with Datatype; use Datatype;
--with Ada.Text_IO;

package body CT_SwSystem_Consumer_insts is 


   procedure Initialize_Container is
   begin
      --Ada.Text_IO.Put_Line("-- Container CT_SwSystem_Consumer_insts.Initialize_Container -- ");
      null;
   end Initialize_Container;

   -- Getter subprograms for Provided Interfaces

   function Get_Consumer_IF return Consumer_IF.Consumer_IF_ptr is
   begin
      return CT_SwSystem_Consumer_inst_T_inst_0'access;
   end Get_Consumer_IF;


   -- Setter subprograms for Required Interfaces

   procedure Set_Store_IF_RI (ptr : in Store_IF.Store_IF_ptr) is
      use type Store_IF.Store_IF_ptr;
   begin
      if ptr /= null then
         SwSystem_Consumer_inst.Set_Store_IF_RI(ptr);
      end if;
   end Set_Store_IF_RI;






   -- Redefinition of My_OPCS. 
   -- Call Consume and set In_Use to false.
   procedure My_OPCS(Self : in out Consume_Param_T) is
   begin
      Self.OPCS_Instance.Consume(Self.f);
       Self.In_Use := False;
   end My_OPCS;

   protected body Consume_OBCS is

      procedure Update_Barrier is
      begin
         Pending := (Consume_OBCS_Queue.Request_Pending) > 0;
      end Update_Barrier;

      -- Get_Request stores the time of the release of the task,
      -- gets the next request (according to the OBCS queueing policy),
      -- and updates the guard.
      entry Get_Request (Req : out Data_Structure.Request_Descriptor_T;
                         Release : out Time)
        when Pending is
      begin
        -- Ada.Text_IO.Put_Line("OBCS: Executing entry Get_Request");
         Release := Clock;
         Data_Structure.Get(Consume_OBCS_Queue, Req);
         Update_Barrier;
      end Get_Request;

      -- When a client calls Consume, the request is reified and put in the OBCS queue.
      procedure Consume (f : in Float) is
      begin
         --Ada.Text_IO.Put_Line("OBCS: Consume");
         if Consume_Params.Buffer(Consume_Params.Index).In_Use then
            Data_Structure.Increase_Index(Consume_Params);
         end if;

         Consume_Param_T_Ref(Consume_Params.Buffer(Consume_Params.Index)).f := f;
         Data_Structure.Put(Consume_OBCS_Queue, Consume_Params.Buffer(Consume_Params.Index));
         Data_Structure.Increase_Index(Consume_Params);
         Update_Barrier;
      end Consume;
   end Consume_OBCS;

   Consume_Par_Arr : Consume_Param_Arr(1..Param_Queue_Size):=
     (others =>  (In_Use => false,
                  OPCS_Instance => SwSystem_Consumer_inst'access,
                  f => Float_Default_Value));

   Consume_Ref_Par_Arr : aliased Data_Structure.Param_Arr :=
     (Consume_Par_Arr(1)'access,
      Consume_Par_Arr(2)'access,
      Consume_Par_Arr(3)'access);


   -- Instance of OBCS
   Consume_OBCS_inst : aliased Consume_OBCS(Consume_OBCS_Ceiling, Consume_Ref_Par_Arr'access);

   -- Wrapper for OBCS_inst entry
   procedure Enqueue_in_Entry_Consume(Req : out Data_Structure.Request_Descriptor_T;
                              Release : out Time) is
   begin
      Consume_OBCS_inst.Get_Request(Req, Release);
   end Enqueue_in_Entry_Consume;

   -- Sporadic Task
   My_Thread_0 : aliased Sporadic_Task.Thread_T(Data_Structure.Generate_Task_ID, 3, 125,
                                                Enqueue_In_Entry_Consume'access);

   procedure Consume (Self: in out CT_SwSystem_Consumer_inst_T;
                          f : in Float) is
      pragma Warnings (Off, Self);
   begin
      --Ada.Text_IO.Put_Line("Container CT_SwSystem_Consumer_inst : Reifiying Consume call to OBCS ");
      Consume_OBCS_inst.Consume(f);
   end Consume;


end CT_SwSystem_Consumer_insts;
