/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.interfaceSignature;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DIRECTION implements Enumerator
{
    IN(0, "IN", "in"),
    OUT(1, "OUT", "out"),
    INOUT(2, "INOUT", "inout");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    private static final DIRECTION[] VALUES_ARRAY;
    public static final List<DIRECTION> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DIRECTION[]{IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DIRECTION get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DIRECTION result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DIRECTION getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DIRECTION result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DIRECTION get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
        }
        return null;
    }

    private DIRECTION(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

