/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.expressions.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBinary;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPackage;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionUnary;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Field;
import org.eclipse.comma.expressions.expression.MapRWContext;
import org.eclipse.comma.expressions.expression.Pair;
import org.eclipse.comma.expressions.expression.QUANTIFIER;
import org.eclipse.comma.expressions.expression.TypeAnnotation;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.expressions.validation.AbstractExpressionValidator;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesFactory;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class ExpressionValidator
extends AbstractExpressionValidator {
    @Inject
    protected IScopeProvider scopeProvider;
    protected SimpleTypeDecl boolType = null;
    protected SimpleTypeDecl intType = null;
    protected SimpleTypeDecl realType = null;
    protected SimpleTypeDecl stringType = null;
    protected SimpleTypeDecl voidType = null;
    protected SimpleTypeDecl anyType = null;
    protected SimpleTypeDecl idType = null;
    protected SimpleTypeDecl bulkdataType = null;

    public ExpressionValidator() {
        this.initPredefinedTypes();
    }

    public void initPredefinedTypes() {
        this.boolType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.boolType.setName("bool");
        this.voidType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.voidType.setName("void");
        this.intType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.intType.setName("int");
        this.stringType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.stringType.setName("string");
        this.realType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.realType.setName("real");
        this.anyType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.anyType.setName("any");
        this.idType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.idType.setName("id");
        this.bulkdataType = TypesFactory.eINSTANCE.createSimpleTypeDecl();
        this.bulkdataType.setName("bulkdata");
    }

    public boolean identical(TypeObject t1, TypeObject t2) {
        boolean _xblockexpression = false;
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1 instanceof SimpleTypeDecl && t2 instanceof SimpleTypeDecl) {
            return ((SimpleTypeDecl)t1).getName().equals(((SimpleTypeDecl)t2).getName());
        }
        if (t1 instanceof VectorTypeConstructor && t2 instanceof VectorTypeConstructor) {
            int _size_1;
            boolean _notEquals;
            boolean _not;
            boolean _identical = this.identical((TypeObject)((VectorTypeConstructor)t1).getType(), (TypeObject)((VectorTypeConstructor)t2).getType());
            boolean bl = _not = !_identical;
            if (_not) {
                return false;
            }
            int _size = ((VectorTypeConstructor)t1).getDimensions().size();
            boolean bl2 = _notEquals = _size != (_size_1 = ((VectorTypeConstructor)t2).getDimensions().size());
            if (_notEquals) {
                return false;
            }
            int _size_2 = ((VectorTypeConstructor)t1).getDimensions().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
            for (Integer i : _doubleDotLessThan) {
                int _size_4;
                boolean _notEquals_1;
                int _size_3 = ((Dimension)((VectorTypeConstructor)t1).getDimensions().get(i.intValue())).getSize();
                boolean bl3 = _notEquals_1 = _size_3 != (_size_4 = ((Dimension)((VectorTypeConstructor)t2).getDimensions().get(i.intValue())).getSize());
                if (!_notEquals_1) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof MapTypeConstructor && t2 instanceof MapTypeConstructor) {
            return this.identical(TypeUtilities.getKeyType((TypeObject)t1), TypeUtilities.getKeyType((TypeObject)t2)) && this.identical(TypeUtilities.getTypeObject((Type)((MapTypeConstructor)t1).getValueType()), TypeUtilities.getTypeObject((Type)((MapTypeConstructor)t2).getValueType()));
        }
        _xblockexpression = t1 == t2;
        return _xblockexpression;
    }

    public boolean subTypeOf(TypeObject t1, TypeObject t2) {
        boolean _xblockexpression = false;
        if (t1 == null || t2 == null) {
            return false;
        }
        boolean _synonym = this.synonym(t1, t2);
        if (_synonym) {
            return true;
        }
        boolean _identical = this.identical(t1, (TypeObject)this.anyType);
        if (_identical) {
            return true;
        }
        if (t1 instanceof RecordTypeDecl && t2 instanceof RecordTypeDecl) {
            return TypeUtilities.getAllParents((RecordTypeDecl)((RecordTypeDecl)t1)).contains(t2);
        }
        if (t1 instanceof VectorTypeConstructor && t2 instanceof VectorTypeConstructor) {
            int _size_1;
            boolean _notEquals;
            boolean _not;
            boolean _subTypeOf = this.subTypeOf((TypeObject)((VectorTypeConstructor)t1).getType(), (TypeObject)((VectorTypeConstructor)t2).getType());
            boolean bl = _not = !_subTypeOf;
            if (_not) {
                return false;
            }
            int _size = ((VectorTypeConstructor)t1).getDimensions().size();
            boolean bl2 = _notEquals = _size != (_size_1 = ((VectorTypeConstructor)t2).getDimensions().size());
            if (_notEquals) {
                return false;
            }
            int _size_2 = ((VectorTypeConstructor)t1).getDimensions().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
            for (Integer i : _doubleDotLessThan) {
                int _size_4;
                boolean _notEquals_1;
                int _size_3 = ((Dimension)((VectorTypeConstructor)t1).getDimensions().get(i.intValue())).getSize();
                boolean bl3 = _notEquals_1 = _size_3 != (_size_4 = ((Dimension)((VectorTypeConstructor)t2).getDimensions().get(i.intValue())).getSize());
                if (!_notEquals_1) continue;
                return false;
            }
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean synonym(TypeObject t1, TypeObject t2) {
        boolean _xblockexpression = false;
        if (t1 == null || t2 == null) {
            return false;
        }
        boolean _identical = this.identical(t1, t2);
        if (_identical) {
            return true;
        }
        if (t1 instanceof SimpleTypeDecl && t2 instanceof SimpleTypeDecl) {
            return this.identical((TypeObject)((SimpleTypeDecl)t1).getBase(), t2) || this.identical((TypeObject)((SimpleTypeDecl)t2).getBase(), t1) || this.identical((TypeObject)((SimpleTypeDecl)t1).getBase(), (TypeObject)((SimpleTypeDecl)t2).getBase());
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public TypeObject typeOf(Expression e) {
        TypeAnnotation _typeAnnotation;
        TypeObject _typeObject;
        Type _type;
        TypeObject t;
        TypeObject _xblockexpression_1;
        SimpleTypeDecl _xblockexpression = null;
        if (e == null) {
            return null;
        }
        SimpleTypeDecl _switchResult = null;
        boolean _matched = false;
        if (e instanceof ExpressionConstantBool || e instanceof ExpressionAnd || e instanceof ExpressionOr || e instanceof ExpressionNot || e instanceof ExpressionEqual || e instanceof ExpressionNEqual || e instanceof ExpressionLess || e instanceof ExpressionGreater || e instanceof ExpressionLeq || e instanceof ExpressionGeq) {
            _matched = true;
            _switchResult = this.boolType;
        }
        if (!_matched && (e instanceof ExpressionConstantInt || e instanceof ExpressionModulo)) {
            _matched = true;
            _switchResult = this.intType;
        }
        if (!_matched && e instanceof ExpressionConstantReal) {
            _matched = true;
            _switchResult = this.realType;
        }
        if (!_matched && (e instanceof ExpressionAddition || e instanceof ExpressionSubtraction || e instanceof ExpressionDivision || e instanceof ExpressionMultiply || e instanceof ExpressionPower || e instanceof ExpressionMinimum || e instanceof ExpressionMaximum)) {
            _matched = true;
            _switchResult = this.inferTypeBinaryArithmetic((ExpressionBinary)e);
        }
        if (!_matched && (e instanceof ExpressionMinus || e instanceof ExpressionPlus)) {
            _matched = true;
            _xblockexpression_1 = null;
            t = this.typeOf(((ExpressionUnary)e).getSub());
            Object _xifexpression = null;
            _xifexpression = this.subTypeOf(t, (TypeObject)this.intType) || this.subTypeOf(t, (TypeObject)this.realType) ? t : null;
            _xblockexpression_1 = _xifexpression;
            _switchResult = _xblockexpression_1;
        }
        if (!_matched && e instanceof ExpressionVariable) {
            _matched = true;
            Variable _variable = ((ExpressionVariable)e).getVariable();
            _type = null;
            if (_variable != null) {
                _type = _variable.getType();
            }
            _switchResult = TypeUtilities.getTypeObject(_type);
        }
        if (!_matched && e instanceof ExpressionConstantString) {
            _matched = true;
            _switchResult = this.stringType;
        }
        if (!_matched && e instanceof ExpressionBracket) {
            _matched = true;
            Expression _sub = ((ExpressionBracket)e).getSub();
            TypeObject _typeOf = null;
            if (_sub != null) {
                _typeOf = this.typeOf(_sub);
            }
            _switchResult = _typeOf;
        }
        if (!_matched && e instanceof ExpressionEnumLiteral) {
            _matched = true;
            _switchResult = ((ExpressionEnumLiteral)e).getType();
        }
        if (!_matched && e instanceof ExpressionRecord) {
            _matched = true;
            _switchResult = ((ExpressionRecord)e).getType();
        }
        if (!_matched && e instanceof ExpressionRecordAccess) {
            _matched = true;
            RecordField _field = ((ExpressionRecordAccess)e).getField();
            _type = null;
            if (_field != null) {
                _type = _field.getType();
            }
            _typeObject = null;
            if (_type != null) {
                _typeObject = TypeUtilities.getTypeObject((Type)_type);
            }
            _switchResult = _typeObject;
        }
        if (!_matched && e instanceof ExpressionBulkData) {
            _matched = true;
            _switchResult = this.bulkdataType;
        }
        if (!_matched && e instanceof ExpressionAny) {
            _matched = true;
            _switchResult = this.anyType;
        }
        if (!_matched && e instanceof ExpressionFunctionCall) {
            _matched = true;
            _switchResult = this.inferTypeFunCall((ExpressionFunctionCall)e);
        }
        if (!_matched && e instanceof ExpressionVector) {
            _matched = true;
            _typeAnnotation = ((ExpressionVector)e).getTypeAnnotation();
            _type = null;
            if (_typeAnnotation != null) {
                _type = _typeAnnotation.getType();
            }
            _typeObject = null;
            if (_type != null) {
                _typeObject = TypeUtilities.getTypeObject((Type)_type);
            }
            _switchResult = _typeObject;
        }
        if (!_matched && e instanceof ExpressionQuantifier) {
            _matched = true;
            Object _xifexpression = null;
            QUANTIFIER _quantifier = ((ExpressionQuantifier)e).getQuantifier();
            boolean _equals = Objects.equal((Object)((Object)_quantifier), (Object)((Object)QUANTIFIER.DELETE));
            _xifexpression = _equals ? this.typeOf(((ExpressionQuantifier)e).getCollection()) : this.boolType;
            _switchResult = _xifexpression;
        }
        if (!_matched && e instanceof ExpressionMap) {
            _matched = true;
            _typeAnnotation = ((ExpressionMap)e).getTypeAnnotation();
            _type = null;
            if (_typeAnnotation != null) {
                _type = _typeAnnotation.getType();
            }
            TypeObject _typeObject2 = null;
            if (_type != null) {
                _typeObject2 = TypeUtilities.getTypeObject((Type)_type);
            }
            _switchResult = _typeObject2;
        }
        if (!_matched && e instanceof ExpressionMapRW) {
            _matched = true;
            _xblockexpression_1 = null;
            t = this.typeOf(((ExpressionMapRW)e).getMap());
            TypeObject _xifexpression = null;
            if (t != null && TypeUtilities.isMapType((TypeObject)t)) {
                boolean _tripleNotEquals;
                TypeObject _xifexpression_1 = null;
                Expression _value = ((ExpressionMapRW)e).getValue();
                boolean bl = _tripleNotEquals = _value != null;
                if (_tripleNotEquals) {
                    _xifexpression_1 = t;
                } else {
                    boolean _tripleEquals;
                    TypeObject _xifexpression_2 = null;
                    MapRWContext _context = ((ExpressionMapRW)e).getContext();
                    boolean bl2 = _tripleEquals = _context == null;
                    if (!_tripleEquals) {
                        VectorTypeConstructor result = TypesFactory.eINSTANCE.createVectorTypeConstructor();
                        result.getDimensions().add((Object)TypesFactory.eINSTANCE.createDimension());
                        TypeObject _valueType = TypeUtilities.getValueType((TypeObject)t);
                        result.setType((TypeDecl)_valueType);
                        return result;
                    }
                    _xifexpression_2 = TypeUtilities.getValueType((TypeObject)t);
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = null;
            }
            _xblockexpression_1 = _xifexpression;
            _switchResult = _xblockexpression_1;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public TypeObject inferTypeBinaryArithmetic(ExpressionBinary e) {
        Object _xblockexpression = null;
        TypeObject leftType = this.typeOf(e.getLeft());
        TypeObject rightType = this.typeOf(e.getRight());
        Object _switchResult = null;
        boolean _matched = false;
        if (e instanceof ExpressionAddition) {
            _matched = true;
            if (this.subTypeOf(leftType, (TypeObject)this.intType) && this.subTypeOf(rightType, (TypeObject)this.intType)) {
                return this.intType;
            }
            if (this.subTypeOf(leftType, (TypeObject)this.realType) && this.subTypeOf(rightType, (TypeObject)this.realType)) {
                return this.realType;
            }
            if (this.subTypeOf(leftType, (TypeObject)this.stringType) && this.subTypeOf(rightType, (TypeObject)this.stringType)) {
                return this.stringType;
            }
            return null;
        }
        if (!_matched && (e instanceof ExpressionSubtraction || e instanceof ExpressionDivision || e instanceof ExpressionPower || e instanceof ExpressionMultiply || e instanceof ExpressionMinimum || e instanceof ExpressionMaximum)) {
            _matched = true;
            if (this.subTypeOf(leftType, (TypeObject)this.intType) && this.subTypeOf(rightType, (TypeObject)this.intType)) {
                return this.intType;
            }
            if (this.subTypeOf(leftType, (TypeObject)this.realType) && this.subTypeOf(rightType, (TypeObject)this.realType)) {
                return this.realType;
            }
            return null;
        }
        if (!_matched) {
            _switchResult = null;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public TypeObject inferTypeFunCall(ExpressionFunctionCall e) {
        SimpleTypeDecl _switchResult = null;
        String _functionName = e.getFunctionName();
        boolean _matched = false;
        if (Objects.equal((Object)_functionName, (Object)"isEmpty")) {
            _matched = true;
            _switchResult = this.boolType;
        }
        if (!_matched && Objects.equal((Object)_functionName, (Object)"contains")) {
            _matched = true;
            _switchResult = this.boolType;
        }
        if (!_matched && Objects.equal((Object)_functionName, (Object)"hasKey")) {
            _matched = true;
            _switchResult = this.boolType;
        }
        if (!_matched && Objects.equal((Object)_functionName, (Object)"matches")) {
            _matched = true;
            _switchResult = this.boolType;
        }
        if (!_matched && Objects.equal((Object)_functionName, (Object)"asReal")) {
            _matched = true;
            _switchResult = this.realType;
        }
        if (!_matched) {
            if (Objects.equal((Object)_functionName, (Object)"length")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_functionName, (Object)"size")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = this.intType;
            }
        }
        if (!_matched) {
            if (Objects.equal((Object)_functionName, (Object)"abs")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_functionName, (Object)"add")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_functionName, (Object)"deleteKey")) {
                _matched = true;
            }
            if (_matched) {
                boolean _not;
                TypeObject _xifexpression = null;
                boolean _isEmpty = e.getArgs().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    TypeObject _xblockexpression = null;
                    TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
                    TypeObject _xifexpression_1 = null;
                    boolean _equals = e.getFunctionName().equals("abs");
                    if (_equals) {
                        Object _xifexpression_2 = null;
                        _xifexpression_2 = this.subTypeOf(t, (TypeObject)this.intType) || this.subTypeOf(t, (TypeObject)this.realType) ? t : null;
                        _xifexpression_1 = _xifexpression_2;
                    } else {
                        _xifexpression_1 = this.typeOf((Expression)e.getArgs().get(0));
                    }
                    _xifexpression = _xblockexpression = _xifexpression_1;
                } else {
                    _xifexpression = null;
                }
                _switchResult = _xifexpression;
            }
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    @Check
    public void checkTypingExpression(Expression e) {
        boolean _tripleEquals;
        boolean _not;
        boolean _synonym;
        TypeObject t;
        TypeObject rightType;
        TypeObject leftType;
        boolean _matched = false;
        if (e instanceof ExpressionAnd || e instanceof ExpressionOr) {
            _matched = true;
            leftType = this.typeOf(((ExpressionBinary)e).getLeft());
            rightType = this.typeOf(((ExpressionBinary)e).getRight());
            if (leftType != null && !this.identical(leftType, (TypeObject)this.boolType)) {
                this.error("Type mismatch: expected type bool", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__LEFT);
            }
            if (rightType != null && !this.identical(rightType, (TypeObject)this.boolType)) {
                this.error("Type mismatch: expected type bool", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__RIGHT);
            }
        }
        if (!_matched && e instanceof ExpressionNot) {
            _matched = true;
            t = this.typeOf(((ExpressionNot)e).getSub());
            if (t != null && !this.identical(t, (TypeObject)this.boolType)) {
                this.error("Type mismatch: expected type bool", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_UNARY__SUB);
            }
        }
        if (!_matched && (e instanceof ExpressionLess || e instanceof ExpressionGreater || e instanceof ExpressionLeq || e instanceof ExpressionGeq)) {
            _matched = true;
            leftType = this.typeOf(((ExpressionBinary)e).getLeft());
            rightType = this.typeOf(((ExpressionBinary)e).getRight());
            if (leftType == null || rightType == null) {
                return;
            }
            _synonym = this.synonym(leftType, rightType);
            boolean bl = _not = !_synonym;
            if (_not) {
                this.error("Arguments must be of compatible types", ((ExpressionBinary)e).eContainer(), ((ExpressionBinary)e).eContainingFeature());
                return;
            }
            if (!this.synonym(leftType, (TypeObject)this.intType) && !this.synonym(leftType, (TypeObject)this.realType)) {
                this.error("Type mismatch: expected type int or real", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__LEFT);
            }
        }
        if (!_matched && (e instanceof ExpressionAddition || e instanceof ExpressionSubtraction || e instanceof ExpressionMultiply || e instanceof ExpressionDivision || e instanceof ExpressionModulo || e instanceof ExpressionPower || e instanceof ExpressionMinimum || e instanceof ExpressionMaximum)) {
            _matched = true;
            leftType = this.typeOf(((ExpressionBinary)e).getLeft());
            rightType = this.typeOf(((ExpressionBinary)e).getRight());
            if (leftType == null || rightType == null) {
                return;
            }
            _synonym = this.synonym(leftType, rightType);
            boolean bl = _not = !_synonym;
            if (_not) {
                this.error("Arguments must be of compatible types", ((ExpressionBinary)e).eContainer(), ((ExpressionBinary)e).eContainingFeature());
                return;
            }
            if (e instanceof ExpressionModulo) {
                boolean _not_1;
                boolean _synonym_1 = this.synonym(leftType, (TypeObject)this.intType);
                boolean bl2 = _not_1 = !_synonym_1;
                if (_not_1) {
                    this.error("Type mismatch: expected type int", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__LEFT);
                }
                return;
            }
            if (e instanceof ExpressionAddition) {
                if (!(this.synonym(leftType, (TypeObject)this.intType) || this.synonym(leftType, (TypeObject)this.realType) || this.synonym(leftType, (TypeObject)this.stringType))) {
                    this.error("Type mismatch: expected type int, real or string", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__LEFT);
                }
                return;
            }
            if (!this.synonym(leftType, (TypeObject)this.intType) && !this.synonym(leftType, (TypeObject)this.realType)) {
                this.error("Type mismatch: expected type int or real", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_BINARY__LEFT);
            }
        }
        if (!_matched && (e instanceof ExpressionMinus || e instanceof ExpressionPlus)) {
            _matched = true;
            t = this.typeOf(((ExpressionUnary)e).getSub());
            if (t != null && !this.subTypeOf(t, (TypeObject)this.intType) && !this.subTypeOf(t, (TypeObject)this.realType)) {
                this.error("Type mismatch: expected type int or real", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_UNARY__SUB);
            }
        }
        if (!_matched && e instanceof ExpressionRecord) {
            int _size_1;
            boolean _notEquals;
            _matched = true;
            int _size = ((ExpressionRecord)e).getFields().size();
            boolean bl = _notEquals = _size != (_size_1 = TypeUtilities.getAllFields((RecordTypeDecl)((ExpressionRecord)e).getType()).size());
            if (_notEquals) {
                this.error("Wrong number of fields", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_RECORD__FIELDS);
                return;
            }
            EList<Field> _fields = ((ExpressionRecord)e).getFields();
            for (Field f : _fields) {
                boolean _not2;
                boolean _equals = f.getRecordField().getName().equals(((RecordField)TypeUtilities.getAllFields((RecordTypeDecl)((ExpressionRecord)e).getType()).get(((ExpressionRecord)e).getFields().indexOf((Object)f))).getName());
                boolean bl3 = _not2 = !_equals;
                if (!_not2) continue;
                this.error("Wrong field name", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_RECORD__FIELDS, ((ExpressionRecord)e).getFields().indexOf((Object)f));
            }
            EList<Field> _fields_1 = ((ExpressionRecord)e).getFields();
            for (Field f_1 : _fields_1) {
                boolean _not_1;
                boolean _subTypeOf = this.subTypeOf(this.typeOf(f_1.getExp()), TypeUtilities.getTypeObject((Type)((RecordField)TypeUtilities.getAllFields((RecordTypeDecl)((ExpressionRecord)e).getType()).get(((ExpressionRecord)e).getFields().indexOf((Object)f_1))).getType()));
                boolean bl4 = _not_1 = !_subTypeOf;
                if (!_not_1) continue;
                this.error("Type mismatch", e, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_RECORD__FIELDS, ((ExpressionRecord)e).getFields().indexOf((Object)f_1));
            }
        }
        if (!_matched && e instanceof ExpressionMapRW) {
            TypeObject collectionType;
            MapRWContext _context;
            boolean _tripleNotEquals_1;
            TypeObject valType;
            Expression _value;
            boolean _tripleNotEquals;
            boolean _not3;
            _matched = true;
            TypeObject mapType = this.typeOf(((ExpressionMapRW)e).getMap());
            if (mapType == null) {
                return;
            }
            boolean _isMapType = TypeUtilities.isMapType((TypeObject)mapType);
            boolean bl = _not3 = !_isMapType;
            if (_not3) {
                this.error("Expression is not a map", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_MAP_RW__MAP);
                return;
            }
            TypeObject keyType = this.typeOf(((ExpressionMapRW)e).getKey());
            if (keyType != null && !this.identical(keyType, TypeUtilities.getKeyType((TypeObject)mapType))) {
                this.error("Type of expression does not conform to map key type", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_MAP_RW__KEY);
            }
            boolean bl5 = _tripleNotEquals = (_value = ((ExpressionMapRW)e).getValue()) != null;
            if (_tripleNotEquals && (valType = this.typeOf(((ExpressionMapRW)e).getValue())) != null && !this.subTypeOf(valType, TypeUtilities.getValueType((TypeObject)mapType))) {
                this.error("Type of expression does not conform to map value type", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_MAP_RW__VALUE);
            }
            boolean bl6 = _tripleNotEquals_1 = (_context = ((ExpressionMapRW)e).getContext()) != null;
            if (_tripleNotEquals_1 && (collectionType = this.typeOf(((ExpressionMapRW)e).getContext().getCollection())) != null && !TypeUtilities.isVectorType((TypeObject)collectionType)) {
                this.error("Expression must be of type vector", ((ExpressionMapRW)e).getContext(), (EStructuralFeature)ExpressionPackage.Literals.MAP_RW_CONTEXT__COLLECTION);
            }
        }
        if (!_matched && e instanceof ExpressionMap) {
            boolean _not4;
            _matched = true;
            TypeAnnotation _typeAnnotation = ((ExpressionMap)e).getTypeAnnotation();
            Type _type = null;
            if (_typeAnnotation != null) {
                _type = _typeAnnotation.getType();
            }
            boolean bl = _tripleEquals = _type == null;
            if (_tripleEquals) {
                return;
            }
            Type mapType = ((ExpressionMap)e).getTypeAnnotation().getType();
            boolean _isMapType = TypeUtilities.isMapType((Type)mapType);
            boolean bl7 = _not4 = !_isMapType;
            if (_not4) {
                this.error("The type must be a map type", ((ExpressionMap)e).getTypeAnnotation(), (EStructuralFeature)ExpressionPackage.Literals.TYPE_ANNOTATION__TYPE);
                return;
            }
            TypeObject keyType = TypeUtilities.getKeyType((TypeObject)TypeUtilities.getTypeObject((Type)mapType));
            TypeObject valueType = TypeUtilities.getValueType((TypeObject)TypeUtilities.getTypeObject((Type)mapType));
            EList<Pair> _pairs = ((ExpressionMap)e).getPairs();
            for (Pair p : _pairs) {
                TypeObject pairKeyType = this.typeOf(p.getKey());
                TypeObject pairValueType = this.typeOf(p.getValue());
                if (pairKeyType != null && !this.identical(pairKeyType, keyType)) {
                    this.error("Type of expression does not conform to map key type", p, (EStructuralFeature)ExpressionPackage.Literals.PAIR__KEY);
                }
                if (pairValueType == null || this.subTypeOf(pairValueType, valueType)) continue;
                this.error("Type of expression does not conform to map value type", p, (EStructuralFeature)ExpressionPackage.Literals.PAIR__VALUE);
            }
        }
        if (!_matched && e instanceof ExpressionVector) {
            boolean _not5;
            _matched = true;
            TypeAnnotation _typeAnnotation = ((ExpressionVector)e).getTypeAnnotation();
            Type _type = null;
            if (_typeAnnotation != null) {
                _type = _typeAnnotation.getType();
            }
            boolean bl = _tripleEquals = _type == null;
            if (_tripleEquals) {
                return;
            }
            Type vectorType = ((ExpressionVector)e).getTypeAnnotation().getType();
            boolean _isVectorType = TypeUtilities.isVectorType((Type)vectorType);
            boolean bl8 = _not5 = !_isVectorType;
            if (_not5) {
                this.error("The type must be a vector type", ((ExpressionVector)e).getTypeAnnotation(), (EStructuralFeature)ExpressionPackage.Literals.TYPE_ANNOTATION__TYPE);
                return;
            }
            int s = TypeUtilities.getFirstDimension((TypeObject)TypeUtilities.getTypeObject((Type)vectorType));
            if (s > 0 && ((ExpressionVector)e).getElements().size() != s) {
                this.error("Expected size of the vector is " + Integer.valueOf(s), (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VECTOR__ELEMENTS);
                return;
            }
            TypeObject expectedType = this.getBaseTypeToCheck(TypeUtilities.getTypeObject((Type)vectorType));
            EList<Expression> _elements = ((ExpressionVector)e).getElements();
            for (Expression el : _elements) {
                TypeObject t2 = this.typeOf(el);
                if (t2 == null || this.subTypeOf(t2, expectedType)) continue;
                this.error("The element does not conform to the base type", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VECTOR__ELEMENTS, ((ExpressionVector)e).getElements().indexOf((Object)el));
            }
        }
        if (!_matched && e instanceof ExpressionFunctionCall) {
            _matched = true;
            String _functionName = ((ExpressionFunctionCall)e).getFunctionName();
            boolean _matched_1 = false;
            if (Objects.equal((Object)_functionName, (Object)"isEmpty")) {
                _matched_1 = true;
                this.checkFunIsEmpty((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"size")) {
                _matched_1 = true;
                this.checkFunSize((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"contains")) {
                _matched_1 = true;
                this.checkFunContains((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"add")) {
                _matched_1 = true;
                this.checkFunAdd((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"asReal")) {
                _matched_1 = true;
                this.checkFunAsReal((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"abs")) {
                _matched_1 = true;
                this.checkFunAbs((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"length")) {
                _matched_1 = true;
                this.checkFunLength((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"hasKey")) {
                _matched_1 = true;
                this.checkFunHasOrDeleteKey((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"deleteKey")) {
                _matched_1 = true;
                this.checkFunHasOrDeleteKey((ExpressionFunctionCall)e);
            }
            if (!_matched_1 && Objects.equal((Object)_functionName, (Object)"matches")) {
                _matched_1 = true;
                this.checkFunMatches((ExpressionFunctionCall)e);
            }
            if (!_matched_1) {
                this.error("Unknown function", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            }
        }
        if (!_matched && e instanceof ExpressionQuantifier) {
            TypeObject condType;
            _matched = true;
            TypeObject collectionType = this.typeOf(((ExpressionQuantifier)e).getCollection());
            if (collectionType != null && !TypeUtilities.isVectorType((TypeObject)collectionType)) {
                this.error("Expression must be of type vector", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_QUANTIFIER__COLLECTION);
            }
            if ((condType = this.typeOf(((ExpressionQuantifier)e).getCondition())) != null && !this.subTypeOf(condType, (TypeObject)this.boolType)) {
                this.error("Condition expression must be of type boolean", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_QUANTIFIER__CONDITION);
            }
        }
    }

    public void checkFunIsEmpty(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            this.error("Function isEmpty expects one argument", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t != null && !TypeUtilities.isVectorType((TypeObject)t)) {
            this.error("Function isEmpty expects argument of type vector", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
        }
    }

    public void checkFunSize(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            this.error("Function size expects one argument", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t != null && !TypeUtilities.isVectorType((TypeObject)t)) {
            this.error("Function size expects argument of type vector", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
        }
    }

    public void checkFunContains(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 2;
        if (_notEquals) {
            this.error("Function contains expects two arguments", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t != null && !TypeUtilities.isVectorType((TypeObject)t)) {
            this.error("Function contains expects first argument of type vector", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
        }
    }

    public void checkFunAdd(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 2;
        if (_notEquals) {
            this.error("Function add expects two arguments", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t == null || !TypeUtilities.isVectorType((TypeObject)t)) {
            this.error("Function add expects first argument of type vector", e, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            return;
        }
        TypeObject expectedType = this.getBaseTypeToCheck(t);
        TypeObject elType = this.typeOf((Expression)e.getArgs().get(1));
        if (elType != null && !this.subTypeOf(elType, expectedType)) {
            this.error("Second argument does not conform to the base type of the vector", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 1);
        }
    }

    public void checkFunAsReal(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            this.error("Function asReal expects one argument", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
        } else {
            TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
            if (t != null && !this.subTypeOf(t, (TypeObject)this.intType)) {
                this.error("Function asReal expects an argument of type int", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            }
        }
    }

    public void checkFunAbs(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            this.error("Function abs expects one argument", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
        } else {
            TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
            if (t != null && !this.subTypeOf(t, (TypeObject)this.realType) && !this.subTypeOf(t, (TypeObject)this.intType)) {
                this.error("Function abs expects an argument of numeric type", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS);
            }
        }
    }

    public void checkFunLength(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            this.error("Function length expects one argument", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
        } else {
            TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
            if (t != null && !this.subTypeOf(t, (TypeObject)this.bulkdataType)) {
                this.error("Function length expects an argument of type bulkdata", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            }
        }
    }

    public void checkFunHasOrDeleteKey(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 2;
        if (_notEquals) {
            this.error("This function expects two arguments", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t == null || !TypeUtilities.isMapType((TypeObject)t)) {
            this.error("This function expects first argument of type map", e, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            return;
        }
        TypeObject expectedType = TypeUtilities.getKeyType((TypeObject)t);
        TypeObject keyExprType = this.typeOf((Expression)e.getArgs().get(1));
        if (e.getFunctionName().equals("deleteKey") && TypeUtilities.isVectorType((TypeObject)keyExprType)) {
            keyExprType = TypeUtilities.getBaseType((TypeObject)keyExprType);
        }
        if (keyExprType != null && !this.identical(keyExprType, expectedType)) {
            this.error("Second argument does not conform to the key type of the map", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 1);
        }
    }

    public void checkFunMatches(ExpressionFunctionCall e) {
        boolean _notEquals;
        int _size = e.getArgs().size();
        boolean bl = _notEquals = _size != 2;
        if (_notEquals) {
            this.error("This function expects two arguments", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__FUNCTION_NAME);
            return;
        }
        TypeObject t = this.typeOf((Expression)e.getArgs().get(0));
        if (t == null || !this.subTypeOf(t, (TypeObject)this.stringType)) {
            this.error("This function expects first argument of type string", e, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            return;
        }
        t = this.typeOf((Expression)e.getArgs().get(1));
        if (t == null || !this.subTypeOf(t, (TypeObject)this.stringType)) {
            this.error("This function expects second argument of type string", e, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_FUNCTION_CALL__ARGS, 0);
            return;
        }
    }

    private TypeObject getBaseTypeToCheck(TypeObject vt) {
        boolean _equals;
        TypeDecl _xblockexpression = null;
        TypeDecl base = null;
        EList dimensions = null;
        if (vt instanceof VectorTypeDecl) {
            base = ((VectorTypeDecl)vt).getConstructor().getType();
            dimensions = ((VectorTypeDecl)vt).getConstructor().getDimensions();
        } else {
            base = ((VectorTypeConstructor)vt).getType();
            dimensions = ((VectorTypeConstructor)vt).getDimensions();
        }
        TypeDecl _xifexpression = null;
        int _size = dimensions.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            _xifexpression = base;
        } else {
            VectorTypeConstructor _xblockexpression_1 = null;
            VectorTypeConstructor result = TypesFactory.eINSTANCE.createVectorTypeConstructor();
            result.setType(base);
            int _size_1 = dimensions.size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _size_1, true);
            for (Integer i : _doubleDotLessThan) {
                Dimension newDimension = TypesFactory.eINSTANCE.createDimension();
                newDimension.setSize(((Dimension)dimensions.get(i)).getSize());
                result.getDimensions().add((Object)newDimension);
            }
            _xblockexpression_1 = result;
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

