/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class ConflictCategory
extends AbstractDifferenceCategory {
    public static final String ID = "Technical.Conflicts";

    @Override
    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = difference_p.isConflicting();
        if (!result && difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence rvp = (IReferenceValuePresence)difference_p;
            IReferenceValuePresence peer = rvp.getSymmetricalOwnership();
            result = !rvp.isAlignedWithAncestor() && peer != null && !peer.isAlignedWithAncestor();
        }
        return result;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public Image getImage(EMFDiffNode node_p) {
        return node_p.getResourceManager().getStandaloneOverlay(EMFDiffMergeUIPlugin.ImageID.CONFLICT_STAT);
    }

    @Override
    public String getText(EMFDiffNode node_p) {
        return Messages.ConflictCategory_Text;
    }

    @Override
    public boolean isApplicable(EMFDiffNode node_p) {
        return node_p.isThreeWay();
    }

    @Override
    public String getDescription(EMFDiffNode node_p) {
        return Messages.ConflictCategory_Description;
    }
}

