/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.ecp.internal.ui.util.HandlerHelperUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public final class ECPImportHandlerHelper {
    public static final String[] FILTER_EXTS = new String[]{"*.xmi"};
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*.xmi)"};
    private static final String FILE_DIALOG_HELPER_CLASS = "org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelperImpl";
    private static boolean imported;

    private ECPImportHandlerHelper() {
    }

    public static void importElement(Shell shell, EObject eObject) {
        ECPImportHandlerHelper.importElement(shell, (Object)eObject);
    }

    public static void importElement(Shell shell, ECPProject ecpProject) {
        ECPImportHandlerHelper.importElement(shell, (Object)ecpProject);
    }

    private static void importElement(Shell shell, Object object) {
        if (object == null) {
            return;
        }
        String fileName = ECPImportHandlerHelper.getFileName(shell);
        if (fileName == null) {
            return;
        }
        URI fileURI = URI.createFileURI((String)fileName);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(fileURI, true);
        ECPImportHandlerHelper.importFile(object, fileURI, resource, shell);
    }

    private static void importFile(final Object parentObject, URI fileURI, Resource resource, Shell shell) {
        block11: {
            ProgressMonitorDialog progressDialog;
            block10: {
                imported = false;
                progressDialog = new ProgressMonitorDialog(shell);
                try {
                    try {
                        progressDialog.open();
                        progressDialog.getProgressMonitor().beginTask("Import model...", 100);
                        final EObject eObjectImport = (EObject)resource.getContents().get(0);
                        if (parentObject instanceof EObject) {
                            for (EReference ref : ((EObject)parentObject).eClass().getEAllContainments()) {
                                if (!ref.getEReferenceType().isInstance((Object)eObjectImport)) continue;
                                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)parentObject);
                                if (ref.isMany()) {
                                    editingDomain.getCommandStack().execute((Command)new AddCommand(editingDomain, (EObject)parentObject, (EStructuralFeature)ref, (Object)EcoreUtil.copy((EObject)eObjectImport)));
                                } else {
                                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)parentObject, (EStructuralFeature)ref, (Object)EcoreUtil.copy((EObject)eObjectImport)));
                                }
                                imported = true;
                                break block10;
                            }
                            break block10;
                        }
                        if (parentObject instanceof ECPProject) {
                            EditingDomain editingDomain = ((ECPProject)parentObject).getEditingDomain();
                            editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)eObjectImport){

                                protected void doExecute() {
                                    ((ECPProject)parentObject).getContents().add((Object)EcoreUtil.copy((EObject)eObjectImport));
                                    imported = true;
                                }
                            });
                        }
                    }
                    catch (RuntimeException e) {
                        Activator.log(e.getMessage(), e);
                        progressDialog.getProgressMonitor().done();
                        progressDialog.close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    progressDialog.getProgressMonitor().done();
                    progressDialog.close();
                    throw throwable;
                }
            }
            progressDialog.getProgressMonitor().done();
            progressDialog.close();
        }
        if (!imported) {
            MessageDialog.openWarning((Shell)shell, (String)"No Imports", (String)"No Objects were imported, the model element you selected probably can't contain the element you try to import.");
        }
    }

    private static String getFileName(Shell shell) {
        try {
            Class clazz = HandlerHelperUtil.loadClass("org.eclipse.emf.ecp.ui", FILE_DIALOG_HELPER_CLASS);
            ECPFileDialogHelper fileDialogHelper = (ECPFileDialogHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return fileDialogHelper.getPathForImport(shell);
        }
        catch (ClassNotFoundException ex) {
            Activator.log(ex);
        }
        catch (InstantiationException ex) {
            Activator.log(ex);
        }
        catch (IllegalAccessException ex) {
            Activator.log(ex);
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        catch (InvocationTargetException ex) {
            Activator.log(ex);
        }
        catch (NoSuchMethodException ex) {
            Activator.log(ex);
        }
        catch (SecurityException ex) {
            Activator.log(ex);
        }
        return null;
    }
}

