/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtils {
    private TypeUtils() {
    }

    public static EClass leastCommonAncestor(Collection<EClass> classes) {
        return TypeUtils.wrap(TypeUtils.leastCommonAncestorHelper(classes));
    }

    private static EClass leastCommonAncestorHelper(Collection<EClass> classes) {
        if (classes.isEmpty()) {
            return null;
        }
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        Iterator<EClass> i = classes.iterator();
        EClass lca = i.next();
        while (i.hasNext()) {
            if (lca == null) break;
            lca = TypeUtils.leastCommonAncestorHelper(lca, i.next());
        }
        return lca;
    }

    public static EClass leastCommonAncestor(EClass class1, EClass class2) {
        return TypeUtils.wrap(TypeUtils.leastCommonAncestorHelper(class1, class2));
    }

    static EClass wrap(EClass c) {
        return c == null ? EcorePackage.eINSTANCE.getEObject() : c;
    }

    static EClass leastCommonAncestorHelper(EClass class1, EClass class2) {
        if (TypeUtils.ancestor(class1, class2)) {
            return class2;
        }
        if (TypeUtils.ancestor(class2, class1)) {
            return class1;
        }
        EClass ancestor1 = TypeUtils.superClass(class1);
        while (ancestor1 != null) {
            if (TypeUtils.ancestor(class2, ancestor1)) {
                return ancestor1;
            }
            ancestor1 = TypeUtils.superClass(ancestor1);
        }
        EClass ancestor2 = TypeUtils.superClass(class2);
        while (ancestor2 != null) {
            if (TypeUtils.ancestor(class1, ancestor2)) {
                return ancestor2;
            }
            ancestor2 = TypeUtils.superClass(ancestor2);
        }
        return null;
    }

    public static boolean ancestor(EClass class1, EClass class2) {
        if (class1 == class2) {
            return true;
        }
        if (class2 == EcorePackage.eINSTANCE.getEObject()) {
            return true;
        }
        if (class2 == null) {
            return true;
        }
        if (class1 == null) {
            return false;
        }
        return TypeUtils.ancestor(TypeUtils.superClass(class1), class2);
    }

    static EClass superClass(EClass c) {
        if (c.getESuperTypes().isEmpty()) {
            return null;
        }
        return (EClass)c.getESuperTypes().get(0);
    }

    public static EClass commonSuperClass(List<EObject> elements) {
        HashSet<EClass> classes = new HashSet<EClass>();
        Iterator<EObject> i = elements.iterator();
        while (i.hasNext()) {
            classes.add(i.next().eClass());
        }
        return TypeUtils.leastCommonAncestor(classes);
    }

    public static boolean isCompatible(EClassifier classifier, EClassifier withClassifier) {
        if (classifier instanceof EDataType) {
            return classifier == withClassifier;
        }
        EClass clazz = (EClass)classifier;
        if (withClassifier instanceof EClass) {
            EClass withClazz = (EClass)withClassifier;
            return TypeUtils.ancestor(clazz, withClazz);
        }
        return false;
    }
}

