/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.signature;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.signaturetest.SigTestEE;
import ee.jakarta.tck.concurrent.framework.signaturetest.SigTestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;

public class ConcurrencySigTest
extends SigTestEE {
    private static final TestLogger log = TestLogger.get(ConcurrencySigTest.class);

    public ConcurrencySigTest() {
        this.setup();
    }

    @Override
    protected String[] getPackages(String vehicleName) {
        return new String[]{"jakarta.enterprise.concurrent", "jakarta.enterprise.concurrent.spi"};
    }

    protected String getClasspath() {
        String defined = System.getProperty("signature.sigTestClasspath");
        if (defined != null && !defined.isBlank()) {
            return defined;
        }
        String[] classes = new String[]{"jakarta.enterprise.concurrent.AbortedException", "jakarta.enterprise.util.Nonbinding", "jakarta.interceptor.InterceptorBinding"};
        String[] JDKModules = new String[]{"java.base", "java.rmi", "java.sql", "java.naming"};
        HashSet<String> classPaths = new HashSet<String>();
        for (String c : classes) {
            try {
                URL location;
                Class<?> clazz = Class.forName(c);
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                URL uRL = location = codeSource == null ? null : codeSource.getLocation();
                if (codeSource == null || location == null) {
                    log.warning(String.format("Could not resolve the the library for %s.", clazz.getName()));
                    continue;
                }
                String path = ConcurrencySigTest.resolvePath(location);
                if (classPaths.contains(path)) continue;
                classPaths.add(path);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class " + c + " from application server.");
            }
        }
        File jimageOutput = new File(this.testInfo.getJImageDir());
        for (String module : JDKModules) {
            Path modulePath = Paths.get(jimageOutput.getAbsolutePath(), module);
            if (!Files.isDirectory(modulePath, new LinkOption[0])) {
                throw new RuntimeException("Unable to load JDK module " + module + " from jimage output " + System.lineSeparator() + "Searched in directory: " + modulePath.toString());
            }
            classPaths.add(modulePath.toString());
        }
        return String.join((CharSequence)":", classPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeStreamToTempFile(InputStream inputStream, String tempFilePrefix, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile(tempFilePrefix, tempFileSuffix);
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeStreamToSigFile(InputStream inputStream) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File sigfile = new File(tmpdir + File.separator + "jakarta.enterprise.concurrent.sig");
            if (sigfile.exists()) {
                sigfile.delete();
                log.info("Existing signature file deleted to create new one");
            }
            if (!sigfile.createNewFile()) {
                log.info("signature file is not created");
            }
            outputStream = new FileOutputStream(sigfile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file = sigfile;
            return file;
        }
    }

    @Override
    public void signatureTest() throws SigTestEE.Fault {
        log.info("ConcurrencySigTest.signatureTest() called");
        SigTestResult results = null;
        String mapFile = null;
        String packageListFile = null;
        String signatureRepositoryDir = null;
        Properties mapFileAsProps = null;
        try {
            InputStream inStreamMapfile = ConcurrencySigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/concurrent/spec/signature/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            log.info("mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = ConcurrencySigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/concurrent/spec/signature/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageListFile = pFile.getCanonicalPath();
            log.info("packageFile location is :" + packageListFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            InputStream inStreamSigFile = ConcurrencySigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/concurrent/spec/signature/jakarta.enterprise.concurrent.sig");
            File sigFile = this.writeStreamToSigFile(inStreamSigFile);
            log.info("signature File location is :" + sigFile.getCanonicalPath());
            signatureRepositoryDir = System.getProperty("java.io.tmpdir");
        }
        catch (IOException ex) {
            log.info("Exception while creating temp files :" + ex);
        }
        String[] packagesUnderTest = this.getPackages(this.testInfo.getVehicle());
        String[] classesUnderTest = this.getClasses(this.testInfo.getVehicle());
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = this.testInfo.getJImageDir();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            log.info("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                System.out.println(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    log.info(line);
                }
                int rc = proc.waitFor();
                log.info("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                log.info("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        String classpath = this.getClasspath();
        try {
            results = this.getSigTestDriver().executeSigTest(packageListFile, mapFile, signatureRepositoryDir, packagesUnderTest, classesUnderTest, classpath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            log.info(results.toString());
            if (!results.passed()) {
                log.info("results.passed() returned false");
                throw new Exception();
            }
            log.info("$$$ ConcurrencySigTest.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new SigTestEE.Fault("ConcurrencySigTest.signatureTest() failed!, diffs found");
            }
            log.info("Unexpected exception " + e.getMessage());
            throw new SigTestEE.Fault("ConcurrencySigTest.signatureTest() failed with an unexpected exception", e);
        }
    }

    private static String resolvePath(URL resource) {
        if (resource == null) {
            return null;
        }
        String path = resource.getPath();
        String protocol = resource.getProtocol();
        if ("jar".equals(protocol)) {
            int start;
            int sepIdx = path.lastIndexOf("!/");
            int n = start = path.startsWith("file:") ? 5 : 0;
            if (sepIdx != -1) {
                return path.substring(start, sepIdx);
            }
            return path.substring(start);
        }
        return path;
    }
}

