/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.logging.LogCleanerUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Auditor;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator {
    protected static final java.util.logging.Logger log = LogFacade.getLogger();
    protected static final ResourceBundle rb = log.getResourceBundle();
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected static final int SESSION_ID_BYTES = 16;
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "Authentication required";
    protected boolean alwaysUseSession;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context;
    protected String entropy;
    protected boolean disableProxyCaching = true;
    protected SecureRandom random;
    protected String randomClass = SecureRandom.class.getName();
    protected SingleSignOn sso;
    protected boolean securePagesWithPragma = true;

    public boolean getAlwaysUseSession() {
        return this.alwaysUseSession;
    }

    public void setAlwaysUseSession(boolean alwaysUseSession) {
        this.alwaysUseSession = alwaysUseSession;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00001"));
        }
        super.setContainer(container);
        this.context = (Context)container;
        this.securePagesWithPragma = this.context.isSecurePagesWithPragma();
    }

    @Override
    public int getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public boolean isChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    public SingleSignOn getSingleSignOn() {
        return this.sso;
    }

    public void setSingleSignOn(SingleSignOn sso) {
        this.sso = sso;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Realm realm;
        SecurityConstraint[] constraints;
        Session session;
        Principal principal;
        if (!this.context.getAvailable()) {
            try {
                ((HttpServletResponse)response.getResponse()).sendError(503);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 2;
        }
        HttpRequest httpRequest = (HttpRequest)request;
        HttpResponse httpResponse = (HttpResponse)response;
        if (log.isLoggable(Level.FINE)) {
            String msg = "Security checking request " + ((HttpServletRequest)request.getRequest()).getMethod() + " " + ((HttpServletRequest)request.getRequest()).getRequestURI();
            log.log(Level.FINE, LogCleanerUtil.neutralizeForLog((String)msg));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null && (session = this.getSession(httpRequest)) != null && (principal = session.getPrincipal()) != null) {
            log.log(Level.FINE, () -> LogCleanerUtil.neutralizeForLog((String)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal())));
            httpRequest.setAuthType(session.getAuthType());
            httpRequest.setUserPrincipal(principal);
        }
        if ((constraints = (realm = this.context.getRealm()).findSecurityConstraints(httpRequest, this.context)) == null) {
            log.log(Level.FINE, " Not subject to any constraint");
            return this.processSecurityCheck(httpRequest, httpResponse, config);
        }
        log.log(Level.FINE, " Calling hasUserDataPermission()");
        if (!realm.hasUserDataPermission(httpRequest, httpResponse, constraints)) {
            log.log(Level.FINE, " Failed hasUserDataPermission() test");
            return 2;
        }
        int preAuthenticateCheckResult = realm.preAuthenticateCheck(httpRequest, httpResponse, constraints, this.disableProxyCaching, this.securePagesWithPragma, this.sso != null);
        if (preAuthenticateCheckResult == 0) {
            return this.processSecurityCheck(httpRequest, httpResponse, config);
        }
        if (preAuthenticateCheckResult == 1) {
            log.log(Level.FINE, " Calling authenticate()");
            boolean authenticateResult = realm.invokeAuthenticateDelegate(httpRequest, httpResponse, this.context, this, false);
            if (!authenticateResult) {
                log.log(Level.FINE, " Failed authenticate() test");
                return 2;
            }
        } else if (preAuthenticateCheckResult == -1) {
            return 2;
        }
        log.log(Level.FINE, " Calling accessControl()");
        if (!realm.hasResourcePermission(httpRequest, httpResponse, constraints, this.context)) {
            log.log(Level.FINE, " Failed accessControl() test");
            Auditor[] auditors = this.context.getAuditors();
            if (auditors != null) {
                for (Auditor auditor : auditors) {
                    auditor.webInvocation(httpRequest, false);
                }
            }
            return 2;
        }
        Auditor[] auditors = this.context.getAuditors();
        if (auditors != null) {
            boolean success = true;
            for (Auditor auditor : auditors) {
                try {
                    auditor.webInvocation(httpRequest, true);
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (!success) {
                return 2;
            }
        }
        log.log(Level.FINE, "Successfully passed all security constraints");
        return 1;
    }

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        Realm realm = this.context.getRealm();
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        if (realm != null) {
            realm.invokePostAuthenticateDelegate(hrequest, hresponse, this.context);
        }
    }

    protected void associate(String ssoId, long ssoVersion, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, ssoVersion, session);
    }

    public abstract boolean authenticate(HttpRequest var1, HttpResponse var2, LoginConfig var3) throws IOException;

    protected synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        StringBuilder result = new StringBuilder();
        for (byte element : bytes) {
            byte b1 = (byte)((element & 0xF0) >> 4);
            byte b2 = (byte)(element & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    protected synchronized SecureRandom getRandom() {
        if (this.random == null) {
            try {
                this.random = (SecureRandom)Class.forName(this.randomClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.random = new SecureRandom();
            }
        }
        return this.random;
    }

    protected Session getSession(HttpRequest request) {
        return this.getSession(request, false);
    }

    protected Session getSession(HttpRequest request, boolean create) {
        return request.getSessionInternal(create);
    }

    protected void log(String message) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00002", new Object[]{this.context.getPath(), message});
        }
    }

    protected void log(String message, Throwable t) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message, t, 2);
        } else {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00002"), this.context.getPath(), message);
            log.log(Level.WARNING, msg, t);
        }
    }

    protected void register(HttpRequest request, HttpResponse response, Principal principal, String authType, String username, char[] password) {
        if (log.isLoggable(Level.FINE)) {
            String pname = principal != null ? principal.getName() : "[null principal]";
            String msg = "Authenticated '" + pname + "' with type '" + authType + "'";
            log.log(Level.FINE, LogCleanerUtil.neutralizeForLog((String)msg));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = this.getSession(request, false);
        if (session != null && this.changeSessionIdOnAuthentication) {
            request.changeSessionId();
        } else if (this.alwaysUseSession) {
            session = this.getSession(request, true);
        }
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        String generatedSessionId = request.generateSessionId();
        if (generatedSessionId == null) {
            generatedSessionId = this.generateSessionId();
        }
        Cookie cookie = new Cookie("JSESSIONIDSSO", generatedSessionId);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        StandardHost host = (StandardHost)this.context.getParent();
        if (host != null) {
            host.configureSingleSignOnCookieSecure(cookie, httpServletRequest);
            host.configureSingleSignOnCookieHttpOnly(cookie);
        } else {
            cookie.setSecure(httpServletRequest.isSecure());
        }
        httpServletResponse.addCookie(cookie);
        String realmName = this.context.getRealm().getRealmName();
        this.sso.register(generatedSessionId, principal, authType, username, password, realmName);
        request.setNote("org.apache.catalina.request.SSOID", generatedSessionId);
        if (this.sso.isVersioningSupported()) {
            request.setNote("org.apache.catalina.request.SSOVersion", 0L);
        }
    }

    @Override
    public void login(String username, char[] password, HttpRequest request) throws ServletException {
        Principal principal = this.doLogin(request, username, password);
        this.register(request, (HttpResponse)request.getResponse(), principal, this.getAuthMethod(), username, password);
    }

    protected abstract String getAuthMethod();

    protected Principal doLogin(HttpRequest request, String username, char[] password) throws ServletException {
        Principal callerPrincipal = this.context.getRealm().authenticate(request, username, password);
        if (callerPrincipal == null) {
            throw new ServletException(rb.getString("AS-WEB-CORE-00535"));
        }
        return callerPrincipal;
    }

    @Override
    public void logout(HttpRequest request) throws ServletException {
        Session session = this.getSession(request);
        if (session != null) {
            session.setPrincipal(null);
            session.setAuthType(null);
        }
        this.register(request, (HttpResponse)request.getResponse(), null, null, null, null);
    }

    private int processSecurityCheck(HttpRequest hrequest, HttpResponse hresponse, LoginConfig config) throws IOException {
        String contextPath = this.context.getPath();
        String requestURI = hrequest.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && this.getClass().equals(FormAuthenticator.class) && requestURI.endsWith("/j_security_check") && !this.authenticate(hrequest, hresponse, config)) {
            log.log(Level.FINE, () -> LogCleanerUtil.neutralizeForLog((String)(" Failed authenticate() test ??" + requestURI)));
            return 2;
        }
        return 1;
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if ("org.apache.catalina.core.StandardContext".equals(this.context.getClass().getName())) {
            try {
                Class[] paramTypes = new Class[]{};
                Object[] paramValues = new Object[]{};
                Method method = this.context.getClass().getMethod("getDebug", paramTypes);
                Integer result = (Integer)method.invoke((Object)this.context, paramValues);
                this.setDebug(result);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00003", e);
            }
        }
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            GlassFishValve[] valves;
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            for (GlassFishValve element : valves = ((Pipeline)((Object)parent)).getValves()) {
                if (!(element instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)element;
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (this.sso != null) {
            log.log(Level.FINE, () -> "Found SingleSignOn Valve at " + this.sso);
        } else {
            log.log(Level.FINE, "No SingleSignOn Valve is present");
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.sso = null;
        super.stop();
    }

    public void setRealmName(String name) {
    }

    public String getRealmName() {
        return null;
    }
}

