/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.common.wls;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbReferenceDescriptionNode
extends RuntimeDescriptorNode<EjbReferenceDescriptor> {
    private EjbReferenceDescriptor descriptor;

    @Override
    public EjbReferenceDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("ejb-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            Logger logger = DOLUtils.getDefaultLogger();
            if (parentDesc instanceof EjbReferenceContainer) {
                try {
                    this.descriptor = ((EjbReferenceContainer)parentDesc).getEjbReference(value);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Applying ref runtime to " + this.descriptor);
                    }
                }
                catch (IllegalArgumentException iae) {
                    logger.warning(iae.getMessage());
                }
            }
            if (this.descriptor == null) {
                logger.log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{"ejb-ref", value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, EjbReferenceDescriptor descriptor) {
        Element ejbRef = EjbReferenceDescriptionNode.appendChild(parent, nodeName);
        EjbReferenceDescriptionNode.appendTextChild((Node)ejbRef, "ejb-ref-name", descriptor.getName());
        EjbReferenceDescriptionNode.appendTextChild((Node)ejbRef, "jndi-name", descriptor.getJndiName());
        return ejbRef;
    }

    @Override
    public Node writeDescriptors(Node parent, String nodeName, Descriptor parentDesc) {
        if (parentDesc instanceof EjbReferenceContainer) {
            EjbReferenceContainer ejbReferenceContainer = (EjbReferenceContainer)parentDesc;
            Set<EjbReferenceDescriptor> ejbReferences = ejbReferenceContainer.getEjbReferenceDescriptors();
            for (EjbReferenceDescriptor ejbReference : ejbReferences) {
                this.writeDescriptor(parent, nodeName, ejbReference);
            }
        }
        return parent;
    }
}

