/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util;

import com.sun.ejb.InvocationInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class MethodMap
extends HashMap<Method, InvocationInfo> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUCKET_MULTIPLIER = 20;
    private final int numBuckets_;
    private MethodInfo[] methodInfo_;

    public MethodMap(Map<Method, InvocationInfo> methodMap) {
        super(methodMap);
        this.numBuckets_ = methodMap.size() * 20;
        this.buildLookupTable(methodMap);
    }

    public MethodMap(Map<Method, InvocationInfo> methodMap, int numBuckets) {
        super(methodMap);
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Invalid value of numBuckets = " + numBuckets);
        }
        this.numBuckets_ = numBuckets;
        this.buildLookupTable(methodMap);
    }

    @Override
    public InvocationInfo put(Method key, InvocationInfo value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Method, ? extends InvocationInfo> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InvocationInfo remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InvocationInfo get(Object key) {
        if (key instanceof Method) {
            Method m = (Method)key;
            Class<?>[] paramTypes = m.getParameterTypes();
            return this.get(m, paramTypes.length);
        }
        return null;
    }

    public InvocationInfo get(Method m, int numParams) {
        if (this.methodInfo_ == null) {
            return null;
        }
        if (numParams < 0) {
            throw new IllegalStateException("invalid numParams = " + numParams);
        }
        InvocationInfo value = null;
        MethodInfo methodInfo = this.methodInfo_[this.getBucket(m, numParams)];
        if (methodInfo != null && methodInfo.declaringClass == m.getDeclaringClass()) {
            value = methodInfo.value;
        }
        return value == null ? (InvocationInfo)super.get(m) : value;
    }

    @Override
    public void clear() {
        if (this.methodInfo_ != null) {
            this.methodInfo_ = null;
            super.clear();
        }
    }

    private void buildLookupTable(Map<Method, InvocationInfo> methodMap) {
        this.methodInfo_ = new MethodInfo[this.numBuckets_];
        HashSet<Integer> occupied = new HashSet<Integer>();
        for (Map.Entry<Method, InvocationInfo> entry : methodMap.entrySet()) {
            Method nextObj = entry.getKey();
            Method next = null;
            if (nextObj == null) {
                throw new IllegalStateException("null keys not supported");
            }
            if (!(nextObj instanceof Method)) {
                throw new IllegalStateException("invalid key type = " + nextObj.getClass() + " key must be of type java.lang.reflect.Method");
            }
            next = nextObj;
            int bucket = this.getBucket(next);
            if (occupied.contains(bucket)) {
                this.methodInfo_[bucket] = null;
                continue;
            }
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.value = entry.getValue();
            methodInfo.declaringClass = next.getDeclaringClass();
            this.methodInfo_[bucket] = methodInfo;
            occupied.add(bucket);
        }
    }

    private int getBucket(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        return this.getBucket(m, paramTypes.length);
    }

    private int getBucket(Method m, int numParams) {
        String methodName = m.getName();
        int hashCode = methodName.hashCode();
        hashCode = hashCode >= 0 ? hashCode : hashCode * -1;
        hashCode = hashCode > numParams ? hashCode - numParams : hashCode + numParams;
        return hashCode % this.numBuckets_;
    }

    private static class MethodInfo {
        public Class<?> declaringClass;
        public InvocationInfo value;

        private MethodInfo() {
        }
    }
}

