/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ServiceInitializerListener;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.grizzly.LazyServiceInitializer;

public class ServiceInitializerFilter
extends BaseFilter {
    private final ServiceLocator locator;
    private volatile LazyServiceInitializer targetInitializer = null;
    private final List<ActiveDescriptor<?>> initializerImplList;
    protected final Logger logger;
    private final ServiceInitializerListener listener;
    private final Object LOCK_OBJ = new Object();

    public ServiceInitializerFilter(ServiceInitializerListener listener, ServiceLocator habitat, Logger logger) {
        this.locator = habitat;
        this.initializerImplList = habitat.getDescriptors((Filter)BuilderHelper.createContractFilter((String)LazyServiceInitializer.class.getName()));
        if (this.initializerImplList.isEmpty()) {
            throw new IllegalStateException("NO Lazy Initializer was found for port = " + listener.getPort());
        }
        this.logger = logger;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        NIOConnection nioConnection = (NIOConnection)ctx.getConnection();
        SelectableChannel channel = nioConnection.getChannel();
        String listenerName = this.listener.getName();
        String protocolName = this.listener.getNetworkListener().getProtocol();
        if (this.targetInitializer == null) {
            Object object = this.LOCK_OBJ;
            synchronized (object) {
                if (this.targetInitializer == null) {
                    LazyServiceInitializer targetInitializerLocal = null;
                    for (ActiveDescriptor<?> initializer : this.initializerImplList) {
                        String serviceName = initializer.getName();
                        if (serviceName == null || !listenerName.equalsIgnoreCase(serviceName) && !protocolName.equalsIgnoreCase(serviceName)) continue;
                        targetInitializerLocal = (LazyServiceInitializer)this.locator.getServiceHandle(initializer).getService();
                        break;
                    }
                    if (targetInitializerLocal == null) {
                        this.logger.log(Level.SEVERE, "NO Lazy Initialiser implementation was found for port = {0}", String.valueOf(this.listener.getPort()));
                        nioConnection.close();
                        return ctx.getStopAction();
                    }
                    if (!targetInitializerLocal.initializeService()) {
                        this.logger.log(Level.SEVERE, "Lazy Service initialization failed for port = {0}", String.valueOf(this.listener.getPort()));
                        nioConnection.close();
                        return ctx.getStopAction();
                    }
                    this.targetInitializer = targetInitializerLocal;
                }
            }
        }
        NextAction nextAction = ctx.getSuspendAction();
        ctx.completeAndRecycle();
        SelectorRunner runner = nioConnection.getSelectorRunner();
        SelectorHandler selectorHandler = ((NIOTransport)nioConnection.getTransport()).getSelectorHandler();
        selectorHandler.deregisterChannel(runner, channel);
        channel.configureBlocking(true);
        this.targetInitializer.handleRequest(channel);
        return nextAction;
    }
}

