/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.TimeStamp;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public final class TimeStampRenderer
extends AbstractRenderer {
    private static final String[] CORE_ATTRIBUTES = new String[]{"style", "title"};

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        TimeStamp timeStamp = (TimeStamp)component;
        Theme theme = ThemeUtilities.getTheme(context);
        if (!timeStamp.isRendered()) {
            return;
        }
        String textStyle = theme.getStyleClass("TIMESTAMP_TEXT");
        StringBuilder sb = new StringBuilder(timeStamp.getClientId(context));
        int idlen = sb.length();
        writer.startElement("span", (UIComponent)timeStamp);
        writer.writeAttribute("id", (Object)sb.toString(), "id");
        writer.startElement("span", (UIComponent)timeStamp);
        writer.writeAttribute("id", (Object)sb.append("_span1"), "id");
        sb.setLength(idlen);
        RenderingUtilities.renderStyleClass(context, writer, component, textStyle);
        TimeStampRenderer.addStringAttributes(context, component, writer, CORE_ATTRIBUTES);
        String message = timeStamp.getText();
        if (message == null) {
            message = theme.getMessage("TimeStamp.lastUpdate");
        }
        writer.write(message);
        writer.endElement("span");
        writer.write("&nbsp;");
        writer.startElement("span", (UIComponent)timeStamp);
        writer.writeAttribute("id", (Object)sb.append("_span2"), "id");
        RenderingUtilities.renderStyleClass(context, writer, component, textStyle);
        TimeStampRenderer.addStringAttributes(context, component, writer, CORE_ATTRIBUTES);
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(Integer.parseInt(theme.getMessage("TimeStamp.dateStyle")), Integer.parseInt(theme.getMessage("TimeStamp.timeStyle")), locale);
        writer.write(dateFormat.format(new Date()));
        writer.endElement("span");
        writer.endElement("span");
    }
}

