/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.ODLLogParser;
import com.sun.enterprise.server.logging.parser.OneLineLogParser;
import com.sun.enterprise.server.logging.parser.RawLogParser;
import com.sun.enterprise.server.logging.parser.UniformLogParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.glassfish.main.jul.formatter.LogFormatDetector;

public class LogParserFactory {
    private static final Logger LOG = Logger.getLogger(LogParserFactory.class.getName());
    private static final LogParserFactory SINGLETON = new LogParserFactory();
    private final LogFormatDetector logFormatDetector = new LogFormatDetector();

    public static LogParserFactory getInstance() {
        return SINGLETON;
    }

    private LogParserFactory() {
    }

    public LogParser createLogParser(File logFile) throws IOException {
        String firstLine;
        try (BufferedReader reader = this.createReader(logFile);){
            firstLine = reader.readLine();
        }
        LogFormat format = this.detectLogFormat(firstLine);
        LOG.fine(() -> "Detected log format=" + String.valueOf((Object)format) + " for line: " + firstLine);
        switch (format.ordinal()) {
            case 0: {
                return new UniformLogParser();
            }
            case 1: {
                return new ODLLogParser();
            }
            case 2: {
                return new OneLineLogParser();
            }
        }
        return new RawLogParser();
    }

    private BufferedReader createReader(File logFile) throws IOException {
        if (this.logFormatDetector.isCompressedFile(logFile.getName())) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(logFile))));
        }
        return new BufferedReader(new FileReader(logFile));
    }

    private LogFormat detectLogFormat(String line) {
        if (line != null) {
            if (this.logFormatDetector.isODLFormatLogHeader(line)) {
                return LogFormat.ODL_LOG_FORMAT;
            }
            if (this.logFormatDetector.isUniformFormatLogHeader(line)) {
                return LogFormat.UNIFORM_LOG_FORMAT;
            }
            if (this.logFormatDetector.isOneLineLFormatLogHeader(line)) {
                return LogFormat.ONELINE_LOG_FORMAT;
            }
        }
        return LogFormat.UNKNOWN_LOG_FORMAT;
    }

    private static enum LogFormat {
        UNIFORM_LOG_FORMAT,
        ODL_LOG_FORMAT,
        ONELINE_LOG_FORMAT,
        UNKNOWN_LOG_FORMAT;

    }
}

