/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.logging.LogCleanerUtil;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.api.ActionReport;
import org.glassfish.common.util.Constants;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RestUtil {
    public static final String FORM_ENCODING = "application/x-www-form-urlencoded";
    public static final String RESPONSE_TYPE = "application/json";
    public static final String GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE = "()";
    public static final String REST_TOKEN_COOKIE = "gfresttoken";
    private static Client JERSEY_CLIENT;

    public static synchronized Client getJerseyClient() {
        if (JERSEY_CLIENT == null) {
            JERSEY_CLIENT = RestUtil.initialize(ClientBuilder.newBuilder()).build();
            ((Client)JERSEY_CLIENT.register((Object)new RequiredHeadersFilter())).register((Object)new JacksonFeature());
        }
        return JERSEY_CLIENT;
    }

    public static String getPropValue(String endpoint, String propName, HandlerContext handlerCtx) {
        Map<String, Object> responseMap = RestUtil.restRequest(endpoint + "/property.json", null, "GET", handlerCtx, false);
        Map extraPropertiesMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
        if (extraPropertiesMap != null) {
            List props = (List)extraPropertiesMap.get("properties");
            for (Map oneProp : props) {
                if (!oneProp.get("name").equals(propName)) continue;
                return (String)oneProp.get("value");
            }
        }
        return "";
    }

    public static String resolveToken(String endpoint, String token) {
        String tokenStartMarker = "${";
        String tokenEndMarker = "}";
        if (!token.trim().startsWith(tokenStartMarker)) {
            return token;
        }
        int start = token.indexOf(tokenStartMarker);
        if (start < 0) {
            return token;
        }
        int end = token.lastIndexOf(tokenEndMarker);
        if (end < 0) {
            return token;
        }
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        String str = token.substring(start + tokenStartMarker.length(), end - tokenEndMarker.length() + 1);
        attrMap.put("tokens", str);
        try {
            Map<String, Object> result = RestUtil.restRequest(endpoint + "/resolve-tokens.json", attrMap, "GET", null, true);
            return (String)GuiUtil.getMapValue(result, "data,extraProperties,tokens," + str);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().info(ex.getMessage());
            return token;
        }
    }

    public static Map<String, Object> restRequest(String endpoint, Map<String, Object> attrs, String method, HandlerContext handlerCtx, boolean quiet) {
        return RestUtil.restRequest(endpoint, attrs, method, handlerCtx, quiet, true);
    }

    public static Map<String, Object> restRequest(String endpoint, Map<String, Object> attrs, String method, HandlerContext handlerCtx, boolean quiet, boolean throwException) {
        boolean useData = false;
        Object data = null;
        if (attrs == null) {
            try {
                data = handlerCtx == null ? null : handlerCtx.getInputValue("data");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data != null) {
                useData = true;
            } else {
                attrs = new HashMap<String, Object>();
            }
        }
        method = method.toLowerCase(new Locale("UTF-8"));
        Logger logger = GuiUtil.getLogger();
        if (logger.isLoggable(Level.FINEST)) {
            Map maskedAttr = RestUtil.maskOffPassword(attrs);
            logger.log(Level.FINEST, LogCleanerUtil.neutralizeForLog(GuiUtil.getCommonMessage("LOG_REST_REQUEST_INFO", new Object[]{endpoint, useData && "post".equals(method) ? data : maskedAttr, method})));
        }
        RestResponse restResponse = null;
        if ("post".equals(method)) {
            restResponse = useData ? RestUtil.post(endpoint, data, (String)handlerCtx.getInputValue("contentType")) : RestUtil.post(endpoint, attrs);
        } else if ("put".equals(method)) {
            restResponse = RestUtil.put(endpoint, attrs);
        } else if ("get".equals(method)) {
            restResponse = RestUtil.get(endpoint, attrs);
        } else if ("delete".equals(method)) {
            restResponse = RestUtil.delete(endpoint, attrs);
        } else {
            throw new RuntimeException(GuiUtil.getCommonMessage("rest.invalid_method", new Object[]{method}));
        }
        if (restResponse.getResponseCode() == 401) {
            FacesContext fc = FacesContext.getCurrentInstance();
            HttpSession session = (HttpSession)fc.getExternalContext().getSession(false);
            HttpServletRequest request = (HttpServletRequest)fc.getExternalContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)fc.getExternalContext().getResponse();
            if (!"/login.jsf".equals(request.getServletPath())) {
                try {
                    response.sendRedirect("/");
                    fc.responseComplete();
                    session.invalidate();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return RestUtil.parseResponse(restResponse, handlerCtx, endpoint, useData && "post".equals(method) ? data : attrs, quiet, throwException);
    }

    public static Map maskOffPassword(Map<String, Object> attrs) {
        HashMap<String, Object> masked = new HashMap<String, Object>();
        if (attrs == null) {
            return masked;
        }
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String key = e.getKey().toLowerCase(GuiUtil.guiLocale);
            if (Constants.PASSWORD_ATTRIBUTE_NAMES.contains(key)) {
                masked.put(e.getKey(), "*******");
                continue;
            }
            masked.put(e.getKey(), e.getValue());
        }
        return masked;
    }

    public static Map<String, String> buildDefaultValueMap(String endpoint) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        RestResponse response = RestUtil.options(endpoint, RESPONSE_TYPE);
        Map data = (Map)response.getResponse().get("data");
        List methods = null;
        Map extraProperties = (Map)data.get("extraProperties");
        methods = (List)extraProperties.get("methods");
        for (Map method : methods) {
            Map messageParameters;
            if (!"POST".equals(method.get("name")) || (messageParameters = (Map)method.get("messageParameters")) == null) continue;
            for (Map.Entry entry : messageParameters.entrySet()) {
                String param = (String)entry.getKey();
                String defaultValue = (String)((Map)entry.getValue()).get("defaultValue");
                if ("".equals(defaultValue) || defaultValue == null) continue;
                defaultValues.put(param, defaultValue);
            }
        }
        return defaultValues;
    }

    public static Map getAttributesMap(String endpoint) {
        try (RestResponse response = null;){
            response = RestUtil.get(endpoint);
            if (!response.isSuccess()) {
                HashMap hashMap = new HashMap();
                return hashMap;
            }
            Map<String, Object> map = RestUtil.getEntityAttrs(endpoint, "entity");
            return map;
        }
    }

    public static Map<String, Object> getEntityAttrs(String endpoint, String key) {
        Map<String, Object> valueMap = new HashMap<String, Object>();
        try {
            Map<String, Object> result = RestUtil.restRequest(endpoint, null, "get", null, false);
            int responseCode = (Integer)result.get("responseCode");
            if (responseCode < 200 || responseCode > 299) {
                throw new RuntimeException((String)result.get("responseBody"));
            }
            Map data = (Map)result.get("data");
            Map extraProperties = (Map)data.get("extraProperties");
            if (extraProperties.containsKey(key)) {
                valueMap = (Map)extraProperties.get(key);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return valueMap;
    }

    private static String getMessage(Map aMap) {
        String message = "";
        if (aMap != null) {
            message = (String)aMap.get("message");
        }
        return message == null ? "" : message;
    }

    public static Map<String, Object> parseResponse(RestResponse response, HandlerContext handlerCtx, String endpoint, Object attrs, boolean quiet, boolean throwException) {
        Object message = "";
        ActionReport.ExitCode exitCode = ActionReport.ExitCode.FAILURE;
        Object maskedAttr = attrs;
        if (attrs != null && attrs instanceof Map) {
            maskedAttr = RestUtil.maskOffPassword((Map)attrs);
        }
        if (response != null) {
            try {
                Map<String, Object> responseMap = response.getResponse();
                if (responseMap.get("data") != null) {
                    String exitCodeStr = (String)((Map)responseMap.get("data")).get("exit_code");
                    ActionReport.ExitCode exitCode2 = exitCode = exitCodeStr != null ? ActionReport.ExitCode.valueOf(exitCodeStr) : ActionReport.ExitCode.SUCCESS;
                }
                if (exitCode != ActionReport.ExitCode.SUCCESS) {
                    Map dataMap = (Map)responseMap.get("data");
                    if (dataMap != null) {
                        message = RestUtil.getMessage(dataMap);
                        List subReports = (List)dataMap.get("subReports");
                        if (subReports != null) {
                            StringBuilder sb = new StringBuilder("");
                            for (Map oneSubReport : subReports) {
                                sb.append(" ").append(RestUtil.getMessage(oneSubReport));
                            }
                            message = (String)message + sb.toString();
                        }
                    } else {
                        Object msgs = responseMap.get("message");
                        if (msgs == null) {
                            message = "";
                        } else if (msgs instanceof List) {
                            StringBuilder builder = new StringBuilder("");
                            for (Object obj : (List)msgs) {
                                if (obj instanceof Map && ((Map)obj).containsKey("message")) {
                                    obj = ((Map)obj).get("message");
                                }
                                builder.append(obj.toString());
                            }
                            message = builder.toString();
                        } else if (msgs instanceof Map) {
                            message = ((Map)msgs).get("message").toString();
                        } else {
                            throw new RuntimeException("Unexpected message type.");
                        }
                    }
                }
                switch (exitCode) {
                    case FAILURE: {
                        Logger logger;
                        if (throwException) {
                            if (handlerCtx != null) {
                                GuiUtil.handleError(handlerCtx, (String)message);
                                if (!quiet) {
                                    logger = GuiUtil.getLogger();
                                    logger.log(Level.SEVERE, LogCleanerUtil.neutralizeForLog(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, maskedAttr})));
                                    logger.log(Level.FINEST, "response.getResponseBody(): " + response.getResponseBody());
                                }
                                return new HashMap<String, Object>();
                            }
                            throw new RuntimeException((String)message);
                        }
                        if (!quiet) {
                            logger = GuiUtil.getLogger();
                            logger.log(Level.SEVERE, LogCleanerUtil.neutralizeForLog(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, maskedAttr})));
                            logger.log(Level.FINEST, "response.getResponseBody(): " + response.getResponseBody());
                        }
                        return responseMap;
                    }
                    case WARNING: {
                        GuiUtil.prepareAlert("warning", GuiUtil.getCommonMessage("msg.command.warning"), (String)message);
                        GuiUtil.getLogger().log(Level.WARNING, LogCleanerUtil.neutralizeForLog(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, maskedAttr})));
                        return responseMap;
                    }
                    case SUCCESS: {
                        return responseMap;
                    }
                }
            }
            catch (Exception ex) {
                if (!quiet) {
                    Logger logger = GuiUtil.getLogger();
                    logger.log(Level.SEVERE, LogCleanerUtil.neutralizeForLog(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, maskedAttr})));
                    logger.log(Level.FINEST, "response.getResponseBody(): " + response.getResponseBody());
                }
                if (handlerCtx != null) {
                    if (throwException) {
                        if ("".equals(message)) {
                            GuiUtil.handleException(handlerCtx, ex);
                        } else {
                            GuiUtil.handleError(handlerCtx, (String)message);
                        }
                    }
                }
                if ("".equals(message)) {
                    throw new RuntimeException(ex);
                }
                throw new RuntimeException((String)message, ex);
            }
        }
        return null;
    }

    public static boolean hasWarning(Map responseMap) {
        if (responseMap.get("data") != null) {
            String exitCodeStr = (String)((Map)responseMap.get("data")).get("exit_code");
            ActionReport.ExitCode exitCode = exitCodeStr != null ? ActionReport.ExitCode.valueOf(exitCodeStr) : ActionReport.ExitCode.SUCCESS;
            return exitCode == ActionReport.ExitCode.WARNING;
        }
        return false;
    }

    public static String appendEncodedSegment(String base, String segment) {
        String encodedUrl = RestUtil.getJerseyClient().target(base).getUriBuilder().segment(new String[]{segment}).build(new Object[0]).toASCIIString();
        return encodedUrl;
    }

    protected static MultivaluedMap buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        if (payload == null || payload.isEmpty()) {
            return formData;
        }
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    try {
                        formData.add((Object)key, obj);
                    }
                    catch (ClassCastException ex) {
                        Logger logger = GuiUtil.getLogger();
                        logger.log(Level.FINEST, GuiUtil.getCommonMessage("LOG_BUILD_MULTI_VALUE_MAP_ERROR", new Object[]{key, obj}));
                    }
                }
                continue;
            }
            try {
                formData.putSingle((Object)key, value);
            }
            catch (ClassCastException ex) {
                Logger logger = GuiUtil.getLogger();
                logger.log(Level.FINEST, GuiUtil.getCommonMessage("LOG_BUILD_MULTI_VALUE_MAP_ERROR", new Object[]{key, value}));
            }
        }
        return formData;
    }

    public static RestResponse sendCreateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestUtil.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestUtil.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestUtil.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestUtil.fixKeyNames(attrs);
        return RestUtil.post(endpoint, attrs);
    }

    public static RestResponse sendUpdateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestUtil.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestUtil.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestUtil.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestUtil.fixKeyNames(attrs);
        return RestUtil.post(endpoint, attrs);
    }

    protected static Map<String, Object> fixKeyNames(Map<String, Object> map) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().substring(0, 1).toLowerCase(GuiUtil.guiLocale) + entry.getKey().substring(1);
            Object value = entry.getValue();
            results.put(key, value);
        }
        return results;
    }

    protected static void removeSpecifiedAttrs(Map<String, Object> attrs, List<String> removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    protected static Map buildUseOnlyAttrMap(Map<String, Object> attrs, List<String> onlyUseAttrs) {
        if (onlyUseAttrs != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (String key : onlyUseAttrs) {
                if (!attrs.keySet().contains(key)) continue;
                newAttrs.put(key, attrs.get(key));
            }
            return newAttrs;
        }
        return attrs;
    }

    protected static Map<String, Object> convertNullValuesToFalse(Map<String, Object> attrs, List<String> convertToFalse) {
        if (convertToFalse != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (convertToFalse.contains(key) && (entry.getValue() == null || "null".equals(entry.getValue()))) {
                    newAttrs.put(key, "false");
                    continue;
                }
                newAttrs.put(key, entry.getValue());
            }
            return newAttrs;
        }
        return attrs;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(new Locale("UTF-8")) + string.substring(1);
    }

    public static List<String> getChildResourceList(String document) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> children = new ArrayList<String>();
        Document doc = MiscUtil.getDocument(document);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("childResource");
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child.getTextContent());
            }
        }
        return children;
    }

    public static List<Map> buildChildEntityList(String parent, String childType, List skipList, List includeList, String id) throws Exception {
        String endpoint = parent.endsWith("/") ? parent + childType : parent + "/" + childType;
        boolean hasSkip = skipList != null;
        boolean hasInclude = includeList != null;
        boolean convert = childType.equals("property");
        ArrayList<Map> childElements = new ArrayList<Map>();
        List<String> childUrls = RestUtil.getChildList(endpoint);
        for (String childUrl : childUrls) {
            Map<String, Object> entity = RestUtil.getEntityAttrs(childUrl, "entity");
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (hasSkip && skipList.contains(entity.get(id)) || hasInclude && !includeList.contains(entity.get(id))) continue;
            oneRow.put("selected", false);
            for (Map.Entry<String, Object> e : entity.entrySet()) {
                oneRow.put(e.getKey(), RestUtil.getA(entity, e.getKey(), convert));
            }
            oneRow.put("encodedName", URLEncoder.encode(entity.get(id).toString(), "UTF-8"));
            oneRow.put("name", entity.get(id));
            childElements.add(oneRow);
        }
        return childElements;
    }

    private static String getA(Map<String, Object> attrs, String key, boolean convert) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return convert && val.equals("") ? GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE : val.toString();
    }

    public static List<String> getChildList(String endpoint) throws Exception {
        ArrayList<String> childElements = new ArrayList<String>();
        Map<String, String> childResources = RestUtil.getChildMap(endpoint);
        childElements.addAll(childResources.values());
        Collections.sort(childElements);
        return childElements;
    }

    public static Map<String, String> getChildMap(String endpoint) throws Exception {
        return RestUtil.getChildMap(endpoint, null);
    }

    public static Map<String, String> getChildMap(String endpoint, Map attrs) throws Exception {
        Map extraProperties;
        Map<String, Object> responseMap;
        Map data;
        Map<String, String> childElements = new TreeMap<String, String>();
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        if (RestUtil.doesProxyExist(endpoint).booleanValue() && (data = (Map)(responseMap = RestUtil.restRequest(endpoint, attrs, "get", null, false)).get("data")) != null && (extraProperties = (Map)data.get("extraProperties")) != null && (childElements = (Map)extraProperties.get("childResources")) == null) {
            childElements = new TreeMap();
        }
        return childElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean doesProxyExist(String endpoint) {
        try (RestResponse response = null;){
            response = RestUtil.get(endpoint);
            if (response.isSuccess()) {
                Boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static String getRestToken() {
        String token = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            token = (String)ctx.getExternalContext().getSessionMap().get("__rTkn__");
        }
        return token;
    }

    public static Response getRequestFromServlet(HttpServletRequest request, String endpoint, Map<String, Object> attrs) {
        String token = (String)request.getSession().getAttribute("__rTkn__");
        WebTarget target = RestUtil.targetWithQueryParams(JERSEY_CLIENT.target(endpoint), attrs);
        Response cr = (Response)target.request().cookie(new Cookie(REST_TOKEN_COOKIE, token)).get(Response.class);
        return cr;
    }

    public static void getRestRequestFromServlet(HttpServletRequest request, String endpoint, Map<String, Object> attrs, boolean quiet, boolean throwException) {
        String token = (String)request.getSession().getAttribute("__rTkn__");
        WebTarget target = RestUtil.targetWithQueryParams(JERSEY_CLIENT.target(endpoint), attrs);
        Response cr = (Response)target.request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, token)).get(Response.class);
        RestResponse rr = RestResponse.getRestResponse(cr);
        RestUtil.parseResponse(rr, null, endpoint, attrs, quiet, throwException);
    }

    public static WebTarget targetWithQueryParams(WebTarget target, Map<String, Object> paramMap) {
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            target = target.queryParam(param.getKey(), new Object[]{param.getValue()});
        }
        return target;
    }

    public static RestResponse get(String address) {
        return RestUtil.get(address, new HashMap<String, Object>());
    }

    public static RestResponse get(String address, Map<String, Object> payload) {
        if (((String)address).startsWith("/")) {
            address = String.valueOf(FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("REST_URL")) + (String)address;
        }
        WebTarget target = RestUtil.targetWithQueryParams(RestUtil.getJerseyClient().target((String)address), payload);
        Response resp = (Response)target.request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).get(Response.class);
        return RestResponse.getRestResponse(resp);
    }

    public static RestResponse post(String address, Object payload, String contentType) {
        WebTarget target = RestUtil.getJerseyClient().target(address);
        if (contentType == null) {
            contentType = RESPONSE_TYPE;
        }
        if (payload instanceof Map) {
            payload = RestUtil.buildMultivalueMap((Map)payload);
        }
        Response cr = (Response)target.request(new String[]{RESPONSE_TYPE}).header("Content-Type", (Object)contentType).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).post(Entity.entity((Object)payload, (String)contentType), Response.class);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse post(String address, Map<String, Object> payload) {
        WebTarget target = RestUtil.getJerseyClient().target(address);
        MultivaluedMap formData = RestUtil.buildMultivalueMap(payload);
        Response cr = (Response)target.request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).post(Entity.entity((Object)formData, (String)FORM_ENCODING), Response.class);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse put(String address, Map<String, Object> payload) {
        WebTarget target = RestUtil.getJerseyClient().target(address);
        MultivaluedMap formData = RestUtil.buildMultivalueMap(payload);
        Response cr = (Response)target.request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).put(Entity.entity((Object)formData, (String)FORM_ENCODING), Response.class);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse delete(String address, Map<String, Object> payload) {
        WebTarget target = RestUtil.getJerseyClient().target(address);
        Response cr = (Response)RestUtil.targetWithQueryParams(target, payload).request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).delete(Response.class);
        return RestResponse.getRestResponse(cr);
    }

    public static RestResponse options(String address, String responseType) {
        WebTarget target = RestUtil.getJerseyClient().target(address);
        Response cr = (Response)target.request(new String[]{responseType}).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).options(Response.class);
        return RestResponse.getRestResponse(cr);
    }

    public static void checkStatusForSuccess(Response cr) {
        int status = cr.getStatus();
        if (status < 200 || status > 299) {
            throw new RuntimeException(cr.toString());
        }
    }

    public static ClientBuilder initialize(ClientBuilder clientBuilder) {
        block2: {
            try {
                ServiceLocator habitat = SecurityServicesUtil.getInstance().getHabitat();
                SecureAdmin secureAdmin = (SecureAdmin)habitat.getService(SecureAdmin.class, new Annotation[0]);
                SSLContext sslContext = ((SSLUtils)habitat.getService(SSLUtils.class, new Annotation[0])).getAdminSSLContext(SecureAdmin.DASAlias((SecureAdmin)secureAdmin), null);
                clientBuilder.hostnameVerifier((HostnameVerifier)new BasicHostnameVerifier()).sslContext(sslContext).register(CsrfProtectionFilter.class);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.WARNING, "RestUtil.initialize() failed");
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return clientBuilder;
    }

    public static void postRestRequestFromServlet(HttpServletRequest request, String endpoint, Map<String, Object> attrs, boolean quiet, boolean throwException) {
        String token = (String)request.getSession().getAttribute("__rTkn__");
        WebTarget target = JERSEY_CLIENT.target(endpoint);
        MultivaluedMap formData = RestUtil.buildMultivalueMap(attrs);
        Response cr = (Response)target.request(new String[]{RESPONSE_TYPE}).cookie(new Cookie(REST_TOKEN_COOKIE, token)).post(Entity.entity((Object)formData, (String)FORM_ENCODING), Response.class);
        RestResponse rr = RestResponse.getRestResponse(cr);
        RestUtil.parseResponse(rr, null, endpoint, attrs, quiet, throwException);
    }

    private static class RequiredHeadersFilter
    implements ClientRequestFilter {
        private RequiredHeadersFilter() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add((Object)"X-GlassFish-3", (Object)"true");
        }
    }

    private static class BasicHostnameVerifier
    implements HostnameVerifier {
        final HostnameVerifier defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

        @Override
        public boolean verify(String host, SSLSession sslSession) {
            if (host.equals("localhost")) {
                return true;
            }
            boolean result = this.defaultVerifier.verify(host, sslSession);
            return result ? true : host.equals(sslSession.getPeerHost());
        }
    }
}

