/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.lifecycle;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.eclipse.krazo.MvcContextImpl;
import org.eclipse.krazo.lifecycle.EventDispatcher;
import org.eclipse.krazo.locale.LocaleResolverChain;

@RequestScoped
public class RequestLifecycle {
    @Inject
    private EventDispatcher eventDispatcher;
    @Inject
    private LocaleResolverChain localeResolverChain;
    @Inject
    private MvcContextImpl mvc;
    private boolean controllerExecuted = false;
    private Method controllerMethod;

    public void beforeAll(ContainerRequestContext context) {
        Locale requestLocale = this.localeResolverChain.resolve(context);
        this.mvc.setLocale(requestLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundController(Method method, Callable<Object> invocation) throws Exception {
        this.controllerMethod = method;
        this.eventDispatcher.fireBeforeControllerEvent();
        try {
            Object result = invocation.call();
            this.controllerExecuted = true;
            Object object = result;
            return object;
        }
        finally {
            this.eventDispatcher.fireAfterControllerEvent();
        }
    }

    public boolean isControllerExecuted() {
        return this.controllerExecuted;
    }

    public Method getControllerMethod() {
        return this.controllerMethod;
    }
}

