/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.catalina.LogFacade;

public final class SecurityUtil {
    private static final int INIT = 0;
    private static final int SERVICE = 1;
    private static final int DOFILTER = 1;
    private static final int DESTROY = 2;
    private static final String INIT_METHOD = "init";
    private static final String DOFILTER_METHOD = "doFilter";
    private static final String SERVICE_METHOD = "service";
    private static final String DESTROY_METHOD = "destroy";
    private static HashMap<Object, Method[]> objectCache = new HashMap();
    private static final Logger log = LogFacade.getLogger();
    public static final boolean executeUnderSubjectDoAs = true;

    public static void doAsPrivilege(String methodName, Servlet targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class<?>[] targetType, Object[] targetArguments) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, targetType, targetArguments, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class<?>[] targetType, Object[] targetArguments, Principal principal) throws Exception {
        Method method = null;
        Method[] methodsCache = null;
        if (objectCache.containsKey(targetObject)) {
            methodsCache = objectCache.get(targetObject);
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        } else {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        }
        SecurityUtil.execute(method, targetObject, targetArguments, principal);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject, Class<?>[] targetType, Object[] targetArguments) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, (Class[])targetType, targetArguments, null);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject, Class[] targetType, Object[] targetArguments, Principal principal) throws Exception {
        Method method = null;
        Method[] methodsCache = null;
        if (objectCache.containsKey(targetObject)) {
            methodsCache = objectCache.get(targetObject);
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        } else {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        }
        SecurityUtil.execute(method, targetObject, targetArguments, principal);
    }

    private static void execute(Method method, Object targetObject, Object[] targetArguments, Principal principal) throws Exception {
        try {
            Subject subject = null;
            if (targetArguments != null && targetArguments[0] instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)targetArguments[0];
                boolean hasSubject = false;
                HttpSession session = request.getSession(false);
                if (session != null) {
                    subject = (Subject)session.getAttribute("javax.security.auth.subject");
                    boolean bl = hasSubject = subject != null;
                }
                if (subject == null) {
                    subject = new Subject();
                    if (principal != null) {
                        subject.getPrincipals().add(principal);
                    }
                }
                if (session != null && !hasSubject) {
                    session.setAttribute("javax.security.auth.subject", subject);
                }
            }
            PrivilegedExceptionAction<Void> pea = () -> {
                method.setAccessible(true);
                method.invoke(targetObject, targetArguments);
                return null;
            };
            Subject.doAsPrivileged(subject, pea, null);
        }
        catch (PrivilegedActionException pe) {
            Throwable e = pe.getException() instanceof InvocationTargetException ? ((InvocationTargetException)pe.getException()).getTargetException() : pe;
            log.log(Level.FINE, "AS-WEB-CORE-00322", e);
            if (e instanceof UnavailableException) {
                throw (UnavailableException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException(e.getMessage(), e);
        }
    }

    private static Method findMethod(Method[] methodsCache, String methodName) {
        if (methodName.equalsIgnoreCase(INIT_METHOD) && methodsCache[0] != null) {
            return methodsCache[0];
        }
        if (methodName.equalsIgnoreCase(DESTROY_METHOD) && methodsCache[2] != null) {
            return methodsCache[2];
        }
        if (methodName.equalsIgnoreCase(SERVICE_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        if (methodName.equalsIgnoreCase(DOFILTER_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        return null;
    }

    private static Method createMethodAndCacheIt(Method[] methodsCache, String methodName, Object targetObject, Class<?>[] targetType) throws Exception {
        if (methodsCache == null) {
            methodsCache = new Method[3];
        }
        Method method = targetObject.getClass().getMethod(methodName, targetType);
        if (methodName.equalsIgnoreCase(INIT_METHOD)) {
            methodsCache[0] = method;
        } else if (methodName.equalsIgnoreCase(DESTROY_METHOD)) {
            methodsCache[2] = method;
        } else if (methodName.equalsIgnoreCase(SERVICE_METHOD)) {
            methodsCache[1] = method;
        } else if (methodName.equalsIgnoreCase(DOFILTER_METHOD)) {
            methodsCache[1] = method;
        }
        objectCache.put(targetObject, methodsCache);
        return method;
    }

    public static void remove(Object cachedObject) {
        objectCache.remove(cachedObject);
    }
}

