/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.model.UploadedFile;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;

public final class Upload
extends Field
implements Serializable {
    private static final long serialVersionUID = -8352221221756513893L;
    public static final String INPUT_ID = "_com.sun.webui.jsf.upload";
    public static final String INPUT_PARAM_ID = "_com.sun.webui.jsf.uploadParam";
    public static final String SCRIPT_ID = "_script";
    public static final String SCRIPT_FACET = "script";
    public static final String TEXT_ID = "_text";
    public static final String LENGTH_EXCEEDED = "length_exceeded";
    public static final String UPLOAD_ERROR_KEY = "upload_error_key";
    public static final String FILE_SIZE_KEY = "file_size_key";
    private static final boolean DEBUG = false;
    private int columns = Integer.MIN_VALUE;
    private boolean columnsSet = false;

    public Upload() {
        this.setRendererType("com.sun.webui.jsf.Upload");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Upload";
    }

    @Override
    protected void log(String s) {
        LogUtil.finest(this.getClass().getName() + "::" + s);
    }

    @Override
    public Object getConvertedValue(FacesContext context, Object value) {
        String name;
        UploadedFileImpl uf = new UploadedFileImpl(value, context);
        if (this.isRequired() && uf.getSize() == 0L && ((name = uf.getOriginalName()) == null || name.trim().length() == 0)) {
            this.setValue("");
            return "";
        }
        return uf;
    }

    @Override
    public String getValueAsString(FacesContext context) {
        return null;
    }

    @Override
    public String getReadOnlyValueString(FacesContext context) {
        String valueString = null;
        Object value = this.getValue();
        if (value != null & value instanceof UploadedFile) {
            try {
                valueString = ((UploadedFile)value).getOriginalName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (valueString == null) {
            valueString = ThemeUtilities.getTheme(context).getMessage("FileUpload.noFile");
        }
        return valueString;
    }

    public String getType() {
        return "file";
    }

    @Override
    public void setText(Object text) {
    }

    @Override
    public int getColumns() {
        Object result;
        ValueExpression vb;
        int cols = this.columnsSet ? this.columns : ((vb = this.getValueExpression("columns")) != null ? ((result = vb.getValue(this.getFacesContext().getELContext())) == null ? Integer.MIN_VALUE : (Integer)result) : 40);
        if (cols < 1) {
            cols = 40;
            this.setColumns(cols);
        }
        return cols;
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            return null;
        }
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    @Override
    public ValueExpression getValueExpression(String name) {
        if (name.equals("uploadedFile")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("uploadedFile")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    @Override
    public int getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    public boolean isTrim() {
        return super.isTrim();
    }

    @Override
    public Object getText() {
        return null;
    }

    @Override
    public void setColumns(int newColumns) {
        this.columns = newColumns;
        this.columnsSet = true;
    }

    public UploadedFile getUploadedFile() {
        return (UploadedFile)this.getValue();
    }

    public void setUploadedFile(UploadedFile uploadedFile) {
        this.setValue(uploadedFile);
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.columns = (Integer)values[1];
        this.columnsSet = (Boolean)values[2];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.columns, this.columnsSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    private static final class UploadedFileImpl
    implements UploadedFile {
        private static final long serialVersionUID = -8806211528277303445L;
        private transient FileItem fileItemObject = null;

        UploadedFileImpl(Object attribute, FacesContext context) {
            try {
                this.fileItemObject = (FileItem)context.getExternalContext().getRequestMap().get(attribute);
            }
            catch (Exception e) {
                throw new FacesException("File not uploaded. Is the upload filter installed ?", (Throwable)e);
            }
        }

        @Override
        public void write(File file) throws Exception {
            if (this.fileItemObject != null) {
                this.fileItemObject.write(file);
            }
        }

        @Override
        public long getSize() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getSize();
            }
            return 0L;
        }

        @Override
        public String getOriginalName() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getName();
            }
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getInputStream();
            }
            return null;
        }

        @Override
        public String getContentType() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getContentType();
            }
            return null;
        }

        @Override
        public byte[] getBytes() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.get();
            }
            return null;
        }

        @Override
        public String getAsString() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getString();
            }
            return null;
        }

        @Override
        public void dispose() {
            if (this.fileItemObject != null) {
                this.fileItemObject.delete();
            }
        }
    }
}

