/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.CompareFilterCriteria;
import com.sun.data.provider.impl.TableRowDataProvider;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.util.Locale;
import java.util.Map;

public final class ValueExpressionFilterCriteria
extends FilterCriteria {
    private static final long serialVersionUID = 8984072154367845774L;
    private Locale compareLocale;
    private boolean matchLessThan = false;
    private boolean matchGreaterThan = false;
    private boolean matchEqualTo = true;
    private String valueExpression;
    private Object compareValue;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private final String rowProviderLock = "rowProviderLock";

    public ValueExpressionFilterCriteria() {
    }

    public ValueExpressionFilterCriteria(String newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public ValueExpressionFilterCriteria(Object newCompareValue) {
        this.compareValue = newCompareValue;
    }

    public ValueExpressionFilterCriteria(String newValueExpression, Object newCompareValue) {
        this.valueExpression = newValueExpression;
        this.compareValue = newCompareValue;
    }

    public ValueExpressionFilterCriteria(String newValueExpression, Object newCompareValue, boolean newMatchLessThan, boolean newMatchEqualTo, boolean newMatchGreaterThan) {
        this.valueExpression = newValueExpression;
        this.compareValue = newCompareValue;
        this.matchLessThan = newMatchLessThan;
        this.matchEqualTo = newMatchEqualTo;
        this.matchGreaterThan = newMatchGreaterThan;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        Object val = this.getCompareValue();
        StringBuilder sb = new StringBuilder();
        if (this.isInclude()) {
            sb.append("Include [");
        } else {
            sb.append("Exclude [");
        }
        if (this.valueExpression != null) {
            sb.append(this.valueExpression);
        } else {
            sb.append("<no value expression>");
        }
        sb.append("] ");
        boolean anyMatches = false;
        if (this.matchLessThan) {
            anyMatches = true;
            sb.append("is less than ");
        }
        if (this.matchEqualTo) {
            if (anyMatches) {
                sb.append("OR ");
            }
            anyMatches = true;
            sb.append("is equal to ");
        }
        if (this.matchGreaterThan) {
            if (anyMatches) {
                sb.append("OR ");
            }
            sb.append("is greater than ");
        }
        sb.append("[").append(val).append("]");
        return sb.toString();
    }

    public void setValueExpression(String newValueExpression) {
        this.valueExpression = newValueExpression;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String newRequestMapKey) {
        this.requestMapKey = newRequestMapKey;
    }

    public void setCompareValue(Object newCompareValue) {
        this.compareValue = newCompareValue;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public void setCompareLocale(Locale newCompareLocale) {
        this.compareLocale = newCompareLocale;
    }

    public Locale getCompareLocale() {
        return this.compareLocale;
    }

    public void setMatchEqualTo(boolean newMatchEqualTo) {
        this.matchEqualTo = newMatchEqualTo;
    }

    public boolean isMatchEqualTo() {
        return this.matchEqualTo;
    }

    public void setMatchLessThan(boolean newMatchLessThan) {
        this.matchLessThan = newMatchLessThan;
    }

    public boolean isMatchLessThan() {
        return this.matchLessThan;
    }

    public void setMatchGreaterThan(boolean newMatchGreaterThan) {
        this.matchGreaterThan = newMatchGreaterThan;
    }

    public boolean isMatchGreaterThan() {
        return this.matchGreaterThan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(TableDataProvider provider, RowKey row) {
        if (this.valueExpression == null || "".equals(this.valueExpression)) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueExpression valueBinding = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), this.valueExpression, Object.class);
        if (valueBinding == null) {
            return true;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String string = "rowProviderLock";
        synchronized ("rowProviderLock") {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            Object value = valueBinding.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            int compare = CompareFilterCriteria.compare((Object)value, (Object)this.compareValue, (Locale)this.compareLocale);
            switch (compare) {
                case -1: {
                    return this.matchLessThan;
                }
                case 0: {
                    return this.matchEqualTo;
                }
                case 1: {
                    return this.matchGreaterThan;
                }
            }
            return false;
        }
    }
}

