/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Head;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class HeadRenderer
extends AbstractRenderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"profile"};
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("head", component);
        }
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Head head = (Head)component;
        if (!RenderingUtilities.isPortlet(context)) {
            String title;
            HeadRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
            if (head.isMeta()) {
                writer.write("\n");
                HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-store");
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Expires", DATE_ONE);
                response.setHeader("X-Frame-Options", "SAMEORIGIN");
                this.renderMetaTag("no-cache", "Pragma", writer, head);
                this.renderMetaTag("no-cache", "Cache-Control", writer, head);
                this.renderMetaTag("no-store", "Cache-Control", writer, head);
                this.renderMetaTag("max-age=0", "Cache-Control", writer, head);
                this.renderMetaTag("1", "Expires", writer, head);
            }
            if ((title = head.getTitle()) == null) {
                title = "";
            }
            writer.startElement("title", (UIComponent)head);
            writer.write(title);
            writer.endElement("title");
            writer.write("\n");
            if (head.isDefaultBase()) {
                writer.startElement("base", (UIComponent)head);
                writer.writeURIAttribute("href", (Object)ComponentUtilities.getBase(context), null);
                writer.endElement("base");
                writer.write("\n");
            }
            Theme theme = ThemeUtilities.getTheme(context);
            RenderingUtilities.renderStyleSheetLink((UIComponent)head, theme, context, writer);
            if (!head.isJavaScript()) {
                return;
            }
            JavaScriptUtilities.renderHeaderScriptTags(head.isDebug(), head.isParseWidgets(), writer);
        }
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("head");
            writer.write("\n");
        }
    }

    private void renderMetaTag(String content, String httpEquivalent, ResponseWriter writer, Head head) throws IOException {
        writer.startElement("meta", (UIComponent)head);
        writer.writeAttribute("content", (Object)content, null);
        writer.writeAttribute("http-equiv", (Object)httpEquivalent, null);
        writer.endElement("meta");
        writer.writeText((Object)"\n", null);
    }
}

