/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.StringValidator;
import com.sun.enterprise.admin.servermgmt.Validator;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

public class FileValidator
extends Validator {
    public static final String validConstraints = "drwx";
    private static final StringManager strMgr = StringManager.getManager(FileValidator.class);
    private String constraints = "r";

    public FileValidator(String name, String constraints) {
        super(name, String.class);
        if (this.isValidConstraints(constraints)) {
            this.constraints = constraints;
        }
    }

    public String getConstraints() {
        return this.constraints;
    }

    public String setConstraints(String constraints) {
        if (this.isValidConstraints(constraints)) {
            this.constraints = constraints;
        }
        return this.constraints;
    }

    @Override
    public void validate(Object str) throws InvalidConfigException {
        super.validate(str);
        new StringValidator(this.getName()).validate(str);
        File f = new File((String)str);
        this.validateConstraints(f);
    }

    void validateConstraints(File file) throws InvalidConfigException {
        File f = FileUtils.safeGetCanonicalFile((File)file);
        String constriants = this.getConstraints();
        char[] ca = constriants.toCharArray();
        block6: for (int i = 0; i < ca.length; ++i) {
            switch (ca[i]) {
                case 'r': {
                    if (f.canRead()) continue block6;
                    throw new InvalidConfigException(strMgr.getString("fileValidator.no_read", (Object)f.getAbsolutePath()));
                }
                case 'w': {
                    if (f.canWrite()) continue block6;
                    throw new InvalidConfigException(strMgr.getString("fileValidator.no_write", (Object)f.getAbsolutePath()));
                }
                case 'd': {
                    if (f.isDirectory()) continue block6;
                    throw new InvalidConfigException(strMgr.getString("fileValidator.not_a_dir", (Object)f.getAbsolutePath()));
                }
                case 'x': {
                    continue block6;
                }
            }
        }
    }

    boolean isValidConstraints(String constraints) {
        if (constraints == null) {
            return false;
        }
        int length = constraints.length();
        if (length == 0 || length > 4) {
            return false;
        }
        boolean isValid = true;
        block3: for (int i = 0; i < length; ++i) {
            char ch = constraints.charAt(i);
            switch (ch) {
                case 'd': 
                case 'r': 
                case 'w': 
                case 'x': {
                    continue block3;
                }
                default: {
                    isValid = false;
                }
            }
        }
        return isValid;
    }
}

