/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ConfigModelComparator;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.glassfish.admin.rest.utils.SseCommandHelper;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public class ResourceUtil {
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    private static RestConfig restConfig = null;
    static final Pattern TOKENIZER;

    protected static byte[] getBytesFromStream(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = null;
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            bytes = buffer.toByteArray();
            buffer.close();
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00016", ex.getMessage());
        }
        return bytes;
    }

    private ResourceUtil() {
    }

    public static void adjustParameters(Map<String, String> data) {
        boolean isRenamed;
        if (data != null && !data.containsKey("DEFAULT") && !(isRenamed = ResourceUtil.renameParameter(data, "id", "DEFAULT"))) {
            ResourceUtil.renameParameter(data, "name", "DEFAULT");
        }
    }

    public static void defineDefaultParameters(Map<String, String> data) {
        if (data != null && !data.containsKey("DEFAULT")) {
            ResourceUtil.renameParameter(data, "id", "DEFAULT");
        }
    }

    public static String getCommand(RestRedirect.OpType type, ConfigModel model) {
        RestRedirects restRedirects;
        Class<?> cbp = null;
        try {
            cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
        }
        catch (MultiException e) {
            e.printStackTrace();
        }
        if (cbp != null && (restRedirects = cbp.getAnnotation(RestRedirects.class)) != null) {
            RestRedirect[] values;
            for (RestRedirect r : values = restRedirects.value()) {
                if (!r.opType().equals((Object)type)) continue;
                return r.commandName();
            }
        }
        return null;
    }

    public static RestActionReporter runCommand(String commandName, ParameterMap parameters, Subject subject) {
        return ResourceUtil.runCommand(commandName, parameters, subject, false);
    }

    public static RestActionReporter runCommand(String commandName, ParameterMap parameters, Subject subject, boolean managedJob) {
        CommandRunner cr = Globals.getDefaultHabitat().getService(CommandRunner.class, new Annotation[0]);
        RestActionReporter ar = new RestActionReporter();
        CommandRunner.CommandInvocation commandInvocation = cr.getCommandInvocation(commandName, (ActionReport)ar, subject);
        if (managedJob) {
            commandInvocation.managedJob();
        }
        commandInvocation.parameters(parameters).execute();
        ResourceUtil.addCommandLog(ar, commandName, parameters);
        return ar;
    }

    public static RestActionReporter runCommand(String commandName, Map<String, String> parameters, Subject subject) {
        ParameterMap p = new ParameterMap();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            p.set((Object)entry.getKey(), (Object)entry.getValue());
        }
        return ResourceUtil.runCommand(commandName, p, subject);
    }

    public static EventOutput runCommandWithSse(final String commandName, final ParameterMap parameters, Subject subject, final SseCommandHelper.ActionReportProcessor processor) {
        CommandRunner cr = Globals.getDefaultHabitat().getService(CommandRunner.class, new Annotation[0]);
        final RestActionReporter ar = new RestActionReporter();
        CommandRunner.CommandInvocation commandInvocation = cr.getCommandInvocation(commandName, (ActionReport)ar, subject).parameters(parameters);
        return SseCommandHelper.invokeAsync(commandInvocation, new SseCommandHelper.ActionReportProcessor(){

            @Override
            public ActionReport process(ActionReport report, EventOutput ec) {
                ResourceUtil.addCommandLog(ar, commandName, parameters);
                if (processor != null) {
                    return processor.process(report, ec);
                }
                return ar;
            }
        });
    }

    public static void addCommandLog(RestActionReporter ar, String commandName, ParameterMap parameters) {
        ArrayList<CallSite> logs = (ArrayList<CallSite>)ar.getExtraProperties().get("commandLog");
        if (logs == null) {
            logs = new ArrayList<CallSite>();
            ar.getExtraProperties().put("commandLog", logs);
        }
        String parameterList = ResourceUtil.encodeString(ResourceUtil.getParameterList(parameters));
        logs.add((CallSite)((Object)(commandName + parameterList)));
    }

    public static String encodeString(String text) {
        if (text == null) {
            return "";
        }
        String result = text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        result = result.replaceAll("eval\\((.*)\\)", "");
        result = result.replaceAll("[\\\"\\'][\\s]*((?i)javascript):(.*)[\\\"\\']", "\"\"");
        result = result.replaceAll("((?i)script)", "");
        return result;
    }

    public static String getParameterList(ParameterMap parameters) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : parameters.entrySet()) {
            String paramName = (String)entry.getKey();
            for (String param : (List)entry.getValue()) {
                sb.append(" --").append(paramName).append(" ").append(param);
            }
        }
        return sb.toString();
    }

    public static MethodMetaData getMethodMetaData(String command, ServiceLocator habitat) {
        return ResourceUtil.getMethodMetaData(command, null, habitat);
    }

    public static MethodMetaData getMethodMetaData(String command, HashMap<String, String> commandParamsToSkip, ServiceLocator habitat) {
        Collection<CommandModel.ParamModel> params;
        MethodMetaData methodMetaData = new MethodMetaData();
        if (command != null && (params = commandParamsToSkip == null ? ResourceUtil.getParamMetaData(command, habitat) : ResourceUtil.getParamMetaData(command, commandParamsToSkip.keySet(), habitat)) != null) {
            for (CommandModel.ParamModel paramModel : params) {
                Param param = paramModel.getParam();
                ParameterMetaData parameterMetaData = ResourceUtil.getParameterMetaData(paramModel);
                String parameterName = param.primary() ? "id" : paramModel.getName();
                String alias = param.alias();
                if (alias != null && !alias.isEmpty()) {
                    parameterName = alias;
                }
                methodMetaData.putParameterMetaData(parameterName, parameterMetaData);
            }
        }
        return methodMetaData;
    }

    public static void resolveParamValues(Map<String, String> commandParams, UriInfo uriInfo) {
        List pathSegments = uriInfo.getPathSegments();
        HashMap<String, String> processParams = new HashMap<String, String>();
        processParams.putAll(commandParams);
        for (Map.Entry<String, String> entry : commandParams.entrySet()) {
            String value = entry.getValue();
            if (value.equals("$parent")) {
                processParams.put(entry.getKey(), ((PathSegment)pathSegments.get(pathSegments.size() - 2)).getPath());
                continue;
            }
            if (!value.startsWith("$grandparent")) continue;
            int number = value.equals("$grandparent") ? 1 : Integer.parseInt(value.substring("$grandparent".length()));
            processParams.put(entry.getKey(), ((PathSegment)pathSegments.get(pathSegments.size() - (number + 2))).getPath());
        }
        commandParams.clear();
        commandParams.putAll(processParams);
    }

    public static MethodMetaData getMethodMetaData(ConfigModel configBeanModel) {
        MethodMetaData methodMetaData = new MethodMetaData();
        Class<?> configBeanProxy = null;
        try {
            configBeanProxy = configBeanModel.classLoaderHolder.loadClass(configBeanModel.targetTypeName);
            Set attributeNames = configBeanModel.getAttributeNames();
            for (String attributeName : attributeNames) {
                Attribute attribute;
                String methodName = ResourceUtil.getAttributeMethodName(attributeName);
                Method method = null;
                try {
                    method = configBeanProxy.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    String booleanMethodName = ResourceUtil.getAttributeBooleanMethodName(attributeName);
                    for (Method m : configBeanProxy.getMethods()) {
                        if (!m.getName().equalsIgnoreCase(methodName) && !m.getName().equalsIgnoreCase(booleanMethodName)) continue;
                        method = m;
                    }
                }
                if ((attribute = method.getAnnotation(Attribute.class)) == null) continue;
                ParameterMetaData parameterMetaData = ResourceUtil.getParameterMetaData(attribute);
                if (method.getAnnotation(Deprecated.class) != null) {
                    parameterMetaData.putAttribute("deprecated", "true");
                }
                attributeName = Util.eleminateHypen(attributeName);
                methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
            }
        }
        catch (MultiException e) {
            e.printStackTrace();
        }
        return methodMetaData;
    }

    public static MethodMetaData getMethodMetaData2(Dom parent, ConfigModel childModel, int parameterType) {
        MethodMetaData methodMetaData = new MethodMetaData();
        ArrayList interfaces = new ArrayList();
        HashMap<String, ParameterMetaData> params = new HashMap<String, ParameterMetaData>();
        try {
            Class<?> configBeanProxy = childModel.classLoaderHolder.loadClass(childModel.targetTypeName);
            ResourceUtil.getInterfaces(configBeanProxy, interfaces);
            Set attributeNames = childModel.getAttributeNames();
            for (String attributeName : attributeNames) {
                String methodName = ResourceUtil.getAttributeMethodName(attributeName);
                ParameterMetaData parameterMetaData = (ParameterMetaData)params.get(attributeName = Util.eleminateHypen(attributeName));
                if (parameterMetaData == null) {
                    parameterMetaData = new ParameterMetaData();
                    params.put(attributeName, parameterMetaData);
                }
                for (int i = interfaces.size() - 1; i >= 0; --i) {
                    Class intf = (Class)interfaces.get(i);
                    try {
                        Method method = intf.getMethod(methodName, new Class[0]);
                        Attribute attribute = method.getAnnotation(Attribute.class);
                        if (attribute == null) continue;
                        ParameterMetaData localParam = ResourceUtil.getParameterMetaData(attribute);
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "defaultValue");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "key");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "type");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "optional");
                        continue;
                    }
                    catch (NoSuchMethodException method) {
                        // empty catch block
                    }
                }
                try {
                    Method method = configBeanProxy.getMethod(methodName, new Class[0]);
                    Attribute attribute = method.getAnnotation(Attribute.class);
                    if (attribute != null) {
                        ParameterMetaData localParam = ResourceUtil.getParameterMetaData(attribute);
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "defaultValue");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "key");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "type");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "optional");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
            }
        }
        catch (MultiException cnfe) {
            throw new RuntimeException(cnfe);
        }
        return methodMetaData;
    }

    protected static void copyParameterMetaDataAttribute(ParameterMetaData from, ParameterMetaData to, String key) {
        if (from.getAttributeValue(key) != null) {
            to.putAttribute(key, from.getAttributeValue(key));
        }
    }

    protected static void getInterfaces(Class<?> clazz, List<Class<?>> interfaces) {
        for (Class<?> intf : clazz.getInterfaces()) {
            interfaces.add(intf);
            ResourceUtil.getInterfaces(intf, interfaces);
        }
    }

    public static boolean commandIsPresent(ServiceLocator habitat, String commandName) {
        try {
            habitat.getService(AdminCommand.class, commandName, new Annotation[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<CommandModel.ParamModel> getParamMetaData(String commandName, ServiceLocator habitat) {
        CommandModel model = habitat.getService(CommandRunner.class, new Annotation[0]).getModel(commandName, RestLogging.restLogger);
        if (model == null) {
            return null;
        }
        return model.getParameters();
    }

    public static Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Collection<String> commandParamsToSkip, ServiceLocator habitat) {
        CommandModel cm = habitat.getService(CommandRunner.class, new Annotation[0]).getModel(commandName, RestLogging.restLogger);
        Collection parameterNames = cm.getParametersNames();
        ArrayList<CommandModel.ParamModel> metaData = new ArrayList<CommandModel.ParamModel>();
        for (String name : parameterNames) {
            CommandModel.ParamModel paramModel = cm.getModelFor(name);
            String parameterName = paramModel.getParam().primary() ? "id" : paramModel.getName();
            if (commandParamsToSkip.contains(parameterName)) continue;
            metaData.add(paramModel);
        }
        return metaData;
    }

    public static void purgeEmptyEntries(Map<String, String> data) {
        if ("true".equals(data.get("__remove_empty_entries__"))) {
            data.remove("__remove_empty_entries__");
            Iterator<Map.Entry<String, String>> i = data.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> entry = i.next();
                String value = entry.getValue();
                if (value != null && value.length() >= 1) continue;
                i.remove();
            }
        }
    }

    public static Response getResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, false);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public static ActionReportResult getActionReportResult(ActionReport.ExitCode status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(status);
        return ResourceUtil.getActionReportResult(ar, message, requestHeaders, uriInfo);
    }

    public static ActionReportResult getActionReportResult(RestActionReporter ar, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, false);
        }
        ActionReport.ExitCode status = ar.getActionExitCode();
        ActionReportResult result = new ActionReportResult(ar);
        if (status != ActionReport.ExitCode.SUCCESS && status != ActionReport.ExitCode.WARNING) {
            result.setErrorMessage(message);
            result.setIsError(true);
        }
        ar.setActionExitCode(status);
        ar.setMessage(message);
        return result;
    }

    public static Response getDeleteResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, true);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public static void addQueryString(MultivaluedMap<String, String> qs, Map<String, String> data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                try {
                    data.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static void addQueryString(MultivaluedMap<String, String> qs, Properties data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.put(key, value);
            }
        }
    }

    static ParameterMetaData getParameterMetaData(CommandModel.ParamModel paramModel) {
        Param param = paramModel.getParam();
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", ResourceUtil.getXsdType(paramModel.getType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(param.optional()));
        String val = param.defaultValue();
        if (val != null && !val.equals("\u0000")) {
            parameterMetaData.putAttribute("defaultValue", param.defaultValue());
        }
        parameterMetaData.putAttribute("acceptableValues", param.acceptableValues());
        return parameterMetaData;
    }

    static ParameterMetaData getParameterMetaData(Attribute attribute) {
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", ResourceUtil.getXsdType(attribute.dataType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(!attribute.required()));
        if (!attribute.defaultValue().equals("\u0000")) {
            parameterMetaData.putAttribute("defaultValue", attribute.defaultValue());
        }
        parameterMetaData.putAttribute("key", Boolean.toString(attribute.key()));
        return parameterMetaData;
    }

    private static boolean renameParameter(Map<String, String> data, String parameterToRename, String newName) {
        if (data.containsKey(parameterToRename)) {
            String value = data.get(parameterToRename);
            data.remove(parameterToRename);
            data.put(newName, value);
            return true;
        }
        return false;
    }

    private static boolean isBrowser(HttpHeaders requestHeaders) {
        boolean isClientAcceptsHtml = false;
        MediaType media = requestHeaders.getMediaType();
        List acceptHeaders = requestHeaders.getRequestHeader("Accept");
        for (String header : acceptHeaders) {
            if (!header.contains("text/html")) continue;
            isClientAcceptsHtml = true;
            break;
        }
        return media != null && media.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && isClientAcceptsHtml;
    }

    private static String getXsdType(String javaType) {
        if (javaType.indexOf("java.lang.String") != -1) {
            return "string";
        }
        if (javaType.indexOf("java.lang.Boolean") != -1) {
            return "boolean";
        }
        if (javaType.indexOf("java.lang.Integer") != -1) {
            return "int";
        }
        if (javaType.indexOf("java.util.Properties") != -1) {
            return "string";
        }
        return javaType;
    }

    public static String getAttributeMethodName(String attributeName) {
        return Util.methodNameFromDtdName(attributeName, "get");
    }

    public static String getAttributeBooleanMethodName(String attributeName) {
        return Util.methodNameFromDtdName(attributeName, "is");
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    public static String convertToXMLName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase(Locale.US));
        }
        return buf.toString();
    }

    public static HashMap<String, String> translateCamelCasedNamesToXMLNames(Map<String, String> sourceData) {
        HashMap<String, String> convertedData = new HashMap<String, String>(sourceData.size());
        for (Map.Entry<String, String> entry : sourceData.entrySet()) {
            String camelCasedKeyName = entry.getKey();
            String xmlKeyName = ResourceUtil.convertToXMLName(camelCasedKeyName);
            convertedData.put(xmlKeyName, entry.getValue());
        }
        return convertedData;
    }

    public static String getResultType(HttpHeaders requestHeaders) {
        String result = "html";
        String firstOne = null;
        List lmt = requestHeaders.getAcceptableMediaTypes();
        for (MediaType mt : lmt) {
            if (mt.getSubtype().equals("html")) {
                return result;
            }
            if (mt.getSubtype().equals("*")) {
                return result;
            }
            if (firstOne != null) continue;
            firstOne = mt.getSubtype();
        }
        return firstOne == null ? result : firstOne;
    }

    public static Map buildMethodMetadataMap(MethodMetaData mmd) {
        TreeMap<String, Map<String, String>> map = new TreeMap<String, Map<String, String>>();
        Set<String> params = mmd.parameters();
        for (String param : params) {
            ParameterMetaData parameterMetaData = mmd.getParameterMetaData(param);
            map.put(param, ResourceUtil.processAttributes(parameterMetaData.attributes(), parameterMetaData));
        }
        return map;
    }

    private static Map<String, String> processAttributes(Set<String> attributes, ParameterMetaData parameterMetaData) {
        HashMap<String, String> pmdm = new HashMap<String, String>();
        for (String attributeName : attributes) {
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            pmdm.put(attributeName, attributeValue);
        }
        return pmdm;
    }

    public static boolean isDeprecated(ConfigModel model) {
        try {
            Class<?> cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
            Deprecated dep = cbp.getAnnotation(Deprecated.class);
            return dep != null;
        }
        catch (MultiException multiException) {
            return false;
        }
    }

    public static Map<String, String> getResourceLinks(Dom dom, UriInfo uriInfo, boolean canShowDeprecated) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        for (String elementName : dom.model.getElementNames()) {
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)dom.model.getElement(elementName);
                ConfigModel childModel = node.getModel();
                List<ConfigModel> lcm = ResourceUtil.getRealChildConfigModels(childModel, dom.document);
                Collections.sort(lcm, new ConfigModelComparator());
                for (ConfigModel cmodel : lcm) {
                    if (ResourceUtil.isDeprecated(cmodel) && !canShowDeprecated) continue;
                    links.put(cmodel.getTagName(), ProviderUtil.getElementLink(uriInfo, cmodel.getTagName()));
                }
                continue;
            }
            ConfigModel.Property childElement = dom.model.getElement(elementName);
            boolean deprec = false;
            if (childElement instanceof ConfigModel.Node) {
                ConfigModel.Node node = (ConfigModel.Node)childElement;
                deprec = ResourceUtil.isDeprecated(node.getModel());
            }
            for (String annotation : childElement.getAnnotations()) {
                if (!annotation.equals(Deprecated.class.getName())) continue;
                deprec = true;
            }
            if (deprec && !canShowDeprecated) continue;
            links.put(elementName, ProviderUtil.getElementLink(uriInfo, elementName));
        }
        String beanName = ResourceUtil.getUnqualifiedTypeName(dom.model.targetTypeName);
        for (CommandResourceMetaData cmd : CommandResourceMetaData.getCustomResourceMapping(beanName)) {
            links.put(cmd.resourcePath, ProviderUtil.getElementLink(uriInfo, cmd.resourcePath));
        }
        return links;
    }

    public static String getUnqualifiedTypeName(String qualifiedTypeName) {
        return qualifiedTypeName.substring(qualifiedTypeName.lastIndexOf(".") + 1, qualifiedTypeName.length());
    }

    public static boolean isOnlyATag(ConfigModel model) {
        return model.getAttributeNames().isEmpty() && model.getElementNames().isEmpty();
    }

    public static List<ConfigModel> getRealChildConfigModels(ConfigModel childModel, DomDocument domDocument) {
        ArrayList<ConfigModel> retlist = new ArrayList<ConfigModel>();
        try {
            Class<?> subType = childModel.classLoaderHolder.loadClass(childModel.targetTypeName);
            List list = domDocument.getAllModelsImplementing(subType);
            if (list != null) {
                for (ConfigModel el : list) {
                    if (ResourceUtil.isOnlyATag(el)) {
                        retlist.addAll(ResourceUtil.getRealChildConfigModels(el, domDocument));
                        continue;
                    }
                    retlist.add(el);
                }
            } else if (!ResourceUtil.isOnlyATag(childModel)) {
                retlist.add(childModel);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return retlist;
    }

    private static String getKey(Dom model) {
        String key = model.getKey();
        if (key == null) {
            for (String s : model.getAttributeNames()) {
                if (!s.equals("name")) continue;
                key = model.attribute(s);
            }
            if (key == null) {
                Set attributeNames = model.getAttributeNames();
                if (!attributeNames.isEmpty()) {
                    key = model.attribute((String)attributeNames.iterator().next());
                } else {
                    key = "ThisIsAModelBug:NoKeyAttr";
                    key = "";
                }
            }
        }
        return key;
    }

    public static Map<String, String> getResourceLinks(List<Dom> proxyList, UriInfo uriInfo) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Collections.sort(proxyList, new DomConfigurator());
        for (Dom proxy : proxyList) {
            try {
                links.put(ResourceUtil.getKey(proxy), ProviderUtil.getElementLink(uriInfo, ResourceUtil.getKey(proxy)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return links;
    }

    public static List<Map<String, String>> getCommandLinks(String[][] commandResourcesPaths) {
        ArrayList<Map<String, String>> commands = new ArrayList<Map<String, String>>();
        for (String[] array : commandResourcesPaths) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put("command", array[0]);
            command.put("method", array[1]);
            command.put("path", array[2]);
            commands.add(command);
        }
        return commands;
    }

    public static void addMethodMetaData(ActionReport ar, Map<String, MethodMetaData> mmd) {
        MethodMetaData deleteMetaData;
        ArrayList methodMetaData = new ArrayList();
        MethodMetaData getMetaData = mmd.get("GET");
        methodMetaData.add(new HashMap(){
            {
                this.put("name", "GET");
            }
        });
        if (getMetaData != null) {
            HashMap<String, Map> getMetaDataMap = new HashMap<String, Map>();
            if (getMetaData.sizeParameterMetaData() > 0) {
                getMetaDataMap.put(MESSAGE_PARAMETERS, ResourceUtil.buildMethodMetadataMap(getMetaData));
            }
            methodMetaData.add(getMetaDataMap);
        }
        MethodMetaData postMetaData = mmd.get("POST");
        HashMap<String, Object> postMetaDataMap = new HashMap<String, Object>();
        if (postMetaData != null) {
            postMetaDataMap.put("name", "POST");
            if (postMetaData.sizeParameterMetaData() > 0) {
                postMetaDataMap.put(MESSAGE_PARAMETERS, ResourceUtil.buildMethodMetadataMap(postMetaData));
            }
            methodMetaData.add(postMetaDataMap);
        }
        if ((deleteMetaData = mmd.get("DELETE")) != null) {
            HashMap<String, Object> deleteMetaDataMap = new HashMap<String, Object>();
            deleteMetaDataMap.put("name", "DELETE");
            deleteMetaDataMap.put(MESSAGE_PARAMETERS, ResourceUtil.buildMethodMetadataMap(deleteMetaData));
            methodMetaData.add(deleteMetaDataMap);
        }
        ar.getExtraProperties().put("methods", methodMetaData);
    }

    public static synchronized RestConfig getRestConfig(ServiceLocator habitat) {
        if (restConfig == null) {
            Config config;
            if (habitat == null) {
                return null;
            }
            Domain domain = Globals.getDefaultBaseServiceLocator().getService(Domain.class, new Annotation[0]);
            if (domain != null && (config = domain.getConfigNamed("server-config")) != null) {
                restConfig = (RestConfig)config.getExtensionByType(RestConfig.class);
            }
        }
        return restConfig;
    }

    public static boolean canShowDeprecatedItems(ServiceLocator habitat) {
        RestConfig rg = ResourceUtil.getRestConfig(habitat);
        return rg != null && rg.getShowDeprecatedItems().equalsIgnoreCase("true");
    }

    public static Subject authenticateViaAdminRealm(ServiceLocator habitat, Request req, String remoteHost) throws LoginException, IOException {
        Subject subject = null;
        AdminAccessController authenticator = habitat.getService(AdminAccessController.class, new Annotation[0]);
        if (authenticator != null) {
            subject = authenticator.loginAsAdmin(req, remoteHost);
        }
        return subject;
    }

    public static boolean isAuthorized(ServiceLocator serviceLocator, Subject subject, String resource, String action) throws URISyntaxException {
        AuthorizationService authorizationSvc = serviceLocator.getService(AuthorizationService.class, new Annotation[0]);
        return authorizationSvc.isAuthorized(subject, new URI("admin", resource, null), action);
    }

    static {
        String pattern = ResourceUtil.or(ResourceUtil.split("x", "X"), ResourceUtil.split("X", "Xx"), ResourceUtil.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

