/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Roles {
    public static void doRoles(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ROLEID, GRANTEE, GRANTOR, WITHADMINOPTION FROM SYS.SYSROLES WHERE ISDEF = 'Y'");
        DB_Roles.generateRoleDefinitions(resultSet);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT ROLEID, GRANTEE, GRANTOR, WITHADMINOPTION FROM SYS.SYSROLES WHERE ISDEF = 'N'");
        DB_Roles.generateRoleGrants(resultSet);
        resultSet.close();
        statement.close();
    }

    private static void generateRoleDefinitions(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_Role_definitions_header");
                Logs.reportString("----------------------------------------------\n");
            }
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            Logs.writeToNewDDL(DB_Roles.roleDefinitionStatement(resultSet, string));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String roleDefinitionStatement(ResultSet resultSet, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("CREATE ROLE ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static void generateRoleGrants(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            if (bl) {
                bl = false;
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_Role_grants_header");
                Logs.reportString("----------------------------------------------\n");
            }
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            boolean bl2 = resultSet.getString(4).equals("Y");
            Logs.writeToNewDDL(DB_Roles.roleGrantStatement(resultSet, string, string2, bl2));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
        }
    }

    private static String roleGrantStatement(ResultSet resultSet, String string, String string2, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("GRANT ");
        stringBuffer.append(string);
        stringBuffer.append(" TO ");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append(" WITH ADMIN OPTION");
        }
        return stringBuffer.toString();
    }
}

